@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.inputs

import com.pulumi.aws.codebuild.inputs.ProjectSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property buildStatusConfig Configuration block that contains information that defines how the build project reports the build status to the source provider. This option is only used when the source provider is GitHub, GitHub Enterprise, GitLab, GitLab Self Managed, or Bitbucket. `build_status_config` blocks are documented below.
 * @property buildspec Build specification to use for this build project's related builds. This must be set when `type` is `NO_SOURCE`. Also, if a non-default buildspec file name or file path aside from the root is used, it must be specified.
 * @property gitCloneDepth Truncate git history to this many commits. Use `0` for a `Full` checkout which you need to run commands like `git branch --show-current`. See [AWS CodePipeline User Guide: Tutorial: Use full clone with a GitHub pipeline source](https://docs.aws.amazon.com/codepipeline/latest/userguide/tutorials-github-gitclone.html) for details.
 * @property gitSubmodulesConfig Configuration block. Detailed below.
 * @property insecureSsl Ignore SSL warnings when connecting to source control.
 * @property location Location of the source code from git or s3.
 * @property reportBuildStatus Whether to report the status of a build's start and finish to your source provider. This option is valid only when your source provider is GitHub, GitHub Enterprise, GitLab, GitLab Self Managed, or Bitbucket.
 * @property type Type of repository that contains the source code to be built. Valid values: `BITBUCKET`, `CODECOMMIT`, `CODEPIPELINE`, `GITHUB`, `GITHUB_ENTERPRISE`, `GITLAB`, `GITLAB_SELF_MANAGED`, `NO_SOURCE`, `S3`.
 */
public data class ProjectSourceArgs(
    public val buildStatusConfig: Output<ProjectSourceBuildStatusConfigArgs>? = null,
    public val buildspec: Output<String>? = null,
    public val gitCloneDepth: Output<Int>? = null,
    public val gitSubmodulesConfig: Output<ProjectSourceGitSubmodulesConfigArgs>? = null,
    public val insecureSsl: Output<Boolean>? = null,
    public val location: Output<String>? = null,
    public val reportBuildStatus: Output<Boolean>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.codebuild.inputs.ProjectSourceArgs> {
    override fun toJava(): com.pulumi.aws.codebuild.inputs.ProjectSourceArgs =
        com.pulumi.aws.codebuild.inputs.ProjectSourceArgs.builder()
            .buildStatusConfig(buildStatusConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .buildspec(buildspec?.applyValue({ args0 -> args0 }))
            .gitCloneDepth(gitCloneDepth?.applyValue({ args0 -> args0 }))
            .gitSubmodulesConfig(
                gitSubmodulesConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .insecureSsl(insecureSsl?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .reportBuildStatus(reportBuildStatus?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectSourceArgs].
 */
@PulumiTagMarker
public class ProjectSourceArgsBuilder internal constructor() {
    private var buildStatusConfig: Output<ProjectSourceBuildStatusConfigArgs>? = null

    private var buildspec: Output<String>? = null

    private var gitCloneDepth: Output<Int>? = null

    private var gitSubmodulesConfig: Output<ProjectSourceGitSubmodulesConfigArgs>? = null

    private var insecureSsl: Output<Boolean>? = null

    private var location: Output<String>? = null

    private var reportBuildStatus: Output<Boolean>? = null

    private var type: Output<String>? = null

    /**
     * @param value Configuration block that contains information that defines how the build project reports the build status to the source provider. This option is only used when the source provider is GitHub, GitHub Enterprise, GitLab, GitLab Self Managed, or Bitbucket. `build_status_config` blocks are documented below.
     */
    @JvmName("evhlejmxluvphqsl")
    public suspend fun buildStatusConfig(`value`: Output<ProjectSourceBuildStatusConfigArgs>) {
        this.buildStatusConfig = value
    }

    /**
     * @param value Build specification to use for this build project's related builds. This must be set when `type` is `NO_SOURCE`. Also, if a non-default buildspec file name or file path aside from the root is used, it must be specified.
     */
    @JvmName("mmnjwrxlrwcpnchx")
    public suspend fun buildspec(`value`: Output<String>) {
        this.buildspec = value
    }

    /**
     * @param value Truncate git history to this many commits. Use `0` for a `Full` checkout which you need to run commands like `git branch --show-current`. See [AWS CodePipeline User Guide: Tutorial: Use full clone with a GitHub pipeline source](https://docs.aws.amazon.com/codepipeline/latest/userguide/tutorials-github-gitclone.html) for details.
     */
    @JvmName("pruxdyijdvdfyyau")
    public suspend fun gitCloneDepth(`value`: Output<Int>) {
        this.gitCloneDepth = value
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("whwfarhgelnwrulg")
    public suspend fun gitSubmodulesConfig(`value`: Output<ProjectSourceGitSubmodulesConfigArgs>) {
        this.gitSubmodulesConfig = value
    }

    /**
     * @param value Ignore SSL warnings when connecting to source control.
     */
    @JvmName("ffmfofvwqgbboonj")
    public suspend fun insecureSsl(`value`: Output<Boolean>) {
        this.insecureSsl = value
    }

    /**
     * @param value Location of the source code from git or s3.
     */
    @JvmName("yeidsmglrrmmqukw")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Whether to report the status of a build's start and finish to your source provider. This option is valid only when your source provider is GitHub, GitHub Enterprise, GitLab, GitLab Self Managed, or Bitbucket.
     */
    @JvmName("yqpkhdwdtuboxmyr")
    public suspend fun reportBuildStatus(`value`: Output<Boolean>) {
        this.reportBuildStatus = value
    }

    /**
     * @param value Type of repository that contains the source code to be built. Valid values: `BITBUCKET`, `CODECOMMIT`, `CODEPIPELINE`, `GITHUB`, `GITHUB_ENTERPRISE`, `GITLAB`, `GITLAB_SELF_MANAGED`, `NO_SOURCE`, `S3`.
     */
    @JvmName("mpvjrwthupkcvlae")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Configuration block that contains information that defines how the build project reports the build status to the source provider. This option is only used when the source provider is GitHub, GitHub Enterprise, GitLab, GitLab Self Managed, or Bitbucket. `build_status_config` blocks are documented below.
     */
    @JvmName("byaxjrbuvhnxsmxu")
    public suspend fun buildStatusConfig(`value`: ProjectSourceBuildStatusConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buildStatusConfig = mapped
    }

    /**
     * @param argument Configuration block that contains information that defines how the build project reports the build status to the source provider. This option is only used when the source provider is GitHub, GitHub Enterprise, GitLab, GitLab Self Managed, or Bitbucket. `build_status_config` blocks are documented below.
     */
    @JvmName("lskhcvehhcglyinp")
    public suspend fun buildStatusConfig(argument: suspend ProjectSourceBuildStatusConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ProjectSourceBuildStatusConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.buildStatusConfig = mapped
    }

    /**
     * @param value Build specification to use for this build project's related builds. This must be set when `type` is `NO_SOURCE`. Also, if a non-default buildspec file name or file path aside from the root is used, it must be specified.
     */
    @JvmName("doqwntsajhqhwdqb")
    public suspend fun buildspec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buildspec = mapped
    }

    /**
     * @param value Truncate git history to this many commits. Use `0` for a `Full` checkout which you need to run commands like `git branch --show-current`. See [AWS CodePipeline User Guide: Tutorial: Use full clone with a GitHub pipeline source](https://docs.aws.amazon.com/codepipeline/latest/userguide/tutorials-github-gitclone.html) for details.
     */
    @JvmName("liaupuqojhwhfurs")
    public suspend fun gitCloneDepth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gitCloneDepth = mapped
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("xwqpssuctkgpxstv")
    public suspend fun gitSubmodulesConfig(`value`: ProjectSourceGitSubmodulesConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gitSubmodulesConfig = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("uuxkhygegvoaaqjc")
    public suspend fun gitSubmodulesConfig(argument: suspend ProjectSourceGitSubmodulesConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ProjectSourceGitSubmodulesConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.gitSubmodulesConfig = mapped
    }

    /**
     * @param value Ignore SSL warnings when connecting to source control.
     */
    @JvmName("shfmnscngqgwnxkj")
    public suspend fun insecureSsl(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.insecureSsl = mapped
    }

    /**
     * @param value Location of the source code from git or s3.
     */
    @JvmName("slmbgojqontniome")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Whether to report the status of a build's start and finish to your source provider. This option is valid only when your source provider is GitHub, GitHub Enterprise, GitLab, GitLab Self Managed, or Bitbucket.
     */
    @JvmName("ktkopmpqaomsrdrb")
    public suspend fun reportBuildStatus(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reportBuildStatus = mapped
    }

    /**
     * @param value Type of repository that contains the source code to be built. Valid values: `BITBUCKET`, `CODECOMMIT`, `CODEPIPELINE`, `GITHUB`, `GITHUB_ENTERPRISE`, `GITLAB`, `GITLAB_SELF_MANAGED`, `NO_SOURCE`, `S3`.
     */
    @JvmName("rtxideutwnxfoxsh")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ProjectSourceArgs = ProjectSourceArgs(
        buildStatusConfig = buildStatusConfig,
        buildspec = buildspec,
        gitCloneDepth = gitCloneDepth,
        gitSubmodulesConfig = gitSubmodulesConfig,
        insecureSsl = insecureSsl,
        location = location,
        reportBuildStatus = reportBuildStatus,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
