@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.inputs

import com.pulumi.aws.codebuild.inputs.ProjectVpcConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property securityGroupIds Security group IDs to assign to running builds.
 * @property subnets Subnet IDs within which to run builds.
 * @property vpcId ID of the VPC within which to run builds.
 */
public data class ProjectVpcConfigArgs(
    public val securityGroupIds: Output<List<String>>,
    public val subnets: Output<List<String>>,
    public val vpcId: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.codebuild.inputs.ProjectVpcConfigArgs> {
    override fun toJava(): com.pulumi.aws.codebuild.inputs.ProjectVpcConfigArgs =
        com.pulumi.aws.codebuild.inputs.ProjectVpcConfigArgs.builder()
            .securityGroupIds(securityGroupIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnets(subnets.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .vpcId(vpcId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectVpcConfigArgs].
 */
@PulumiTagMarker
public class ProjectVpcConfigArgsBuilder internal constructor() {
    private var securityGroupIds: Output<List<String>>? = null

    private var subnets: Output<List<String>>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value Security group IDs to assign to running builds.
     */
    @JvmName("deybqaivyoqnwjrs")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("lktrfslucwtfhfxc")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values Security group IDs to assign to running builds.
     */
    @JvmName("jmelpskiambvfgcu")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value Subnet IDs within which to run builds.
     */
    @JvmName("pynuwtngrnrvdqqs")
    public suspend fun subnets(`value`: Output<List<String>>) {
        this.subnets = value
    }

    @JvmName("aaopylkhkgwqjlmx")
    public suspend fun subnets(vararg values: Output<String>) {
        this.subnets = Output.all(values.asList())
    }

    /**
     * @param values Subnet IDs within which to run builds.
     */
    @JvmName("jwljfcnljcibosrt")
    public suspend fun subnets(values: List<Output<String>>) {
        this.subnets = Output.all(values)
    }

    /**
     * @param value ID of the VPC within which to run builds.
     */
    @JvmName("xqcmxhsxtifslfne")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value Security group IDs to assign to running builds.
     */
    @JvmName("lajfngbjhovxfjsq")
    public suspend fun securityGroupIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values Security group IDs to assign to running builds.
     */
    @JvmName("koqrnyfyvswbspxk")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value Subnet IDs within which to run builds.
     */
    @JvmName("tinjffaqjtlakjse")
    public suspend fun subnets(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    /**
     * @param values Subnet IDs within which to run builds.
     */
    @JvmName("locuwipjctejwsui")
    public suspend fun subnets(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    /**
     * @param value ID of the VPC within which to run builds.
     */
    @JvmName("cmfgmsqupthixswc")
    public suspend fun vpcId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): ProjectVpcConfigArgs = ProjectVpcConfigArgs(
        securityGroupIds = securityGroupIds ?: throw PulumiNullFieldException("securityGroupIds"),
        subnets = subnets ?: throw PulumiNullFieldException("subnets"),
        vpcId = vpcId ?: throw PulumiNullFieldException("vpcId"),
    )
}
