@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.inputs

import com.pulumi.aws.codebuild.inputs.WebhookFilterGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property filters A webhook filter for the group. Filter blocks are documented below.
 */
public data class WebhookFilterGroupArgs(
    public val filters: Output<List<WebhookFilterGroupFilterArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.codebuild.inputs.WebhookFilterGroupArgs> {
    override fun toJava(): com.pulumi.aws.codebuild.inputs.WebhookFilterGroupArgs =
        com.pulumi.aws.codebuild.inputs.WebhookFilterGroupArgs.builder()
            .filters(
                filters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [WebhookFilterGroupArgs].
 */
@PulumiTagMarker
public class WebhookFilterGroupArgsBuilder internal constructor() {
    private var filters: Output<List<WebhookFilterGroupFilterArgs>>? = null

    /**
     * @param value A webhook filter for the group. Filter blocks are documented below.
     */
    @JvmName("ramnbknqdpvhbeue")
    public suspend fun filters(`value`: Output<List<WebhookFilterGroupFilterArgs>>) {
        this.filters = value
    }

    @JvmName("fnjltxskgenaaohj")
    public suspend fun filters(vararg values: Output<WebhookFilterGroupFilterArgs>) {
        this.filters = Output.all(values.asList())
    }

    /**
     * @param values A webhook filter for the group. Filter blocks are documented below.
     */
    @JvmName("bxwfhlbmogkcsyss")
    public suspend fun filters(values: List<Output<WebhookFilterGroupFilterArgs>>) {
        this.filters = Output.all(values)
    }

    /**
     * @param value A webhook filter for the group. Filter blocks are documented below.
     */
    @JvmName("khutabrsrtyxmhnt")
    public suspend fun filters(`value`: List<WebhookFilterGroupFilterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    /**
     * @param argument A webhook filter for the group. Filter blocks are documented below.
     */
    @JvmName("lktwcqxmnnkbldws")
    public suspend fun filters(argument: List<suspend WebhookFilterGroupFilterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebhookFilterGroupFilterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param argument A webhook filter for the group. Filter blocks are documented below.
     */
    @JvmName("jphkqkyblbgskwvx")
    public suspend fun filters(vararg argument: suspend WebhookFilterGroupFilterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WebhookFilterGroupFilterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param argument A webhook filter for the group. Filter blocks are documented below.
     */
    @JvmName("cfxyrojjamfrfeto")
    public suspend fun filters(argument: suspend WebhookFilterGroupFilterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            WebhookFilterGroupFilterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param values A webhook filter for the group. Filter blocks are documented below.
     */
    @JvmName("rcigmtmhnynxxgkx")
    public suspend fun filters(vararg values: WebhookFilterGroupFilterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    internal fun build(): WebhookFilterGroupArgs = WebhookFilterGroupArgs(
        filters = filters,
    )
}
