@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.inputs

import com.pulumi.aws.codebuild.inputs.WebhookFilterGroupFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property excludeMatchedPattern If set to `true`, the specified filter does *not* trigger a build. Defaults to `false`.
 * @property pattern For a filter that uses `EVENT` type, a comma-separated string that specifies one event: `PUSH`, `PULL_REQUEST_CREATED`, `PULL_REQUEST_UPDATED`, `PULL_REQUEST_REOPENED`. `PULL_REQUEST_MERGED`, `WORKFLOW_JOB_QUEUED` works with GitHub & GitHub Enterprise only. For a filter that uses any of the other filter types, a regular expression.
 * @property type The webhook filter group's type. Valid values for this parameter are: `EVENT`, `BASE_REF`, `HEAD_REF`, `ACTOR_ACCOUNT_ID`, `FILE_PATH`, `COMMIT_MESSAGE`, `WORKFLOW_NAME`, `TAG_NAME`, `RELEASE_NAME`. At least one filter group must specify `EVENT` as its type.
 */
public data class WebhookFilterGroupFilterArgs(
    public val excludeMatchedPattern: Output<Boolean>? = null,
    public val pattern: Output<String>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.codebuild.inputs.WebhookFilterGroupFilterArgs> {
    override fun toJava(): com.pulumi.aws.codebuild.inputs.WebhookFilterGroupFilterArgs =
        com.pulumi.aws.codebuild.inputs.WebhookFilterGroupFilterArgs.builder()
            .excludeMatchedPattern(excludeMatchedPattern?.applyValue({ args0 -> args0 }))
            .pattern(pattern.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebhookFilterGroupFilterArgs].
 */
@PulumiTagMarker
public class WebhookFilterGroupFilterArgsBuilder internal constructor() {
    private var excludeMatchedPattern: Output<Boolean>? = null

    private var pattern: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value If set to `true`, the specified filter does *not* trigger a build. Defaults to `false`.
     */
    @JvmName("pssufhqpkvdxgaav")
    public suspend fun excludeMatchedPattern(`value`: Output<Boolean>) {
        this.excludeMatchedPattern = value
    }

    /**
     * @param value For a filter that uses `EVENT` type, a comma-separated string that specifies one event: `PUSH`, `PULL_REQUEST_CREATED`, `PULL_REQUEST_UPDATED`, `PULL_REQUEST_REOPENED`. `PULL_REQUEST_MERGED`, `WORKFLOW_JOB_QUEUED` works with GitHub & GitHub Enterprise only. For a filter that uses any of the other filter types, a regular expression.
     */
    @JvmName("lvqullukegagfejm")
    public suspend fun pattern(`value`: Output<String>) {
        this.pattern = value
    }

    /**
     * @param value The webhook filter group's type. Valid values for this parameter are: `EVENT`, `BASE_REF`, `HEAD_REF`, `ACTOR_ACCOUNT_ID`, `FILE_PATH`, `COMMIT_MESSAGE`, `WORKFLOW_NAME`, `TAG_NAME`, `RELEASE_NAME`. At least one filter group must specify `EVENT` as its type.
     */
    @JvmName("ynadycaccakrfgds")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value If set to `true`, the specified filter does *not* trigger a build. Defaults to `false`.
     */
    @JvmName("qujpgpsuohdldrid")
    public suspend fun excludeMatchedPattern(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludeMatchedPattern = mapped
    }

    /**
     * @param value For a filter that uses `EVENT` type, a comma-separated string that specifies one event: `PUSH`, `PULL_REQUEST_CREATED`, `PULL_REQUEST_UPDATED`, `PULL_REQUEST_REOPENED`. `PULL_REQUEST_MERGED`, `WORKFLOW_JOB_QUEUED` works with GitHub & GitHub Enterprise only. For a filter that uses any of the other filter types, a regular expression.
     */
    @JvmName("fxxxndhofvgkkrkc")
    public suspend fun pattern(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pattern = mapped
    }

    /**
     * @param value The webhook filter group's type. Valid values for this parameter are: `EVENT`, `BASE_REF`, `HEAD_REF`, `ACTOR_ACCOUNT_ID`, `FILE_PATH`, `COMMIT_MESSAGE`, `WORKFLOW_NAME`, `TAG_NAME`, `RELEASE_NAME`. At least one filter group must specify `EVENT` as its type.
     */
    @JvmName("ghthebaxaobqskwt")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): WebhookFilterGroupFilterArgs = WebhookFilterGroupFilterArgs(
        excludeMatchedPattern = excludeMatchedPattern,
        pattern = pattern ?: throw PulumiNullFieldException("pattern"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
