@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.inputs

import com.pulumi.aws.codebuild.inputs.WebhookScopeConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property domain The domain of the GitHub Enterprise organization. Required if your project's source type is GITHUB_ENTERPRISE.
 * @property name The name of either the enterprise or organization.
 * @property scope The type of scope for a GitHub webhook. Valid values for this parameter are: `GITHUB_ORGANIZATION`, `GITHUB_GLOBAL`.
 */
public data class WebhookScopeConfigurationArgs(
    public val domain: Output<String>? = null,
    public val name: Output<String>,
    public val scope: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.codebuild.inputs.WebhookScopeConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.codebuild.inputs.WebhookScopeConfigurationArgs =
        com.pulumi.aws.codebuild.inputs.WebhookScopeConfigurationArgs.builder()
            .domain(domain?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .scope(scope.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebhookScopeConfigurationArgs].
 */
@PulumiTagMarker
public class WebhookScopeConfigurationArgsBuilder internal constructor() {
    private var domain: Output<String>? = null

    private var name: Output<String>? = null

    private var scope: Output<String>? = null

    /**
     * @param value The domain of the GitHub Enterprise organization. Required if your project's source type is GITHUB_ENTERPRISE.
     */
    @JvmName("yagwoimwhkgxvknc")
    public suspend fun domain(`value`: Output<String>) {
        this.domain = value
    }

    /**
     * @param value The name of either the enterprise or organization.
     */
    @JvmName("vrmmpirupatkhflp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The type of scope for a GitHub webhook. Valid values for this parameter are: `GITHUB_ORGANIZATION`, `GITHUB_GLOBAL`.
     */
    @JvmName("wneynceumvkuoghe")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value The domain of the GitHub Enterprise organization. Required if your project's source type is GITHUB_ENTERPRISE.
     */
    @JvmName("mrfaftsaewhvpayv")
    public suspend fun domain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    /**
     * @param value The name of either the enterprise or organization.
     */
    @JvmName("easnxssxaeuywwqc")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The type of scope for a GitHub webhook. Valid values for this parameter are: `GITHUB_ORGANIZATION`, `GITHUB_GLOBAL`.
     */
    @JvmName("wguejixhumbwlgpl")
    public suspend fun scope(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    internal fun build(): WebhookScopeConfigurationArgs = WebhookScopeConfigurationArgs(
        domain = domain,
        name = name ?: throw PulumiNullFieldException("name"),
        scope = scope ?: throw PulumiNullFieldException("scope"),
    )
}
