@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property artifactIdentifier Artifact identifier. Must be the same specified inside the AWS CodeBuild build specification.
 * @property bucketOwnerAccess Specifies the bucket owner's access for objects that another account uploads to their Amazon S3 bucket. By default, only the account that uploads the objects to the bucket has access to these objects. This property allows you to give the bucket owner access to these objects. Valid values are `NONE`, `READ_ONLY`, and `FULL`. your CodeBuild service role must have the `s3:PutBucketAcl` permission. This permission allows CodeBuild to modify the access control list for the bucket.
 * @property encryptionDisabled Whether to disable encrypting output artifacts. If `type` is set to `NO_ARTIFACTS`, this value is ignored. Defaults to `false`.
 * @property location Information about the build output artifact location. If `type` is set to `CODEPIPELINE` or `NO_ARTIFACTS`, this value is ignored. If `type` is set to `S3`, this is the name of the output bucket.
 * @property name Name of the project. If `type` is set to `S3`, this is the name of the output artifact object
 * @property namespaceType Namespace to use in storing build artifacts. If `type` is set to `S3`, then valid values are `BUILD_ID`, `NONE`.
 * @property overrideArtifactName Whether a name specified in the build specification overrides the artifact name.
 * @property packaging Type of build output artifact to create. If `type` is set to `S3`, valid values are `NONE`, `ZIP`
 * @property path If `type` is set to `S3`, this is the path to the output artifact.
 * @property type Build output artifact's type. Valid values: `CODEPIPELINE`, `NO_ARTIFACTS`, `S3`.
 */
public data class ProjectArtifacts(
    public val artifactIdentifier: String? = null,
    public val bucketOwnerAccess: String? = null,
    public val encryptionDisabled: Boolean? = null,
    public val location: String? = null,
    public val name: String? = null,
    public val namespaceType: String? = null,
    public val overrideArtifactName: Boolean? = null,
    public val packaging: String? = null,
    public val path: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codebuild.outputs.ProjectArtifacts): ProjectArtifacts = ProjectArtifacts(
            artifactIdentifier = javaType.artifactIdentifier().map({ args0 -> args0 }).orElse(null),
            bucketOwnerAccess = javaType.bucketOwnerAccess().map({ args0 -> args0 }).orElse(null),
            encryptionDisabled = javaType.encryptionDisabled().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            namespaceType = javaType.namespaceType().map({ args0 -> args0 }).orElse(null),
            overrideArtifactName = javaType.overrideArtifactName().map({ args0 -> args0 }).orElse(null),
            packaging = javaType.packaging().map({ args0 -> args0 }).orElse(null),
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
