@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property computeTypesAlloweds An array of strings that specify the compute types that are allowed for the batch build. See [Build environment compute types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html) in the AWS CodeBuild User Guide for these values.
 * @property maximumBuildsAllowed Specifies the maximum number of builds allowed.
 */
public data class ProjectBuildBatchConfigRestrictions(
    public val computeTypesAlloweds: List<String>? = null,
    public val maximumBuildsAllowed: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codebuild.outputs.ProjectBuildBatchConfigRestrictions): ProjectBuildBatchConfigRestrictions = ProjectBuildBatchConfigRestrictions(
            computeTypesAlloweds = javaType.computeTypesAlloweds().map({ args0 -> args0 }),
            maximumBuildsAllowed = javaType.maximumBuildsAllowed().map({ args0 -> args0 }).orElse(null),
        )
    }
}
