@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucketOwnerAccess Specifies the bucket owner's access for objects that another account uploads to their Amazon S3 bucket. By default, only the account that uploads the objects to the bucket has access to these objects. This property allows you to give the bucket owner access to these objects. Valid values are `NONE`, `READ_ONLY`, and `FULL`. your CodeBuild service role must have the `s3:PutBucketAcl` permission. This permission allows CodeBuild to modify the access control list for the bucket.
 * @property encryptionDisabled Whether to disable encrypting S3 logs. Defaults to `false`.
 * @property location Name of the S3 bucket and the path prefix for S3 logs. Must be set if status is `ENABLED`, otherwise it must be empty.
 * @property status Current status of logs in S3 for a build project. Valid values: `ENABLED`, `DISABLED`. Defaults to `DISABLED`.
 */
public data class ProjectLogsConfigS3Logs(
    public val bucketOwnerAccess: String? = null,
    public val encryptionDisabled: Boolean? = null,
    public val location: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codebuild.outputs.ProjectLogsConfigS3Logs): ProjectLogsConfigS3Logs = ProjectLogsConfigS3Logs(
            bucketOwnerAccess = javaType.bucketOwnerAccess().map({ args0 -> args0 }).orElse(null),
            encryptionDisabled = javaType.encryptionDisabled().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
