@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property buildStatusConfig Configuration block that contains information that defines how the build project reports the build status to the source provider. This option is only used when the source provider is GitHub, GitHub Enterprise, GitLab, GitLab Self Managed, or Bitbucket. `build_status_config` blocks are documented below.
 * @property buildspec The build spec declaration to use for this build project's related builds. This must be set when `type` is `NO_SOURCE`. It can either be a path to a file residing in the repository to be built or a local file path leveraging the `file()` built-in.
 * @property gitCloneDepth Truncate git history to this many commits. Use `0` for a `Full` checkout which you need to run commands like `git branch --show-current`. See [AWS CodePipeline User Guide: Tutorial: Use full clone with a GitHub pipeline source](https://docs.aws.amazon.com/codepipeline/latest/userguide/tutorials-github-gitclone.html) for details.
 * @property gitSubmodulesConfig Configuration block. Detailed below.
 * @property insecureSsl Ignore SSL warnings when connecting to source control.
 * @property location Location of the source code from git or s3.
 * @property reportBuildStatus Whether to report the status of a build's start and finish to your source provider. This option is valid only when your source provider is GitHub, GitHub Enterprise, GitLab, GitLab Self Managed, or Bitbucket.
 * @property sourceIdentifier An identifier for this project source. The identifier can only contain alphanumeric characters and underscores, and must be less than 128 characters in length.
 * @property type Type of repository that contains the source code to be built. Valid values: `BITBUCKET`, `CODECOMMIT`, `CODEPIPELINE`, `GITHUB`, `GITHUB_ENTERPRISE`, `GITLAB`, `GITLAB_SELF_MANAGED`, `NO_SOURCE`, `S3`.
 */
public data class ProjectSecondarySource(
    public val buildStatusConfig: ProjectSecondarySourceBuildStatusConfig? = null,
    public val buildspec: String? = null,
    public val gitCloneDepth: Int? = null,
    public val gitSubmodulesConfig: ProjectSecondarySourceGitSubmodulesConfig? = null,
    public val insecureSsl: Boolean? = null,
    public val location: String? = null,
    public val reportBuildStatus: Boolean? = null,
    public val sourceIdentifier: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codebuild.outputs.ProjectSecondarySource): ProjectSecondarySource = ProjectSecondarySource(
            buildStatusConfig = javaType.buildStatusConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.codebuild.kotlin.outputs.ProjectSecondarySourceBuildStatusConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            buildspec = javaType.buildspec().map({ args0 -> args0 }).orElse(null),
            gitCloneDepth = javaType.gitCloneDepth().map({ args0 -> args0 }).orElse(null),
            gitSubmodulesConfig = javaType.gitSubmodulesConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.codebuild.kotlin.outputs.ProjectSecondarySourceGitSubmodulesConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            insecureSsl = javaType.insecureSsl().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            reportBuildStatus = javaType.reportBuildStatus().map({ args0 -> args0 }).orElse(null),
            sourceIdentifier = javaType.sourceIdentifier(),
            type = javaType.type(),
        )
    }
}
