@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property context Specifies the context of the build status CodeBuild sends to the source provider. The usage of this parameter depends on the source provider.
 * @property targetUrl Specifies the target url of the build status CodeBuild sends to the source provider. The usage of this parameter depends on the source provider.
 */
public data class ProjectSecondarySourceBuildStatusConfig(
    public val context: String? = null,
    public val targetUrl: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codebuild.outputs.ProjectSecondarySourceBuildStatusConfig): ProjectSecondarySourceBuildStatusConfig = ProjectSecondarySourceBuildStatusConfig(
            context = javaType.context().map({ args0 -> args0 }).orElse(null),
            targetUrl = javaType.targetUrl().map({ args0 -> args0 }).orElse(null),
        )
    }
}
