@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property buildStatusConfig Configuration block that contains information that defines how the build project reports the build status to the source provider. This option is only used when the source provider is GitHub, GitHub Enterprise, GitLab, GitLab Self Managed, or Bitbucket. `build_status_config` blocks are documented below.
 * @property buildspec Build specification to use for this build project's related builds. This must be set when `type` is `NO_SOURCE`. Also, if a non-default buildspec file name or file path aside from the root is used, it must be specified.
 * @property gitCloneDepth Truncate git history to this many commits. Use `0` for a `Full` checkout which you need to run commands like `git branch --show-current`. See [AWS CodePipeline User Guide: Tutorial: Use full clone with a GitHub pipeline source](https://docs.aws.amazon.com/codepipeline/latest/userguide/tutorials-github-gitclone.html) for details.
 * @property gitSubmodulesConfig Configuration block. Detailed below.
 * @property insecureSsl Ignore SSL warnings when connecting to source control.
 * @property location Location of the source code from git or s3.
 * @property reportBuildStatus Whether to report the status of a build's start and finish to your source provider. This option is valid only when your source provider is GitHub, GitHub Enterprise, GitLab, GitLab Self Managed, or Bitbucket.
 * @property type Type of repository that contains the source code to be built. Valid values: `BITBUCKET`, `CODECOMMIT`, `CODEPIPELINE`, `GITHUB`, `GITHUB_ENTERPRISE`, `GITLAB`, `GITLAB_SELF_MANAGED`, `NO_SOURCE`, `S3`.
 */
public data class ProjectSource(
    public val buildStatusConfig: ProjectSourceBuildStatusConfig? = null,
    public val buildspec: String? = null,
    public val gitCloneDepth: Int? = null,
    public val gitSubmodulesConfig: ProjectSourceGitSubmodulesConfig? = null,
    public val insecureSsl: Boolean? = null,
    public val location: String? = null,
    public val reportBuildStatus: Boolean? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codebuild.outputs.ProjectSource): ProjectSource =
            ProjectSource(
                buildStatusConfig = javaType.buildStatusConfig().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.codebuild.kotlin.outputs.ProjectSourceBuildStatusConfig.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                buildspec = javaType.buildspec().map({ args0 -> args0 }).orElse(null),
                gitCloneDepth = javaType.gitCloneDepth().map({ args0 -> args0 }).orElse(null),
                gitSubmodulesConfig = javaType.gitSubmodulesConfig().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.codebuild.kotlin.outputs.ProjectSourceGitSubmodulesConfig.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                insecureSsl = javaType.insecureSsl().map({ args0 -> args0 }).orElse(null),
                location = javaType.location().map({ args0 -> args0 }).orElse(null),
                reportBuildStatus = javaType.reportBuildStatus().map({ args0 -> args0 }).orElse(null),
                type = javaType.type(),
            )
    }
}
