@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property securityGroupIds Security group IDs to assign to running builds.
 * @property subnets Subnet IDs within which to run builds.
 * @property vpcId ID of the VPC within which to run builds.
 */
public data class ProjectVpcConfig(
    public val securityGroupIds: List<String>,
    public val subnets: List<String>,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codebuild.outputs.ProjectVpcConfig): ProjectVpcConfig = ProjectVpcConfig(
            securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
            subnets = javaType.subnets().map({ args0 -> args0 }),
            vpcId = javaType.vpcId(),
        )
    }
}
