@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property s3Destination contains information about the S3 bucket where the run of a report is exported. see S3 Destination documented below.
 * @property type The export configuration type. Valid values are `S3` and `NO_EXPORT`.
 */
public data class ReportGroupExportConfig(
    public val s3Destination: ReportGroupExportConfigS3Destination? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codebuild.outputs.ReportGroupExportConfig): ReportGroupExportConfig = ReportGroupExportConfig(
            s3Destination = javaType.s3Destination().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.codebuild.kotlin.outputs.ReportGroupExportConfigS3Destination.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
