@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucket The name of the S3 bucket where the raw data of a report are exported.
 * @property encryptionDisabled A boolean value that specifies if the results of a report are encrypted.
 * **Note: the API does not currently allow setting encryption as disabled**
 * @property encryptionKey The encryption key for the report's encrypted raw data. The KMS key ARN.
 * @property packaging The type of build output artifact to create. Valid values are: `NONE` (default) and `ZIP`.
 * @property path The path to the exported report's raw data results.
 */
public data class ReportGroupExportConfigS3Destination(
    public val bucket: String,
    public val encryptionDisabled: Boolean? = null,
    public val encryptionKey: String,
    public val packaging: String? = null,
    public val path: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codebuild.outputs.ReportGroupExportConfigS3Destination): ReportGroupExportConfigS3Destination = ReportGroupExportConfigS3Destination(
            bucket = javaType.bucket(),
            encryptionDisabled = javaType.encryptionDisabled().map({ args0 -> args0 }).orElse(null),
            encryptionKey = javaType.encryptionKey(),
            packaging = javaType.packaging().map({ args0 -> args0 }).orElse(null),
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
        )
    }
}
