@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property domain The domain of the GitHub Enterprise organization. Required if your project's source type is GITHUB_ENTERPRISE.
 * @property name The name of either the enterprise or organization.
 * @property scope The type of scope for a GitHub webhook. Valid values for this parameter are: `GITHUB_ORGANIZATION`, `GITHUB_GLOBAL`.
 */
public data class WebhookScopeConfiguration(
    public val domain: String? = null,
    public val name: String,
    public val scope: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codebuild.outputs.WebhookScopeConfiguration): WebhookScopeConfiguration = WebhookScopeConfiguration(
            domain = javaType.domain().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            scope = javaType.scope(),
        )
    }
}
