@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codecatalyst.kotlin

import com.pulumi.aws.codecatalyst.CodecatalystFunctions.getDevEnvironmentPlain
import com.pulumi.aws.codecatalyst.kotlin.inputs.GetDevEnvironmentPlainArgs
import com.pulumi.aws.codecatalyst.kotlin.inputs.GetDevEnvironmentPlainArgsBuilder
import com.pulumi.aws.codecatalyst.kotlin.inputs.GetDevEnvironmentRepository
import com.pulumi.aws.codecatalyst.kotlin.outputs.GetDevEnvironmentResult
import com.pulumi.aws.codecatalyst.kotlin.outputs.GetDevEnvironmentResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

public object CodecatalystFunctions {
    /**
     * Data source for managing an AWS CodeCatalyst Dev Environment.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.codecatalyst.getDevEnvironment({
     *     spaceName: "myspace",
     *     projectName: "myproject",
     *     envId: exampleAwsCodecatalystDevEnvironment.id,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.codecatalyst.get_dev_environment(space_name="myspace",
     *     project_name="myproject",
     *     env_id=example_aws_codecatalyst_dev_environment["id"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.CodeCatalyst.GetDevEnvironment.Invoke(new()
     *     {
     *         SpaceName = "myspace",
     *         ProjectName = "myproject",
     *         EnvId = exampleAwsCodecatalystDevEnvironment.Id,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codecatalyst"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := codecatalyst.LookupDevEnvironment(ctx, &codecatalyst.LookupDevEnvironmentArgs{
     * 			SpaceName:   "myspace",
     * 			ProjectName: "myproject",
     * 			EnvId:       exampleAwsCodecatalystDevEnvironment.Id,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.codecatalyst.CodecatalystFunctions;
     * import com.pulumi.aws.codecatalyst.inputs.GetDevEnvironmentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CodecatalystFunctions.getDevEnvironment(GetDevEnvironmentArgs.builder()
     *             .spaceName("myspace")
     *             .projectName("myproject")
     *             .envId(exampleAwsCodecatalystDevEnvironment.id())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:codecatalyst:getDevEnvironment
     *       Arguments:
     *         spaceName: myspace
     *         projectName: myproject
     *         envId: ${exampleAwsCodecatalystDevEnvironment.id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDevEnvironment.
     * @return A collection of values returned by getDevEnvironment.
     */
    public suspend fun getDevEnvironment(argument: GetDevEnvironmentPlainArgs): GetDevEnvironmentResult = toKotlin(getDevEnvironmentPlain(argument.toJava()).await())

    /**
     * @see [getDevEnvironment].
     * @param alias The user-specified alias for the Dev Environment.
     * @param creatorId The system-generated unique ID of the user who created the Dev Environment.
     * @param envId - (Required) The system-generated unique ID of the Dev Environment for which you want to view information. To retrieve a list of Dev Environment IDs, use [ListDevEnvironments](https://docs.aws.amazon.com/codecatalyst/latest/APIReference/API_ListDevEnvironments.html).
     * @param projectName The name of the project in the space.
     * @param repositories The source repository that contains the branch to clone into the Dev Environment.
     * @param spaceName The name of the space.
     * @param tags
     * @return A collection of values returned by getDevEnvironment.
     */
    public suspend fun getDevEnvironment(
        alias: String? = null,
        creatorId: String? = null,
        envId: String,
        projectName: String,
        repositories: List<GetDevEnvironmentRepository>? = null,
        spaceName: String,
        tags: Map<String, String>? = null,
    ): GetDevEnvironmentResult {
        val argument = GetDevEnvironmentPlainArgs(
            alias = alias,
            creatorId = creatorId,
            envId = envId,
            projectName = projectName,
            repositories = repositories,
            spaceName = spaceName,
            tags = tags,
        )
        return toKotlin(getDevEnvironmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getDevEnvironment].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;codecatalyst&#46;kotlin&#46;inputs&#46;GetDevEnvironmentPlainArgs].
     * @return A collection of values returned by getDevEnvironment.
     */
    public suspend fun getDevEnvironment(argument: suspend GetDevEnvironmentPlainArgsBuilder.() -> Unit): GetDevEnvironmentResult {
        val builder = GetDevEnvironmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getDevEnvironmentPlain(builtArgument.toJava()).await())
    }
}
