@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codecatalyst.kotlin

import com.pulumi.aws.codecatalyst.kotlin.outputs.DevEnvironmentIdes
import com.pulumi.aws.codecatalyst.kotlin.outputs.DevEnvironmentPersistentStorage
import com.pulumi.aws.codecatalyst.kotlin.outputs.DevEnvironmentRepository
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.codecatalyst.kotlin.outputs.DevEnvironmentIdes.Companion.toKotlin as devEnvironmentIdesToKotlin
import com.pulumi.aws.codecatalyst.kotlin.outputs.DevEnvironmentPersistentStorage.Companion.toKotlin as devEnvironmentPersistentStorageToKotlin
import com.pulumi.aws.codecatalyst.kotlin.outputs.DevEnvironmentRepository.Companion.toKotlin as devEnvironmentRepositoryToKotlin

/**
 * Builder for [DevEnvironment].
 */
@PulumiTagMarker
public class DevEnvironmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DevEnvironmentArgs = DevEnvironmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DevEnvironmentArgsBuilder.() -> Unit) {
        val builder = DevEnvironmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DevEnvironment {
        val builtJavaResource = com.pulumi.aws.codecatalyst.DevEnvironment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DevEnvironment(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS CodeCatalyst Dev Environment.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.codecatalyst.DevEnvironment("test", {
 *     alias: "devenv",
 *     spaceName: "myspace",
 *     projectName: "myproject",
 *     instanceType: "dev.standard1.small",
 *     persistentStorage: {
 *         size: 16,
 *     },
 *     ides: {
 *         name: "PyCharm",
 *         runtime: "public.ecr.aws/jetbrains/py",
 *     },
 *     inactivityTimeoutMinutes: 40,
 *     repositories: [{
 *         repositoryName: "pulumi-provider-aws",
 *         branchName: "main",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.codecatalyst.DevEnvironment("test",
 *     alias="devenv",
 *     space_name="myspace",
 *     project_name="myproject",
 *     instance_type="dev.standard1.small",
 *     persistent_storage={
 *         "size": 16,
 *     },
 *     ides={
 *         "name": "PyCharm",
 *         "runtime": "public.ecr.aws/jetbrains/py",
 *     },
 *     inactivity_timeout_minutes=40,
 *     repositories=[{
 *         "repository_name": "pulumi-provider-aws",
 *         "branch_name": "main",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.CodeCatalyst.DevEnvironment("test", new()
 *     {
 *         Alias = "devenv",
 *         SpaceName = "myspace",
 *         ProjectName = "myproject",
 *         InstanceType = "dev.standard1.small",
 *         PersistentStorage = new Aws.CodeCatalyst.Inputs.DevEnvironmentPersistentStorageArgs
 *         {
 *             Size = 16,
 *         },
 *         Ides = new Aws.CodeCatalyst.Inputs.DevEnvironmentIdesArgs
 *         {
 *             Name = "PyCharm",
 *             Runtime = "public.ecr.aws/jetbrains/py",
 *         },
 *         InactivityTimeoutMinutes = 40,
 *         Repositories = new[]
 *         {
 *             new Aws.CodeCatalyst.Inputs.DevEnvironmentRepositoryArgs
 *             {
 *                 RepositoryName = "pulumi-provider-aws",
 *                 BranchName = "main",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codecatalyst"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := codecatalyst.NewDevEnvironment(ctx, "test", &codecatalyst.DevEnvironmentArgs{
 * 			Alias:        pulumi.String("devenv"),
 * 			SpaceName:    pulumi.String("myspace"),
 * 			ProjectName:  pulumi.String("myproject"),
 * 			InstanceType: pulumi.String("dev.standard1.small"),
 * 			PersistentStorage: &codecatalyst.DevEnvironmentPersistentStorageArgs{
 * 				Size: pulumi.Int(16),
 * 			},
 * 			Ides: &codecatalyst.DevEnvironmentIdesArgs{
 * 				Name:    pulumi.String("PyCharm"),
 * 				Runtime: pulumi.String("public.ecr.aws/jetbrains/py"),
 * 			},
 * 			InactivityTimeoutMinutes: pulumi.Int(40),
 * 			Repositories: codecatalyst.DevEnvironmentRepositoryArray{
 * 				&codecatalyst.DevEnvironmentRepositoryArgs{
 * 					RepositoryName: pulumi.String("pulumi-provider-aws"),
 * 					BranchName:     pulumi.String("main"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codecatalyst.DevEnvironment;
 * import com.pulumi.aws.codecatalyst.DevEnvironmentArgs;
 * import com.pulumi.aws.codecatalyst.inputs.DevEnvironmentPersistentStorageArgs;
 * import com.pulumi.aws.codecatalyst.inputs.DevEnvironmentIdesArgs;
 * import com.pulumi.aws.codecatalyst.inputs.DevEnvironmentRepositoryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new DevEnvironment("test", DevEnvironmentArgs.builder()
 *             .alias("devenv")
 *             .spaceName("myspace")
 *             .projectName("myproject")
 *             .instanceType("dev.standard1.small")
 *             .persistentStorage(DevEnvironmentPersistentStorageArgs.builder()
 *                 .size(16)
 *                 .build())
 *             .ides(DevEnvironmentIdesArgs.builder()
 *                 .name("PyCharm")
 *                 .runtime("public.ecr.aws/jetbrains/py")
 *                 .build())
 *             .inactivityTimeoutMinutes(40)
 *             .repositories(DevEnvironmentRepositoryArgs.builder()
 *                 .repositoryName("pulumi-provider-aws")
 *                 .branchName("main")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:codecatalyst:DevEnvironment
 *     properties:
 *       alias: devenv
 *       spaceName: myspace
 *       projectName: myproject
 *       instanceType: dev.standard1.small
 *       persistentStorage:
 *         size: 16
 *       ides:
 *         name: PyCharm
 *         runtime: public.ecr.aws/jetbrains/py
 *       inactivityTimeoutMinutes: 40
 *       repositories:
 *         - repositoryName: pulumi-provider-aws
 *           branchName: main
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class DevEnvironment internal constructor(
    override val javaResource: com.pulumi.aws.codecatalyst.DevEnvironment,
) : KotlinCustomResource(javaResource, DevEnvironmentMapper) {
    public val alias: Output<String>?
        get() = javaResource.alias().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Information about the integrated development environment (IDE) configured for a Dev Environment.
     */
    public val ides: Output<DevEnvironmentIdes>
        get() = javaResource.ides().applyValue({ args0 ->
            args0.let({ args0 ->
                devEnvironmentIdesToKotlin(args0)
            })
        })

    /**
     * The amount of time the Dev Environment will run without any activity detected before stopping, in minutes. Only whole integers are allowed. Dev Environments consume compute minutes when running.
     */
    public val inactivityTimeoutMinutes: Output<Int>?
        get() = javaResource.inactivityTimeoutMinutes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Amazon EC2 instace type to use for the Dev Environment. Valid values include dev.standard1.small,dev.standard1.medium,dev.standard1.large,dev.standard1.xlarge
     * The following arguments are optional:
     */
    public val instanceType: Output<String>
        get() = javaResource.instanceType().applyValue({ args0 -> args0 })

    /**
     * Information about the amount of storage allocated to the Dev Environment.
     */
    public val persistentStorage: Output<DevEnvironmentPersistentStorage>
        get() = javaResource.persistentStorage().applyValue({ args0 ->
            args0.let({ args0 ->
                devEnvironmentPersistentStorageToKotlin(args0)
            })
        })

    /**
     * The name of the project in the space.
     */
    public val projectName: Output<String>
        get() = javaResource.projectName().applyValue({ args0 -> args0 })

    /**
     * The source repository that contains the branch to clone into the Dev Environment.
     */
    public val repositories: Output<List<DevEnvironmentRepository>>?
        get() = javaResource.repositories().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> devEnvironmentRepositoryToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The name of the space.
     */
    public val spaceName: Output<String>
        get() = javaResource.spaceName().applyValue({ args0 -> args0 })
}

public object DevEnvironmentMapper : ResourceMapper<DevEnvironment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.codecatalyst.DevEnvironment::class == javaResource::class

    override fun map(javaResource: Resource): DevEnvironment = DevEnvironment(
        javaResource as
            com.pulumi.aws.codecatalyst.DevEnvironment,
    )
}

/**
 * @see [DevEnvironment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DevEnvironment].
 */
public suspend fun devEnvironment(
    name: String,
    block: suspend DevEnvironmentResourceBuilder.() -> Unit,
): DevEnvironment {
    val builder = DevEnvironmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DevEnvironment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun devEnvironment(name: String): DevEnvironment {
    val builder = DevEnvironmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
