@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codecatalyst.kotlin

import com.pulumi.aws.codecatalyst.DevEnvironmentArgs.builder
import com.pulumi.aws.codecatalyst.kotlin.inputs.DevEnvironmentIdesArgs
import com.pulumi.aws.codecatalyst.kotlin.inputs.DevEnvironmentIdesArgsBuilder
import com.pulumi.aws.codecatalyst.kotlin.inputs.DevEnvironmentPersistentStorageArgs
import com.pulumi.aws.codecatalyst.kotlin.inputs.DevEnvironmentPersistentStorageArgsBuilder
import com.pulumi.aws.codecatalyst.kotlin.inputs.DevEnvironmentRepositoryArgs
import com.pulumi.aws.codecatalyst.kotlin.inputs.DevEnvironmentRepositoryArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS CodeCatalyst Dev Environment.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.codecatalyst.DevEnvironment("test", {
 *     alias: "devenv",
 *     spaceName: "myspace",
 *     projectName: "myproject",
 *     instanceType: "dev.standard1.small",
 *     persistentStorage: {
 *         size: 16,
 *     },
 *     ides: {
 *         name: "PyCharm",
 *         runtime: "public.ecr.aws/jetbrains/py",
 *     },
 *     inactivityTimeoutMinutes: 40,
 *     repositories: [{
 *         repositoryName: "pulumi-provider-aws",
 *         branchName: "main",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.codecatalyst.DevEnvironment("test",
 *     alias="devenv",
 *     space_name="myspace",
 *     project_name="myproject",
 *     instance_type="dev.standard1.small",
 *     persistent_storage={
 *         "size": 16,
 *     },
 *     ides={
 *         "name": "PyCharm",
 *         "runtime": "public.ecr.aws/jetbrains/py",
 *     },
 *     inactivity_timeout_minutes=40,
 *     repositories=[{
 *         "repository_name": "pulumi-provider-aws",
 *         "branch_name": "main",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.CodeCatalyst.DevEnvironment("test", new()
 *     {
 *         Alias = "devenv",
 *         SpaceName = "myspace",
 *         ProjectName = "myproject",
 *         InstanceType = "dev.standard1.small",
 *         PersistentStorage = new Aws.CodeCatalyst.Inputs.DevEnvironmentPersistentStorageArgs
 *         {
 *             Size = 16,
 *         },
 *         Ides = new Aws.CodeCatalyst.Inputs.DevEnvironmentIdesArgs
 *         {
 *             Name = "PyCharm",
 *             Runtime = "public.ecr.aws/jetbrains/py",
 *         },
 *         InactivityTimeoutMinutes = 40,
 *         Repositories = new[]
 *         {
 *             new Aws.CodeCatalyst.Inputs.DevEnvironmentRepositoryArgs
 *             {
 *                 RepositoryName = "pulumi-provider-aws",
 *                 BranchName = "main",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codecatalyst"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := codecatalyst.NewDevEnvironment(ctx, "test", &codecatalyst.DevEnvironmentArgs{
 * 			Alias:        pulumi.String("devenv"),
 * 			SpaceName:    pulumi.String("myspace"),
 * 			ProjectName:  pulumi.String("myproject"),
 * 			InstanceType: pulumi.String("dev.standard1.small"),
 * 			PersistentStorage: &codecatalyst.DevEnvironmentPersistentStorageArgs{
 * 				Size: pulumi.Int(16),
 * 			},
 * 			Ides: &codecatalyst.DevEnvironmentIdesArgs{
 * 				Name:    pulumi.String("PyCharm"),
 * 				Runtime: pulumi.String("public.ecr.aws/jetbrains/py"),
 * 			},
 * 			InactivityTimeoutMinutes: pulumi.Int(40),
 * 			Repositories: codecatalyst.DevEnvironmentRepositoryArray{
 * 				&codecatalyst.DevEnvironmentRepositoryArgs{
 * 					RepositoryName: pulumi.String("pulumi-provider-aws"),
 * 					BranchName:     pulumi.String("main"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codecatalyst.DevEnvironment;
 * import com.pulumi.aws.codecatalyst.DevEnvironmentArgs;
 * import com.pulumi.aws.codecatalyst.inputs.DevEnvironmentPersistentStorageArgs;
 * import com.pulumi.aws.codecatalyst.inputs.DevEnvironmentIdesArgs;
 * import com.pulumi.aws.codecatalyst.inputs.DevEnvironmentRepositoryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new DevEnvironment("test", DevEnvironmentArgs.builder()
 *             .alias("devenv")
 *             .spaceName("myspace")
 *             .projectName("myproject")
 *             .instanceType("dev.standard1.small")
 *             .persistentStorage(DevEnvironmentPersistentStorageArgs.builder()
 *                 .size(16)
 *                 .build())
 *             .ides(DevEnvironmentIdesArgs.builder()
 *                 .name("PyCharm")
 *                 .runtime("public.ecr.aws/jetbrains/py")
 *                 .build())
 *             .inactivityTimeoutMinutes(40)
 *             .repositories(DevEnvironmentRepositoryArgs.builder()
 *                 .repositoryName("pulumi-provider-aws")
 *                 .branchName("main")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:codecatalyst:DevEnvironment
 *     properties:
 *       alias: devenv
 *       spaceName: myspace
 *       projectName: myproject
 *       instanceType: dev.standard1.small
 *       persistentStorage:
 *         size: 16
 *       ides:
 *         name: PyCharm
 *         runtime: public.ecr.aws/jetbrains/py
 *       inactivityTimeoutMinutes: 40
 *       repositories:
 *         - repositoryName: pulumi-provider-aws
 *           branchName: main
 * ```
 * <!--End PulumiCodeChooser -->
 * @property alias
 * @property ides Information about the integrated development environment (IDE) configured for a Dev Environment.
 * @property inactivityTimeoutMinutes The amount of time the Dev Environment will run without any activity detected before stopping, in minutes. Only whole integers are allowed. Dev Environments consume compute minutes when running.
 * @property instanceType The Amazon EC2 instace type to use for the Dev Environment. Valid values include dev.standard1.small,dev.standard1.medium,dev.standard1.large,dev.standard1.xlarge
 * The following arguments are optional:
 * @property persistentStorage Information about the amount of storage allocated to the Dev Environment.
 * @property projectName The name of the project in the space.
 * @property repositories The source repository that contains the branch to clone into the Dev Environment.
 * @property spaceName The name of the space.
 */
public data class DevEnvironmentArgs(
    public val alias: Output<String>? = null,
    public val ides: Output<DevEnvironmentIdesArgs>? = null,
    public val inactivityTimeoutMinutes: Output<Int>? = null,
    public val instanceType: Output<String>? = null,
    public val persistentStorage: Output<DevEnvironmentPersistentStorageArgs>? = null,
    public val projectName: Output<String>? = null,
    public val repositories: Output<List<DevEnvironmentRepositoryArgs>>? = null,
    public val spaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.codecatalyst.DevEnvironmentArgs> {
    override fun toJava(): com.pulumi.aws.codecatalyst.DevEnvironmentArgs =
        com.pulumi.aws.codecatalyst.DevEnvironmentArgs.builder()
            .alias(alias?.applyValue({ args0 -> args0 }))
            .ides(ides?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .inactivityTimeoutMinutes(inactivityTimeoutMinutes?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .persistentStorage(persistentStorage?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .repositories(
                repositories?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .spaceName(spaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DevEnvironmentArgs].
 */
@PulumiTagMarker
public class DevEnvironmentArgsBuilder internal constructor() {
    private var alias: Output<String>? = null

    private var ides: Output<DevEnvironmentIdesArgs>? = null

    private var inactivityTimeoutMinutes: Output<Int>? = null

    private var instanceType: Output<String>? = null

    private var persistentStorage: Output<DevEnvironmentPersistentStorageArgs>? = null

    private var projectName: Output<String>? = null

    private var repositories: Output<List<DevEnvironmentRepositoryArgs>>? = null

    private var spaceName: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("dlnmxkqndlcqevij")
    public suspend fun alias(`value`: Output<String>) {
        this.alias = value
    }

    /**
     * @param value Information about the integrated development environment (IDE) configured for a Dev Environment.
     */
    @JvmName("tklrtjfoxcvvykis")
    public suspend fun ides(`value`: Output<DevEnvironmentIdesArgs>) {
        this.ides = value
    }

    /**
     * @param value The amount of time the Dev Environment will run without any activity detected before stopping, in minutes. Only whole integers are allowed. Dev Environments consume compute minutes when running.
     */
    @JvmName("fbxpmfduxhwujehb")
    public suspend fun inactivityTimeoutMinutes(`value`: Output<Int>) {
        this.inactivityTimeoutMinutes = value
    }

    /**
     * @param value The Amazon EC2 instace type to use for the Dev Environment. Valid values include dev.standard1.small,dev.standard1.medium,dev.standard1.large,dev.standard1.xlarge
     * The following arguments are optional:
     */
    @JvmName("gvjcodfrbisfgytg")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Information about the amount of storage allocated to the Dev Environment.
     */
    @JvmName("fkwkhlgvjoaxcqvy")
    public suspend fun persistentStorage(`value`: Output<DevEnvironmentPersistentStorageArgs>) {
        this.persistentStorage = value
    }

    /**
     * @param value The name of the project in the space.
     */
    @JvmName("geoqibhxiwaevqhr")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value The source repository that contains the branch to clone into the Dev Environment.
     */
    @JvmName("jrdccjfenbvsjoya")
    public suspend fun repositories(`value`: Output<List<DevEnvironmentRepositoryArgs>>) {
        this.repositories = value
    }

    @JvmName("mpkkcmxdqygvdeqb")
    public suspend fun repositories(vararg values: Output<DevEnvironmentRepositoryArgs>) {
        this.repositories = Output.all(values.asList())
    }

    /**
     * @param values The source repository that contains the branch to clone into the Dev Environment.
     */
    @JvmName("mhnopimsjpdoicke")
    public suspend fun repositories(values: List<Output<DevEnvironmentRepositoryArgs>>) {
        this.repositories = Output.all(values)
    }

    /**
     * @param value The name of the space.
     */
    @JvmName("qmgwjscuymboncry")
    public suspend fun spaceName(`value`: Output<String>) {
        this.spaceName = value
    }

    /**
     * @param value
     */
    @JvmName("nbvanhfxuujyruod")
    public suspend fun alias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alias = mapped
    }

    /**
     * @param value Information about the integrated development environment (IDE) configured for a Dev Environment.
     */
    @JvmName("aibuhnyigtwnkwfb")
    public suspend fun ides(`value`: DevEnvironmentIdesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ides = mapped
    }

    /**
     * @param argument Information about the integrated development environment (IDE) configured for a Dev Environment.
     */
    @JvmName("clinnsqtglemcjuy")
    public suspend fun ides(argument: suspend DevEnvironmentIdesArgsBuilder.() -> Unit) {
        val toBeMapped = DevEnvironmentIdesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ides = mapped
    }

    /**
     * @param value The amount of time the Dev Environment will run without any activity detected before stopping, in minutes. Only whole integers are allowed. Dev Environments consume compute minutes when running.
     */
    @JvmName("rpynguccsprtrgks")
    public suspend fun inactivityTimeoutMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inactivityTimeoutMinutes = mapped
    }

    /**
     * @param value The Amazon EC2 instace type to use for the Dev Environment. Valid values include dev.standard1.small,dev.standard1.medium,dev.standard1.large,dev.standard1.xlarge
     * The following arguments are optional:
     */
    @JvmName("rjwwilttrtivfoey")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Information about the amount of storage allocated to the Dev Environment.
     */
    @JvmName("hhjgfgecmrjlxggt")
    public suspend fun persistentStorage(`value`: DevEnvironmentPersistentStorageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.persistentStorage = mapped
    }

    /**
     * @param argument Information about the amount of storage allocated to the Dev Environment.
     */
    @JvmName("hfxdnvnwchahxktd")
    public suspend fun persistentStorage(argument: suspend DevEnvironmentPersistentStorageArgsBuilder.() -> Unit) {
        val toBeMapped = DevEnvironmentPersistentStorageArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.persistentStorage = mapped
    }

    /**
     * @param value The name of the project in the space.
     */
    @JvmName("cvhabimkwybgssrv")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value The source repository that contains the branch to clone into the Dev Environment.
     */
    @JvmName("kgeebatjnmmktmqd")
    public suspend fun repositories(`value`: List<DevEnvironmentRepositoryArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repositories = mapped
    }

    /**
     * @param argument The source repository that contains the branch to clone into the Dev Environment.
     */
    @JvmName("gawpinwoqruicljm")
    public suspend fun repositories(argument: List<suspend DevEnvironmentRepositoryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DevEnvironmentRepositoryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.repositories = mapped
    }

    /**
     * @param argument The source repository that contains the branch to clone into the Dev Environment.
     */
    @JvmName("ugymbkqgfmvutneg")
    public suspend fun repositories(vararg argument: suspend DevEnvironmentRepositoryArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DevEnvironmentRepositoryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.repositories = mapped
    }

    /**
     * @param argument The source repository that contains the branch to clone into the Dev Environment.
     */
    @JvmName("vsvhidqmgcedglqh")
    public suspend fun repositories(argument: suspend DevEnvironmentRepositoryArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DevEnvironmentRepositoryArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.repositories = mapped
    }

    /**
     * @param values The source repository that contains the branch to clone into the Dev Environment.
     */
    @JvmName("iuhnclgvatbpylep")
    public suspend fun repositories(vararg values: DevEnvironmentRepositoryArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.repositories = mapped
    }

    /**
     * @param value The name of the space.
     */
    @JvmName("uvxduachratgyglv")
    public suspend fun spaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spaceName = mapped
    }

    internal fun build(): DevEnvironmentArgs = DevEnvironmentArgs(
        alias = alias,
        ides = ides,
        inactivityTimeoutMinutes = inactivityTimeoutMinutes,
        instanceType = instanceType,
        persistentStorage = persistentStorage,
        projectName = projectName,
        repositories = repositories,
        spaceName = spaceName,
    )
}
