@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codecatalyst.kotlin

import com.pulumi.aws.codecatalyst.ProjectArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS CodeCatalyst Project.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.codecatalyst.Project("test", {
 *     spaceName: "myproject",
 *     displayName: "MyProject",
 *     description: "My CodeCatalyst Project created using Pulumi",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.codecatalyst.Project("test",
 *     space_name="myproject",
 *     display_name="MyProject",
 *     description="My CodeCatalyst Project created using Pulumi")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.CodeCatalyst.Project("test", new()
 *     {
 *         SpaceName = "myproject",
 *         DisplayName = "MyProject",
 *         Description = "My CodeCatalyst Project created using Pulumi",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codecatalyst"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := codecatalyst.NewProject(ctx, "test", &codecatalyst.ProjectArgs{
 * 			SpaceName:   pulumi.String("myproject"),
 * 			DisplayName: pulumi.String("MyProject"),
 * 			Description: pulumi.String("My CodeCatalyst Project created using Pulumi"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codecatalyst.Project;
 * import com.pulumi.aws.codecatalyst.ProjectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Project("test", ProjectArgs.builder()
 *             .spaceName("myproject")
 *             .displayName("MyProject")
 *             .description("My CodeCatalyst Project created using Pulumi")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:codecatalyst:Project
 *     properties:
 *       spaceName: myproject
 *       displayName: MyProject
 *       description: My CodeCatalyst Project created using Pulumi
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CodeCatalyst Project using the `id`. For example:
 * ```sh
 * $ pulumi import aws:codecatalyst/project:Project example project-id-12345678
 * ```
 * @property description The description of the project. This description will be displayed to all users of the project. We recommend providing a brief description of the project and its intended purpose.
 * @property displayName The friendly name of the project that will be displayed to users.
 * The following arguments are optional:
 * @property spaceName The name of the space.
 */
public data class ProjectArgs(
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val spaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.codecatalyst.ProjectArgs> {
    override fun toJava(): com.pulumi.aws.codecatalyst.ProjectArgs =
        com.pulumi.aws.codecatalyst.ProjectArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .spaceName(spaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectArgs].
 */
@PulumiTagMarker
public class ProjectArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var spaceName: Output<String>? = null

    /**
     * @param value The description of the project. This description will be displayed to all users of the project. We recommend providing a brief description of the project and its intended purpose.
     */
    @JvmName("atrxhwehqbvpfcep")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The friendly name of the project that will be displayed to users.
     * The following arguments are optional:
     */
    @JvmName("ancsgxsyvcgvugte")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The name of the space.
     */
    @JvmName("elmnvdpkcadbfgks")
    public suspend fun spaceName(`value`: Output<String>) {
        this.spaceName = value
    }

    /**
     * @param value The description of the project. This description will be displayed to all users of the project. We recommend providing a brief description of the project and its intended purpose.
     */
    @JvmName("hbnprkyhkkkltquf")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The friendly name of the project that will be displayed to users.
     * The following arguments are optional:
     */
    @JvmName("cshnanqwrdhrlbbk")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The name of the space.
     */
    @JvmName("hnqkiisvfequyhsb")
    public suspend fun spaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spaceName = mapped
    }

    internal fun build(): ProjectArgs = ProjectArgs(
        description = description,
        displayName = displayName,
        spaceName = spaceName,
    )
}
