@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codecatalyst.kotlin

import com.pulumi.aws.codecatalyst.SourceRepositoryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS CodeCatalyst Source Repository.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.codecatalyst.SourceRepository("example", {
 *     name: "example-repo",
 *     projectName: "example-project",
 *     spaceName: "example-space",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.codecatalyst.SourceRepository("example",
 *     name="example-repo",
 *     project_name="example-project",
 *     space_name="example-space")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CodeCatalyst.SourceRepository("example", new()
 *     {
 *         Name = "example-repo",
 *         ProjectName = "example-project",
 *         SpaceName = "example-space",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codecatalyst"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := codecatalyst.NewSourceRepository(ctx, "example", &codecatalyst.SourceRepositoryArgs{
 * 			Name:        pulumi.String("example-repo"),
 * 			ProjectName: pulumi.String("example-project"),
 * 			SpaceName:   pulumi.String("example-space"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codecatalyst.SourceRepository;
 * import com.pulumi.aws.codecatalyst.SourceRepositoryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SourceRepository("example", SourceRepositoryArgs.builder()
 *             .name("example-repo")
 *             .projectName("example-project")
 *             .spaceName("example-space")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:codecatalyst:SourceRepository
 *     properties:
 *       name: example-repo
 *       projectName: example-project
 *       spaceName: example-space
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CodeCatalyst Source Repository using the `id`. For example:
 * ```sh
 * $ pulumi import aws:codecatalyst/sourceRepository:SourceRepository example example-repo
 * ```
 * @property description The description of the project. This description will be displayed to all users of the project. We recommend providing a brief description of the project and its intended purpose.
 * @property name The name of the source repository. For more information about name requirements, see [Quotas for source repositories](https://docs.aws.amazon.com/codecatalyst/latest/userguide/source-quotas.html).
 * @property projectName The name of the project in the CodeCatalyst space.
 * The following arguments are optional:
 * @property spaceName The name of the CodeCatalyst space.
 */
public data class SourceRepositoryArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val spaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.codecatalyst.SourceRepositoryArgs> {
    override fun toJava(): com.pulumi.aws.codecatalyst.SourceRepositoryArgs =
        com.pulumi.aws.codecatalyst.SourceRepositoryArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .spaceName(spaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SourceRepositoryArgs].
 */
@PulumiTagMarker
public class SourceRepositoryArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var projectName: Output<String>? = null

    private var spaceName: Output<String>? = null

    /**
     * @param value The description of the project. This description will be displayed to all users of the project. We recommend providing a brief description of the project and its intended purpose.
     */
    @JvmName("dryhkutbvaiabpim")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the source repository. For more information about name requirements, see [Quotas for source repositories](https://docs.aws.amazon.com/codecatalyst/latest/userguide/source-quotas.html).
     */
    @JvmName("dwoppojdlrstxflv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the project in the CodeCatalyst space.
     * The following arguments are optional:
     */
    @JvmName("pxcsdqrmxoxaumbk")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value The name of the CodeCatalyst space.
     */
    @JvmName("csqyekubjqwuyevd")
    public suspend fun spaceName(`value`: Output<String>) {
        this.spaceName = value
    }

    /**
     * @param value The description of the project. This description will be displayed to all users of the project. We recommend providing a brief description of the project and its intended purpose.
     */
    @JvmName("bnnjrteaffmluhee")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the source repository. For more information about name requirements, see [Quotas for source repositories](https://docs.aws.amazon.com/codecatalyst/latest/userguide/source-quotas.html).
     */
    @JvmName("ofcemjqlbkmecnkg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the project in the CodeCatalyst space.
     * The following arguments are optional:
     */
    @JvmName("dbjcqcmvafrgpsxi")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value The name of the CodeCatalyst space.
     */
    @JvmName("dflnawtjfuiathdt")
    public suspend fun spaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spaceName = mapped
    }

    internal fun build(): SourceRepositoryArgs = SourceRepositoryArgs(
        description = description,
        name = name,
        projectName = projectName,
        spaceName = spaceName,
    )
}
