@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codecatalyst.kotlin.inputs

import com.pulumi.aws.codecatalyst.inputs.DevEnvironmentRepositoryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property branchName The name of the branch in a source repository.
 * persistent storage (` persistent_storage`) supports the following:
 * @property repositoryName The name of the source repository.
 */
public data class DevEnvironmentRepositoryArgs(
    public val branchName: Output<String>? = null,
    public val repositoryName: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.codecatalyst.inputs.DevEnvironmentRepositoryArgs> {
    override fun toJava(): com.pulumi.aws.codecatalyst.inputs.DevEnvironmentRepositoryArgs =
        com.pulumi.aws.codecatalyst.inputs.DevEnvironmentRepositoryArgs.builder()
            .branchName(branchName?.applyValue({ args0 -> args0 }))
            .repositoryName(repositoryName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DevEnvironmentRepositoryArgs].
 */
@PulumiTagMarker
public class DevEnvironmentRepositoryArgsBuilder internal constructor() {
    private var branchName: Output<String>? = null

    private var repositoryName: Output<String>? = null

    /**
     * @param value The name of the branch in a source repository.
     * persistent storage (` persistent_storage`) supports the following:
     */
    @JvmName("wxuinnphrbqpxhwf")
    public suspend fun branchName(`value`: Output<String>) {
        this.branchName = value
    }

    /**
     * @param value The name of the source repository.
     */
    @JvmName("yyesrwywcdwrwopu")
    public suspend fun repositoryName(`value`: Output<String>) {
        this.repositoryName = value
    }

    /**
     * @param value The name of the branch in a source repository.
     * persistent storage (` persistent_storage`) supports the following:
     */
    @JvmName("kwrfmarivpkdqxvu")
    public suspend fun branchName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.branchName = mapped
    }

    /**
     * @param value The name of the source repository.
     */
    @JvmName("rnmyjdjumrlopmeq")
    public suspend fun repositoryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.repositoryName = mapped
    }

    internal fun build(): DevEnvironmentRepositoryArgs = DevEnvironmentRepositoryArgs(
        branchName = branchName,
        repositoryName = repositoryName ?: throw PulumiNullFieldException("repositoryName"),
    )
}
