@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codecatalyst.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property name The name of the IDE. Valid values include Cloud9, IntelliJ, PyCharm, GoLand, and VSCode.
 * @property runtime A link to the IDE runtime image. This parameter is not required if the name is VSCode. Values of the runtime can be for example public.ecr.aws/jetbrains/py,public.ecr.aws/jetbrains/go
 */
public data class DevEnvironmentIdes(
    public val name: String? = null,
    public val runtime: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codecatalyst.outputs.DevEnvironmentIdes): DevEnvironmentIdes = DevEnvironmentIdes(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            runtime = javaType.runtime().map({ args0 -> args0 }).orElse(null),
        )
    }
}
