@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codecatalyst.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property branchName The name of the branch in a source repository.
 * persistent storage (` persistent_storage`) supports the following:
 * @property repositoryName The name of the source repository.
 */
public data class DevEnvironmentRepository(
    public val branchName: String? = null,
    public val repositoryName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codecatalyst.outputs.DevEnvironmentRepository): DevEnvironmentRepository = DevEnvironmentRepository(
            branchName = javaType.branchName().map({ args0 -> args0 }).orElse(null),
            repositoryName = javaType.repositoryName(),
        )
    }
}
