@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codecommit.kotlin

import com.pulumi.aws.codecommit.ApprovalRuleTemplateAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Associates a CodeCommit Approval Rule Template with a Repository.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.codecommit.ApprovalRuleTemplateAssociation("example", {
 *     approvalRuleTemplateName: exampleAwsCodecommitApprovalRuleTemplate.name,
 *     repositoryName: exampleAwsCodecommitRepository.repositoryName,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.codecommit.ApprovalRuleTemplateAssociation("example",
 *     approval_rule_template_name=example_aws_codecommit_approval_rule_template["name"],
 *     repository_name=example_aws_codecommit_repository["repositoryName"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CodeCommit.ApprovalRuleTemplateAssociation("example", new()
 *     {
 *         ApprovalRuleTemplateName = exampleAwsCodecommitApprovalRuleTemplate.Name,
 *         RepositoryName = exampleAwsCodecommitRepository.RepositoryName,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codecommit"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := codecommit.NewApprovalRuleTemplateAssociation(ctx, "example", &codecommit.ApprovalRuleTemplateAssociationArgs{
 * 			ApprovalRuleTemplateName: pulumi.Any(exampleAwsCodecommitApprovalRuleTemplate.Name),
 * 			RepositoryName:           pulumi.Any(exampleAwsCodecommitRepository.RepositoryName),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codecommit.ApprovalRuleTemplateAssociation;
 * import com.pulumi.aws.codecommit.ApprovalRuleTemplateAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ApprovalRuleTemplateAssociation("example", ApprovalRuleTemplateAssociationArgs.builder()
 *             .approvalRuleTemplateName(exampleAwsCodecommitApprovalRuleTemplate.name())
 *             .repositoryName(exampleAwsCodecommitRepository.repositoryName())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:codecommit:ApprovalRuleTemplateAssociation
 *     properties:
 *       approvalRuleTemplateName: ${exampleAwsCodecommitApprovalRuleTemplate.name}
 *       repositoryName: ${exampleAwsCodecommitRepository.repositoryName}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CodeCommit approval rule template associations using the `approval_rule_template_name` and `repository_name` separated by a comma (`,`). For example:
 * ```sh
 * $ pulumi import aws:codecommit/approvalRuleTemplateAssociation:ApprovalRuleTemplateAssociation example approver-rule-for-example,MyExampleRepo
 * ```
 * @property approvalRuleTemplateName The name for the approval rule template.
 * @property repositoryName The name of the repository that you want to associate with the template.
 */
public data class ApprovalRuleTemplateAssociationArgs(
    public val approvalRuleTemplateName: Output<String>? = null,
    public val repositoryName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.codecommit.ApprovalRuleTemplateAssociationArgs> {
    override fun toJava(): com.pulumi.aws.codecommit.ApprovalRuleTemplateAssociationArgs =
        com.pulumi.aws.codecommit.ApprovalRuleTemplateAssociationArgs.builder()
            .approvalRuleTemplateName(approvalRuleTemplateName?.applyValue({ args0 -> args0 }))
            .repositoryName(repositoryName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApprovalRuleTemplateAssociationArgs].
 */
@PulumiTagMarker
public class ApprovalRuleTemplateAssociationArgsBuilder internal constructor() {
    private var approvalRuleTemplateName: Output<String>? = null

    private var repositoryName: Output<String>? = null

    /**
     * @param value The name for the approval rule template.
     */
    @JvmName("kxehqgiawrxcsdcp")
    public suspend fun approvalRuleTemplateName(`value`: Output<String>) {
        this.approvalRuleTemplateName = value
    }

    /**
     * @param value The name of the repository that you want to associate with the template.
     */
    @JvmName("iojuljaqbrskrrix")
    public suspend fun repositoryName(`value`: Output<String>) {
        this.repositoryName = value
    }

    /**
     * @param value The name for the approval rule template.
     */
    @JvmName("rnxemwwowtapeald")
    public suspend fun approvalRuleTemplateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.approvalRuleTemplateName = mapped
    }

    /**
     * @param value The name of the repository that you want to associate with the template.
     */
    @JvmName("oehmxrebgqioevha")
    public suspend fun repositoryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repositoryName = mapped
    }

    internal fun build(): ApprovalRuleTemplateAssociationArgs = ApprovalRuleTemplateAssociationArgs(
        approvalRuleTemplateName = approvalRuleTemplateName,
        repositoryName = repositoryName,
    )
}
