@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codecommit.kotlin

import com.pulumi.aws.codecommit.CodecommitFunctions.getApprovalRuleTemplatePlain
import com.pulumi.aws.codecommit.CodecommitFunctions.getRepositoryPlain
import com.pulumi.aws.codecommit.kotlin.inputs.GetApprovalRuleTemplatePlainArgs
import com.pulumi.aws.codecommit.kotlin.inputs.GetApprovalRuleTemplatePlainArgsBuilder
import com.pulumi.aws.codecommit.kotlin.inputs.GetRepositoryPlainArgs
import com.pulumi.aws.codecommit.kotlin.inputs.GetRepositoryPlainArgsBuilder
import com.pulumi.aws.codecommit.kotlin.outputs.GetApprovalRuleTemplateResult
import com.pulumi.aws.codecommit.kotlin.outputs.GetRepositoryResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.codecommit.kotlin.outputs.GetApprovalRuleTemplateResult.Companion.toKotlin as getApprovalRuleTemplateResultToKotlin
import com.pulumi.aws.codecommit.kotlin.outputs.GetRepositoryResult.Companion.toKotlin as getRepositoryResultToKotlin

public object CodecommitFunctions {
    /**
     * Provides details about a specific CodeCommit Approval Rule Template.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.codecommit.getApprovalRuleTemplate({
     *     name: "MyExampleApprovalRuleTemplate",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.codecommit.get_approval_rule_template(name="MyExampleApprovalRuleTemplate")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.CodeCommit.GetApprovalRuleTemplate.Invoke(new()
     *     {
     *         Name = "MyExampleApprovalRuleTemplate",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codecommit"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := codecommit.LookupApprovalRuleTemplate(ctx, &codecommit.LookupApprovalRuleTemplateArgs{
     * 			Name: "MyExampleApprovalRuleTemplate",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.codecommit.CodecommitFunctions;
     * import com.pulumi.aws.codecommit.inputs.GetApprovalRuleTemplateArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CodecommitFunctions.getApprovalRuleTemplate(GetApprovalRuleTemplateArgs.builder()
     *             .name("MyExampleApprovalRuleTemplate")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:codecommit:getApprovalRuleTemplate
     *       Arguments:
     *         name: MyExampleApprovalRuleTemplate
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getApprovalRuleTemplate.
     * @return A collection of values returned by getApprovalRuleTemplate.
     */
    public suspend fun getApprovalRuleTemplate(argument: GetApprovalRuleTemplatePlainArgs): GetApprovalRuleTemplateResult =
        getApprovalRuleTemplateResultToKotlin(getApprovalRuleTemplatePlain(argument.toJava()).await())

    /**
     * @see [getApprovalRuleTemplate].
     * @param name Name for the approval rule template. This needs to be less than 100 characters.
     * @return A collection of values returned by getApprovalRuleTemplate.
     */
    public suspend fun getApprovalRuleTemplate(name: String): GetApprovalRuleTemplateResult {
        val argument = GetApprovalRuleTemplatePlainArgs(
            name = name,
        )
        return getApprovalRuleTemplateResultToKotlin(getApprovalRuleTemplatePlain(argument.toJava()).await())
    }

    /**
     * @see [getApprovalRuleTemplate].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;codecommit&#46;kotlin&#46;inputs&#46;GetApprovalRuleTemplatePlainArgs].
     * @return A collection of values returned by getApprovalRuleTemplate.
     */
    public suspend fun getApprovalRuleTemplate(argument: suspend GetApprovalRuleTemplatePlainArgsBuilder.() -> Unit): GetApprovalRuleTemplateResult {
        val builder = GetApprovalRuleTemplatePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApprovalRuleTemplateResultToKotlin(getApprovalRuleTemplatePlain(builtArgument.toJava()).await())
    }

    /**
     * The CodeCommit Repository data source allows the ARN, Repository ID, Repository URL for HTTP and Repository URL for SSH to be retrieved for an CodeCommit repository.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.codecommit.getRepository({
     *     repositoryName: "MyTestRepository",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.codecommit.get_repository(repository_name="MyTestRepository")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.CodeCommit.GetRepository.Invoke(new()
     *     {
     *         RepositoryName = "MyTestRepository",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codecommit"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := codecommit.LookupRepository(ctx, &codecommit.LookupRepositoryArgs{
     * 			RepositoryName: "MyTestRepository",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.codecommit.CodecommitFunctions;
     * import com.pulumi.aws.codecommit.inputs.GetRepositoryArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = CodecommitFunctions.getRepository(GetRepositoryArgs.builder()
     *             .repositoryName("MyTestRepository")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:codecommit:getRepository
     *       Arguments:
     *         repositoryName: MyTestRepository
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRepository.
     * @return A collection of values returned by getRepository.
     */
    public suspend fun getRepository(argument: GetRepositoryPlainArgs): GetRepositoryResult =
        getRepositoryResultToKotlin(getRepositoryPlain(argument.toJava()).await())

    /**
     * @see [getRepository].
     * @param repositoryName Name for the repository. This needs to be less than 100 characters.
     * @return A collection of values returned by getRepository.
     */
    public suspend fun getRepository(repositoryName: String): GetRepositoryResult {
        val argument = GetRepositoryPlainArgs(
            repositoryName = repositoryName,
        )
        return getRepositoryResultToKotlin(getRepositoryPlain(argument.toJava()).await())
    }

    /**
     * @see [getRepository].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;codecommit&#46;kotlin&#46;inputs&#46;GetRepositoryPlainArgs].
     * @return A collection of values returned by getRepository.
     */
    public suspend fun getRepository(argument: suspend GetRepositoryPlainArgsBuilder.() -> Unit): GetRepositoryResult {
        val builder = GetRepositoryPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRepositoryResultToKotlin(getRepositoryPlain(builtArgument.toJava()).await())
    }
}
