@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codecommit.kotlin

import com.pulumi.aws.codecommit.RepositoryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a CodeCommit Repository Resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.codecommit.Repository("test", {
 *     repositoryName: "MyTestRepository",
 *     description: "This is the Sample App Repository",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.codecommit.Repository("test",
 *     repository_name="MyTestRepository",
 *     description="This is the Sample App Repository")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.CodeCommit.Repository("test", new()
 *     {
 *         RepositoryName = "MyTestRepository",
 *         Description = "This is the Sample App Repository",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codecommit"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := codecommit.NewRepository(ctx, "test", &codecommit.RepositoryArgs{
 * 			RepositoryName: pulumi.String("MyTestRepository"),
 * 			Description:    pulumi.String("This is the Sample App Repository"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codecommit.Repository;
 * import com.pulumi.aws.codecommit.RepositoryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Repository("test", RepositoryArgs.builder()
 *             .repositoryName("MyTestRepository")
 *             .description("This is the Sample App Repository")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:codecommit:Repository
 *     properties:
 *       repositoryName: MyTestRepository
 *       description: This is the Sample App Repository
 * ```
 * <!--End PulumiCodeChooser -->
 * ### AWS KMS Customer Managed Keys (CMK)
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testKey = new aws.kms.Key("test", {
 *     description: "test",
 *     deletionWindowInDays: 7,
 * });
 * const test = new aws.codecommit.Repository("test", {
 *     repositoryName: "MyTestRepository",
 *     description: "This is the Sample App Repository",
 *     kmsKeyId: testKey.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test_key = aws.kms.Key("test",
 *     description="test",
 *     deletion_window_in_days=7)
 * test = aws.codecommit.Repository("test",
 *     repository_name="MyTestRepository",
 *     description="This is the Sample App Repository",
 *     kms_key_id=test_key.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testKey = new Aws.Kms.Key("test", new()
 *     {
 *         Description = "test",
 *         DeletionWindowInDays = 7,
 *     });
 *     var test = new Aws.CodeCommit.Repository("test", new()
 *     {
 *         RepositoryName = "MyTestRepository",
 *         Description = "This is the Sample App Repository",
 *         KmsKeyId = testKey.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codecommit"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		testKey, err := kms.NewKey(ctx, "test", &kms.KeyArgs{
 * 			Description:          pulumi.String("test"),
 * 			DeletionWindowInDays: pulumi.Int(7),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = codecommit.NewRepository(ctx, "test", &codecommit.RepositoryArgs{
 * 			RepositoryName: pulumi.String("MyTestRepository"),
 * 			Description:    pulumi.String("This is the Sample App Repository"),
 * 			KmsKeyId:       testKey.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.codecommit.Repository;
 * import com.pulumi.aws.codecommit.RepositoryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testKey = new Key("testKey", KeyArgs.builder()
 *             .description("test")
 *             .deletionWindowInDays(7)
 *             .build());
 *         var test = new Repository("test", RepositoryArgs.builder()
 *             .repositoryName("MyTestRepository")
 *             .description("This is the Sample App Repository")
 *             .kmsKeyId(testKey.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:codecommit:Repository
 *     properties:
 *       repositoryName: MyTestRepository
 *       description: This is the Sample App Repository
 *       kmsKeyId: ${testKey.arn}
 *   testKey:
 *     type: aws:kms:Key
 *     name: test
 *     properties:
 *       description: test
 *       deletionWindowInDays: 7
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CodeCommit repository using repository name. For example:
 * ```sh
 * $ pulumi import aws:codecommit/repository:Repository imported ExistingRepo
 * ```
 * @property defaultBranch The default branch of the repository. The branch specified here needs to exist.
 * @property description The description of the repository. This needs to be less than 1000 characters
 * @property kmsKeyId The ARN of the encryption key. If no key is specified, the default `aws/codecommit` Amazon Web Services managed key is used.
 * @property repositoryName The name for the repository. This needs to be less than 100 characters.
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class RepositoryArgs(
    public val defaultBranch: Output<String>? = null,
    public val description: Output<String>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val repositoryName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.codecommit.RepositoryArgs> {
    override fun toJava(): com.pulumi.aws.codecommit.RepositoryArgs =
        com.pulumi.aws.codecommit.RepositoryArgs.builder()
            .defaultBranch(defaultBranch?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .repositoryName(repositoryName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [RepositoryArgs].
 */
@PulumiTagMarker
public class RepositoryArgsBuilder internal constructor() {
    private var defaultBranch: Output<String>? = null

    private var description: Output<String>? = null

    private var kmsKeyId: Output<String>? = null

    private var repositoryName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The default branch of the repository. The branch specified here needs to exist.
     */
    @JvmName("gdeutbfdtnrkwwsh")
    public suspend fun defaultBranch(`value`: Output<String>) {
        this.defaultBranch = value
    }

    /**
     * @param value The description of the repository. This needs to be less than 1000 characters
     */
    @JvmName("torxwqmbdvbhcyuq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The ARN of the encryption key. If no key is specified, the default `aws/codecommit` Amazon Web Services managed key is used.
     */
    @JvmName("aniueblruucoecwq")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value The name for the repository. This needs to be less than 100 characters.
     */
    @JvmName("gqdcwuglacbhlecf")
    public suspend fun repositoryName(`value`: Output<String>) {
        this.repositoryName = value
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ouqkbcvpijlbsskj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The default branch of the repository. The branch specified here needs to exist.
     */
    @JvmName("ewobpmhhnjbkbpls")
    public suspend fun defaultBranch(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultBranch = mapped
    }

    /**
     * @param value The description of the repository. This needs to be less than 1000 characters
     */
    @JvmName("ngtucbmmdtafvybn")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The ARN of the encryption key. If no key is specified, the default `aws/codecommit` Amazon Web Services managed key is used.
     */
    @JvmName("nidnyctbwmhuttwl")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value The name for the repository. This needs to be less than 100 characters.
     */
    @JvmName("fwxkiqijitxoqfso")
    public suspend fun repositoryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repositoryName = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tqurrxaeqlljjpfb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("uyalxvcneonhhjnm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): RepositoryArgs = RepositoryArgs(
        defaultBranch = defaultBranch,
        description = description,
        kmsKeyId = kmsKeyId,
        repositoryName = repositoryName,
        tags = tags,
    )
}
