@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codecommit.kotlin

import com.pulumi.aws.codecommit.kotlin.outputs.TriggerTrigger
import com.pulumi.aws.codecommit.kotlin.outputs.TriggerTrigger.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Trigger].
 */
@PulumiTagMarker
public class TriggerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TriggerArgs = TriggerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TriggerArgsBuilder.() -> Unit) {
        val builder = TriggerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Trigger {
        val builtJavaResource = com.pulumi.aws.codecommit.Trigger(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Trigger(builtJavaResource)
    }
}

/**
 * Provides a CodeCommit Trigger Resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.codecommit.Repository("test", {repositoryName: "test"});
 * const testTrigger = new aws.codecommit.Trigger("test", {
 *     repositoryName: test.repositoryName,
 *     triggers: [{
 *         name: "all",
 *         events: ["all"],
 *         destinationArn: testAwsSnsTopic.arn,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.codecommit.Repository("test", repository_name="test")
 * test_trigger = aws.codecommit.Trigger("test",
 *     repository_name=test.repository_name,
 *     triggers=[{
 *         "name": "all",
 *         "events": ["all"],
 *         "destination_arn": test_aws_sns_topic["arn"],
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.CodeCommit.Repository("test", new()
 *     {
 *         RepositoryName = "test",
 *     });
 *     var testTrigger = new Aws.CodeCommit.Trigger("test", new()
 *     {
 *         RepositoryName = test.RepositoryName,
 *         Triggers = new[]
 *         {
 *             new Aws.CodeCommit.Inputs.TriggerTriggerArgs
 *             {
 *                 Name = "all",
 *                 Events = new[]
 *                 {
 *                     "all",
 *                 },
 *                 DestinationArn = testAwsSnsTopic.Arn,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codecommit"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		test, err := codecommit.NewRepository(ctx, "test", &codecommit.RepositoryArgs{
 * 			RepositoryName: pulumi.String("test"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = codecommit.NewTrigger(ctx, "test", &codecommit.TriggerArgs{
 * 			RepositoryName: test.RepositoryName,
 * 			Triggers: codecommit.TriggerTriggerArray{
 * 				&codecommit.TriggerTriggerArgs{
 * 					Name: pulumi.String("all"),
 * 					Events: pulumi.StringArray{
 * 						pulumi.String("all"),
 * 					},
 * 					DestinationArn: pulumi.Any(testAwsSnsTopic.Arn),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codecommit.Repository;
 * import com.pulumi.aws.codecommit.RepositoryArgs;
 * import com.pulumi.aws.codecommit.Trigger;
 * import com.pulumi.aws.codecommit.TriggerArgs;
 * import com.pulumi.aws.codecommit.inputs.TriggerTriggerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Repository("test", RepositoryArgs.builder()
 *             .repositoryName("test")
 *             .build());
 *         var testTrigger = new Trigger("testTrigger", TriggerArgs.builder()
 *             .repositoryName(test.repositoryName())
 *             .triggers(TriggerTriggerArgs.builder()
 *                 .name("all")
 *                 .events("all")
 *                 .destinationArn(testAwsSnsTopic.arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:codecommit:Repository
 *     properties:
 *       repositoryName: test
 *   testTrigger:
 *     type: aws:codecommit:Trigger
 *     name: test
 *     properties:
 *       repositoryName: ${test.repositoryName}
 *       triggers:
 *         - name: all
 *           events:
 *             - all
 *           destinationArn: ${testAwsSnsTopic.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class Trigger internal constructor(
    override val javaResource: com.pulumi.aws.codecommit.Trigger,
) : KotlinCustomResource(javaResource, TriggerMapper) {
    /**
     * System-generated unique identifier.
     */
    public val configurationId: Output<String>
        get() = javaResource.configurationId().applyValue({ args0 -> args0 })

    /**
     * The name for the repository. This needs to be less than 100 characters.
     */
    public val repositoryName: Output<String>
        get() = javaResource.repositoryName().applyValue({ args0 -> args0 })

    /**
     * The name of the trigger.
     */
    public val triggers: Output<List<TriggerTrigger>>
        get() = javaResource.triggers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })
}

public object TriggerMapper : ResourceMapper<Trigger> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.codecommit.Trigger::class == javaResource::class

    override fun map(javaResource: Resource): Trigger = Trigger(
        javaResource as
            com.pulumi.aws.codecommit.Trigger,
    )
}

/**
 * @see [Trigger].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Trigger].
 */
public suspend fun trigger(name: String, block: suspend TriggerResourceBuilder.() -> Unit): Trigger {
    val builder = TriggerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Trigger].
 * @param name The _unique_ name of the resulting resource.
 */
public fun trigger(name: String): Trigger {
    val builder = TriggerResourceBuilder()
    builder.name(name)
    return builder.build()
}
