@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codecommit.kotlin

import com.pulumi.aws.codecommit.TriggerArgs.builder
import com.pulumi.aws.codecommit.kotlin.inputs.TriggerTriggerArgs
import com.pulumi.aws.codecommit.kotlin.inputs.TriggerTriggerArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a CodeCommit Trigger Resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.codecommit.Repository("test", {repositoryName: "test"});
 * const testTrigger = new aws.codecommit.Trigger("test", {
 *     repositoryName: test.repositoryName,
 *     triggers: [{
 *         name: "all",
 *         events: ["all"],
 *         destinationArn: testAwsSnsTopic.arn,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.codecommit.Repository("test", repository_name="test")
 * test_trigger = aws.codecommit.Trigger("test",
 *     repository_name=test.repository_name,
 *     triggers=[{
 *         "name": "all",
 *         "events": ["all"],
 *         "destination_arn": test_aws_sns_topic["arn"],
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.CodeCommit.Repository("test", new()
 *     {
 *         RepositoryName = "test",
 *     });
 *     var testTrigger = new Aws.CodeCommit.Trigger("test", new()
 *     {
 *         RepositoryName = test.RepositoryName,
 *         Triggers = new[]
 *         {
 *             new Aws.CodeCommit.Inputs.TriggerTriggerArgs
 *             {
 *                 Name = "all",
 *                 Events = new[]
 *                 {
 *                     "all",
 *                 },
 *                 DestinationArn = testAwsSnsTopic.Arn,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codecommit"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		test, err := codecommit.NewRepository(ctx, "test", &codecommit.RepositoryArgs{
 * 			RepositoryName: pulumi.String("test"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = codecommit.NewTrigger(ctx, "test", &codecommit.TriggerArgs{
 * 			RepositoryName: test.RepositoryName,
 * 			Triggers: codecommit.TriggerTriggerArray{
 * 				&codecommit.TriggerTriggerArgs{
 * 					Name: pulumi.String("all"),
 * 					Events: pulumi.StringArray{
 * 						pulumi.String("all"),
 * 					},
 * 					DestinationArn: pulumi.Any(testAwsSnsTopic.Arn),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codecommit.Repository;
 * import com.pulumi.aws.codecommit.RepositoryArgs;
 * import com.pulumi.aws.codecommit.Trigger;
 * import com.pulumi.aws.codecommit.TriggerArgs;
 * import com.pulumi.aws.codecommit.inputs.TriggerTriggerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Repository("test", RepositoryArgs.builder()
 *             .repositoryName("test")
 *             .build());
 *         var testTrigger = new Trigger("testTrigger", TriggerArgs.builder()
 *             .repositoryName(test.repositoryName())
 *             .triggers(TriggerTriggerArgs.builder()
 *                 .name("all")
 *                 .events("all")
 *                 .destinationArn(testAwsSnsTopic.arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:codecommit:Repository
 *     properties:
 *       repositoryName: test
 *   testTrigger:
 *     type: aws:codecommit:Trigger
 *     name: test
 *     properties:
 *       repositoryName: ${test.repositoryName}
 *       triggers:
 *         - name: all
 *           events:
 *             - all
 *           destinationArn: ${testAwsSnsTopic.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * @property repositoryName The name for the repository. This needs to be less than 100 characters.
 * @property triggers The name of the trigger.
 */
public data class TriggerArgs(
    public val repositoryName: Output<String>? = null,
    public val triggers: Output<List<TriggerTriggerArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.codecommit.TriggerArgs> {
    override fun toJava(): com.pulumi.aws.codecommit.TriggerArgs =
        com.pulumi.aws.codecommit.TriggerArgs.builder()
            .repositoryName(repositoryName?.applyValue({ args0 -> args0 }))
            .triggers(
                triggers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [TriggerArgs].
 */
@PulumiTagMarker
public class TriggerArgsBuilder internal constructor() {
    private var repositoryName: Output<String>? = null

    private var triggers: Output<List<TriggerTriggerArgs>>? = null

    /**
     * @param value The name for the repository. This needs to be less than 100 characters.
     */
    @JvmName("isgqbmwauhprbyej")
    public suspend fun repositoryName(`value`: Output<String>) {
        this.repositoryName = value
    }

    /**
     * @param value The name of the trigger.
     */
    @JvmName("cqupovwnvvqjgfnv")
    public suspend fun triggers(`value`: Output<List<TriggerTriggerArgs>>) {
        this.triggers = value
    }

    @JvmName("sgafjsigjuqgjyrk")
    public suspend fun triggers(vararg values: Output<TriggerTriggerArgs>) {
        this.triggers = Output.all(values.asList())
    }

    /**
     * @param values The name of the trigger.
     */
    @JvmName("mtunoqwagoqrqmqe")
    public suspend fun triggers(values: List<Output<TriggerTriggerArgs>>) {
        this.triggers = Output.all(values)
    }

    /**
     * @param value The name for the repository. This needs to be less than 100 characters.
     */
    @JvmName("jhtdclbapbiimrwf")
    public suspend fun repositoryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repositoryName = mapped
    }

    /**
     * @param value The name of the trigger.
     */
    @JvmName("pdtrfbembahkbrdu")
    public suspend fun triggers(`value`: List<TriggerTriggerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.triggers = mapped
    }

    /**
     * @param argument The name of the trigger.
     */
    @JvmName("xxuhfhtdrumhhijc")
    public suspend fun triggers(argument: List<suspend TriggerTriggerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TriggerTriggerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.triggers = mapped
    }

    /**
     * @param argument The name of the trigger.
     */
    @JvmName("qdfwpnvuooraplql")
    public suspend fun triggers(vararg argument: suspend TriggerTriggerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TriggerTriggerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.triggers = mapped
    }

    /**
     * @param argument The name of the trigger.
     */
    @JvmName("qvliqkwaobvymxnd")
    public suspend fun triggers(argument: suspend TriggerTriggerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TriggerTriggerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.triggers = mapped
    }

    /**
     * @param values The name of the trigger.
     */
    @JvmName("fogslqsjbmouapkq")
    public suspend fun triggers(vararg values: TriggerTriggerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.triggers = mapped
    }

    internal fun build(): TriggerArgs = TriggerArgs(
        repositoryName = repositoryName,
        triggers = triggers,
    )
}
