@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codecommit.kotlin.inputs

import com.pulumi.aws.codecommit.inputs.GetRepositoryPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRepository.
 * @property repositoryName Name for the repository. This needs to be less than 100 characters.
 */
public data class GetRepositoryPlainArgs(
    public val repositoryName: String,
) : ConvertibleToJava<com.pulumi.aws.codecommit.inputs.GetRepositoryPlainArgs> {
    override fun toJava(): com.pulumi.aws.codecommit.inputs.GetRepositoryPlainArgs =
        com.pulumi.aws.codecommit.inputs.GetRepositoryPlainArgs.builder()
            .repositoryName(repositoryName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRepositoryPlainArgs].
 */
@PulumiTagMarker
public class GetRepositoryPlainArgsBuilder internal constructor() {
    private var repositoryName: String? = null

    /**
     * @param value Name for the repository. This needs to be less than 100 characters.
     */
    @JvmName("fbhdssmnohdovmgv")
    public suspend fun repositoryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.repositoryName = mapped
    }

    internal fun build(): GetRepositoryPlainArgs = GetRepositoryPlainArgs(
        repositoryName = repositoryName ?: throw PulumiNullFieldException("repositoryName"),
    )
}
