@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codecommit.kotlin.inputs

import com.pulumi.aws.codecommit.inputs.TriggerTriggerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property branches The branches that will be included in the trigger configuration. If no branches   are specified, the trigger will apply to all branches.
 * @property customData Any custom data associated with the trigger that will be included in the information sent to the target of the trigger.
 * @property destinationArn The ARN of the resource that is the target for a trigger. For example, the ARN of a topic in Amazon Simple Notification Service (SNS).
 * @property events The repository events that will cause the trigger to run actions in another service, such as sending a notification through Amazon Simple Notification Service (SNS). If no events are specified, the trigger will run for all repository events. Event types include: `all`, `updateReference`, `createReference`, `deleteReference`.
 * @property name The name of the trigger.
 */
public data class TriggerTriggerArgs(
    public val branches: Output<List<String>>? = null,
    public val customData: Output<String>? = null,
    public val destinationArn: Output<String>,
    public val events: Output<List<String>>,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.codecommit.inputs.TriggerTriggerArgs> {
    override fun toJava(): com.pulumi.aws.codecommit.inputs.TriggerTriggerArgs =
        com.pulumi.aws.codecommit.inputs.TriggerTriggerArgs.builder()
            .branches(branches?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .customData(customData?.applyValue({ args0 -> args0 }))
            .destinationArn(destinationArn.applyValue({ args0 -> args0 }))
            .events(events.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TriggerTriggerArgs].
 */
@PulumiTagMarker
public class TriggerTriggerArgsBuilder internal constructor() {
    private var branches: Output<List<String>>? = null

    private var customData: Output<String>? = null

    private var destinationArn: Output<String>? = null

    private var events: Output<List<String>>? = null

    private var name: Output<String>? = null

    /**
     * @param value The branches that will be included in the trigger configuration. If no branches   are specified, the trigger will apply to all branches.
     */
    @JvmName("nspuynjgmicijvvr")
    public suspend fun branches(`value`: Output<List<String>>) {
        this.branches = value
    }

    @JvmName("iqqgrmvlyrmseylw")
    public suspend fun branches(vararg values: Output<String>) {
        this.branches = Output.all(values.asList())
    }

    /**
     * @param values The branches that will be included in the trigger configuration. If no branches   are specified, the trigger will apply to all branches.
     */
    @JvmName("lcxqqyonquumyxge")
    public suspend fun branches(values: List<Output<String>>) {
        this.branches = Output.all(values)
    }

    /**
     * @param value Any custom data associated with the trigger that will be included in the information sent to the target of the trigger.
     */
    @JvmName("mxmlgdyoghodorlv")
    public suspend fun customData(`value`: Output<String>) {
        this.customData = value
    }

    /**
     * @param value The ARN of the resource that is the target for a trigger. For example, the ARN of a topic in Amazon Simple Notification Service (SNS).
     */
    @JvmName("hygshyualkoooqfo")
    public suspend fun destinationArn(`value`: Output<String>) {
        this.destinationArn = value
    }

    /**
     * @param value The repository events that will cause the trigger to run actions in another service, such as sending a notification through Amazon Simple Notification Service (SNS). If no events are specified, the trigger will run for all repository events. Event types include: `all`, `updateReference`, `createReference`, `deleteReference`.
     */
    @JvmName("qmuxqtovvcotrqpw")
    public suspend fun events(`value`: Output<List<String>>) {
        this.events = value
    }

    @JvmName("tqvocakwwywlhslu")
    public suspend fun events(vararg values: Output<String>) {
        this.events = Output.all(values.asList())
    }

    /**
     * @param values The repository events that will cause the trigger to run actions in another service, such as sending a notification through Amazon Simple Notification Service (SNS). If no events are specified, the trigger will run for all repository events. Event types include: `all`, `updateReference`, `createReference`, `deleteReference`.
     */
    @JvmName("iqadjatxcdonaafi")
    public suspend fun events(values: List<Output<String>>) {
        this.events = Output.all(values)
    }

    /**
     * @param value The name of the trigger.
     */
    @JvmName("pxdjbkvihbocerht")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The branches that will be included in the trigger configuration. If no branches   are specified, the trigger will apply to all branches.
     */
    @JvmName("uevqyukdmvadeway")
    public suspend fun branches(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.branches = mapped
    }

    /**
     * @param values The branches that will be included in the trigger configuration. If no branches   are specified, the trigger will apply to all branches.
     */
    @JvmName("bjlafcfvspusbduo")
    public suspend fun branches(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.branches = mapped
    }

    /**
     * @param value Any custom data associated with the trigger that will be included in the information sent to the target of the trigger.
     */
    @JvmName("qdipbhyripedfyko")
    public suspend fun customData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customData = mapped
    }

    /**
     * @param value The ARN of the resource that is the target for a trigger. For example, the ARN of a topic in Amazon Simple Notification Service (SNS).
     */
    @JvmName("upjhlogqihqenksy")
    public suspend fun destinationArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationArn = mapped
    }

    /**
     * @param value The repository events that will cause the trigger to run actions in another service, such as sending a notification through Amazon Simple Notification Service (SNS). If no events are specified, the trigger will run for all repository events. Event types include: `all`, `updateReference`, `createReference`, `deleteReference`.
     */
    @JvmName("nxpljtsysfqacvad")
    public suspend fun events(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.events = mapped
    }

    /**
     * @param values The repository events that will cause the trigger to run actions in another service, such as sending a notification through Amazon Simple Notification Service (SNS). If no events are specified, the trigger will run for all repository events. Event types include: `all`, `updateReference`, `createReference`, `deleteReference`.
     */
    @JvmName("mwngpchyqbxeknvr")
    public suspend fun events(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.events = mapped
    }

    /**
     * @param value The name of the trigger.
     */
    @JvmName("jxxnpsfucuvakygg")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): TriggerTriggerArgs = TriggerTriggerArgs(
        branches = branches,
        customData = customData,
        destinationArn = destinationArn ?: throw PulumiNullFieldException("destinationArn"),
        events = events ?: throw PulumiNullFieldException("events"),
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
