@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codecommit.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getRepository.
 * @property arn ARN of the repository.
 * @property cloneUrlHttp URL to use for cloning the repository over HTTPS.
 * @property cloneUrlSsh URL to use for cloning the repository over SSH.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property kmsKeyId The ID of the encryption key.
 * @property repositoryId ID of the repository.
 * @property repositoryName
 */
public data class GetRepositoryResult(
    public val arn: String,
    public val cloneUrlHttp: String,
    public val cloneUrlSsh: String,
    public val id: String,
    public val kmsKeyId: String,
    public val repositoryId: String,
    public val repositoryName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codecommit.outputs.GetRepositoryResult): GetRepositoryResult = GetRepositoryResult(
            arn = javaType.arn(),
            cloneUrlHttp = javaType.cloneUrlHttp(),
            cloneUrlSsh = javaType.cloneUrlSsh(),
            id = javaType.id(),
            kmsKeyId = javaType.kmsKeyId(),
            repositoryId = javaType.repositoryId(),
            repositoryName = javaType.repositoryName(),
        )
    }
}
