@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codedeploy.kotlin

import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentConfigMinimumHealthyHosts
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentConfigTrafficRoutingConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentConfigMinimumHealthyHosts.Companion.toKotlin as deploymentConfigMinimumHealthyHostsToKotlin
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentConfigTrafficRoutingConfig.Companion.toKotlin as deploymentConfigTrafficRoutingConfigToKotlin

/**
 * Builder for [DeploymentConfig].
 */
@PulumiTagMarker
public class DeploymentConfigResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DeploymentConfigArgs = DeploymentConfigArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DeploymentConfigArgsBuilder.() -> Unit) {
        val builder = DeploymentConfigArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DeploymentConfig {
        val builtJavaResource = com.pulumi.aws.codedeploy.DeploymentConfig(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DeploymentConfig(builtJavaResource)
    }
}

/**
 * Provides a CodeDeploy deployment config for an application
 * ## Example Usage
 * ### Server Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const foo = new aws.codedeploy.DeploymentConfig("foo", {
 *     deploymentConfigName: "test-deployment-config",
 *     minimumHealthyHosts: {
 *         type: "HOST_COUNT",
 *         value: 2,
 *     },
 * });
 * const fooDeploymentGroup = new aws.codedeploy.DeploymentGroup("foo", {
 *     appName: fooApp.name,
 *     deploymentGroupName: "bar",
 *     serviceRoleArn: fooRole.arn,
 *     deploymentConfigName: foo.id,
 *     ec2TagFilters: [{
 *         key: "filterkey",
 *         type: "KEY_AND_VALUE",
 *         value: "filtervalue",
 *     }],
 *     triggerConfigurations: [{
 *         triggerEvents: ["DeploymentFailure"],
 *         triggerName: "foo-trigger",
 *         triggerTargetArn: "foo-topic-arn",
 *     }],
 *     autoRollbackConfiguration: {
 *         enabled: true,
 *         events: ["DEPLOYMENT_FAILURE"],
 *     },
 *     alarmConfiguration: {
 *         alarms: ["my-alarm-name"],
 *         enabled: true,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * foo = aws.codedeploy.DeploymentConfig("foo",
 *     deployment_config_name="test-deployment-config",
 *     minimum_healthy_hosts={
 *         "type": "HOST_COUNT",
 *         "value": 2,
 *     })
 * foo_deployment_group = aws.codedeploy.DeploymentGroup("foo",
 *     app_name=foo_app["name"],
 *     deployment_group_name="bar",
 *     service_role_arn=foo_role["arn"],
 *     deployment_config_name=foo.id,
 *     ec2_tag_filters=[{
 *         "key": "filterkey",
 *         "type": "KEY_AND_VALUE",
 *         "value": "filtervalue",
 *     }],
 *     trigger_configurations=[{
 *         "trigger_events": ["DeploymentFailure"],
 *         "trigger_name": "foo-trigger",
 *         "trigger_target_arn": "foo-topic-arn",
 *     }],
 *     auto_rollback_configuration={
 *         "enabled": True,
 *         "events": ["DEPLOYMENT_FAILURE"],
 *     },
 *     alarm_configuration={
 *         "alarms": ["my-alarm-name"],
 *         "enabled": True,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = new Aws.CodeDeploy.DeploymentConfig("foo", new()
 *     {
 *         DeploymentConfigName = "test-deployment-config",
 *         MinimumHealthyHosts = new Aws.CodeDeploy.Inputs.DeploymentConfigMinimumHealthyHostsArgs
 *         {
 *             Type = "HOST_COUNT",
 *             Value = 2,
 *         },
 *     });
 *     var fooDeploymentGroup = new Aws.CodeDeploy.DeploymentGroup("foo", new()
 *     {
 *         AppName = fooApp.Name,
 *         DeploymentGroupName = "bar",
 *         ServiceRoleArn = fooRole.Arn,
 *         DeploymentConfigName = foo.Id,
 *         Ec2TagFilters = new[]
 *         {
 *             new Aws.CodeDeploy.Inputs.DeploymentGroupEc2TagFilterArgs
 *             {
 *                 Key = "filterkey",
 *                 Type = "KEY_AND_VALUE",
 *                 Value = "filtervalue",
 *             },
 *         },
 *         TriggerConfigurations = new[]
 *         {
 *             new Aws.CodeDeploy.Inputs.DeploymentGroupTriggerConfigurationArgs
 *             {
 *                 TriggerEvents = new[]
 *                 {
 *                     "DeploymentFailure",
 *                 },
 *                 TriggerName = "foo-trigger",
 *                 TriggerTargetArn = "foo-topic-arn",
 *             },
 *         },
 *         AutoRollbackConfiguration = new Aws.CodeDeploy.Inputs.DeploymentGroupAutoRollbackConfigurationArgs
 *         {
 *             Enabled = true,
 *             Events = new[]
 *             {
 *                 "DEPLOYMENT_FAILURE",
 *             },
 *         },
 *         AlarmConfiguration = new Aws.CodeDeploy.Inputs.DeploymentGroupAlarmConfigurationArgs
 *         {
 *             Alarms = new[]
 *             {
 *                 "my-alarm-name",
 *             },
 *             Enabled = true,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codedeploy"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		foo, err := codedeploy.NewDeploymentConfig(ctx, "foo", &codedeploy.DeploymentConfigArgs{
 * 			DeploymentConfigName: pulumi.String("test-deployment-config"),
 * 			MinimumHealthyHosts: &codedeploy.DeploymentConfigMinimumHealthyHostsArgs{
 * 				Type:  pulumi.String("HOST_COUNT"),
 * 				Value: pulumi.Int(2),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = codedeploy.NewDeploymentGroup(ctx, "foo", &codedeploy.DeploymentGroupArgs{
 * 			AppName:              pulumi.Any(fooApp.Name),
 * 			DeploymentGroupName:  pulumi.String("bar"),
 * 			ServiceRoleArn:       pulumi.Any(fooRole.Arn),
 * 			DeploymentConfigName: foo.ID(),
 * 			Ec2TagFilters: codedeploy.DeploymentGroupEc2TagFilterArray{
 * 				&codedeploy.DeploymentGroupEc2TagFilterArgs{
 * 					Key:   pulumi.String("filterkey"),
 * 					Type:  pulumi.String("KEY_AND_VALUE"),
 * 					Value: pulumi.String("filtervalue"),
 * 				},
 * 			},
 * 			TriggerConfigurations: codedeploy.DeploymentGroupTriggerConfigurationArray{
 * 				&codedeploy.DeploymentGroupTriggerConfigurationArgs{
 * 					TriggerEvents: pulumi.StringArray{
 * 						pulumi.String("DeploymentFailure"),
 * 					},
 * 					TriggerName:      pulumi.String("foo-trigger"),
 * 					TriggerTargetArn: pulumi.String("foo-topic-arn"),
 * 				},
 * 			},
 * 			AutoRollbackConfiguration: &codedeploy.DeploymentGroupAutoRollbackConfigurationArgs{
 * 				Enabled: pulumi.Bool(true),
 * 				Events: pulumi.StringArray{
 * 					pulumi.String("DEPLOYMENT_FAILURE"),
 * 				},
 * 			},
 * 			AlarmConfiguration: &codedeploy.DeploymentGroupAlarmConfigurationArgs{
 * 				Alarms: pulumi.StringArray{
 * 					pulumi.String("my-alarm-name"),
 * 				},
 * 				Enabled: pulumi.Bool(true),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codedeploy.DeploymentConfig;
 * import com.pulumi.aws.codedeploy.DeploymentConfigArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentConfigMinimumHealthyHostsArgs;
 * import com.pulumi.aws.codedeploy.DeploymentGroup;
 * import com.pulumi.aws.codedeploy.DeploymentGroupArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupEc2TagFilterArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupTriggerConfigurationArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupAutoRollbackConfigurationArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupAlarmConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new DeploymentConfig("foo", DeploymentConfigArgs.builder()
 *             .deploymentConfigName("test-deployment-config")
 *             .minimumHealthyHosts(DeploymentConfigMinimumHealthyHostsArgs.builder()
 *                 .type("HOST_COUNT")
 *                 .value(2)
 *                 .build())
 *             .build());
 *         var fooDeploymentGroup = new DeploymentGroup("fooDeploymentGroup", DeploymentGroupArgs.builder()
 *             .appName(fooApp.name())
 *             .deploymentGroupName("bar")
 *             .serviceRoleArn(fooRole.arn())
 *             .deploymentConfigName(foo.id())
 *             .ec2TagFilters(DeploymentGroupEc2TagFilterArgs.builder()
 *                 .key("filterkey")
 *                 .type("KEY_AND_VALUE")
 *                 .value("filtervalue")
 *                 .build())
 *             .triggerConfigurations(DeploymentGroupTriggerConfigurationArgs.builder()
 *                 .triggerEvents("DeploymentFailure")
 *                 .triggerName("foo-trigger")
 *                 .triggerTargetArn("foo-topic-arn")
 *                 .build())
 *             .autoRollbackConfiguration(DeploymentGroupAutoRollbackConfigurationArgs.builder()
 *                 .enabled(true)
 *                 .events("DEPLOYMENT_FAILURE")
 *                 .build())
 *             .alarmConfiguration(DeploymentGroupAlarmConfigurationArgs.builder()
 *                 .alarms("my-alarm-name")
 *                 .enabled(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: aws:codedeploy:DeploymentConfig
 *     properties:
 *       deploymentConfigName: test-deployment-config
 *       minimumHealthyHosts:
 *         type: HOST_COUNT
 *         value: 2
 *   fooDeploymentGroup:
 *     type: aws:codedeploy:DeploymentGroup
 *     name: foo
 *     properties:
 *       appName: ${fooApp.name}
 *       deploymentGroupName: bar
 *       serviceRoleArn: ${fooRole.arn}
 *       deploymentConfigName: ${foo.id}
 *       ec2TagFilters:
 *         - key: filterkey
 *           type: KEY_AND_VALUE
 *           value: filtervalue
 *       triggerConfigurations:
 *         - triggerEvents:
 *             - DeploymentFailure
 *           triggerName: foo-trigger
 *           triggerTargetArn: foo-topic-arn
 *       autoRollbackConfiguration:
 *         enabled: true
 *         events:
 *           - DEPLOYMENT_FAILURE
 *       alarmConfiguration:
 *         alarms:
 *           - my-alarm-name
 *         enabled: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Lambda Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const foo = new aws.codedeploy.DeploymentConfig("foo", {
 *     deploymentConfigName: "test-deployment-config",
 *     computePlatform: "Lambda",
 *     trafficRoutingConfig: {
 *         type: "TimeBasedLinear",
 *         timeBasedLinear: {
 *             interval: 10,
 *             percentage: 10,
 *         },
 *     },
 * });
 * const fooDeploymentGroup = new aws.codedeploy.DeploymentGroup("foo", {
 *     appName: fooApp.name,
 *     deploymentGroupName: "bar",
 *     serviceRoleArn: fooRole.arn,
 *     deploymentConfigName: foo.id,
 *     autoRollbackConfiguration: {
 *         enabled: true,
 *         events: ["DEPLOYMENT_STOP_ON_ALARM"],
 *     },
 *     alarmConfiguration: {
 *         alarms: ["my-alarm-name"],
 *         enabled: true,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * foo = aws.codedeploy.DeploymentConfig("foo",
 *     deployment_config_name="test-deployment-config",
 *     compute_platform="Lambda",
 *     traffic_routing_config={
 *         "type": "TimeBasedLinear",
 *         "time_based_linear": {
 *             "interval": 10,
 *             "percentage": 10,
 *         },
 *     })
 * foo_deployment_group = aws.codedeploy.DeploymentGroup("foo",
 *     app_name=foo_app["name"],
 *     deployment_group_name="bar",
 *     service_role_arn=foo_role["arn"],
 *     deployment_config_name=foo.id,
 *     auto_rollback_configuration={
 *         "enabled": True,
 *         "events": ["DEPLOYMENT_STOP_ON_ALARM"],
 *     },
 *     alarm_configuration={
 *         "alarms": ["my-alarm-name"],
 *         "enabled": True,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = new Aws.CodeDeploy.DeploymentConfig("foo", new()
 *     {
 *         DeploymentConfigName = "test-deployment-config",
 *         ComputePlatform = "Lambda",
 *         TrafficRoutingConfig = new Aws.CodeDeploy.Inputs.DeploymentConfigTrafficRoutingConfigArgs
 *         {
 *             Type = "TimeBasedLinear",
 *             TimeBasedLinear = new Aws.CodeDeploy.Inputs.DeploymentConfigTrafficRoutingConfigTimeBasedLinearArgs
 *             {
 *                 Interval = 10,
 *                 Percentage = 10,
 *             },
 *         },
 *     });
 *     var fooDeploymentGroup = new Aws.CodeDeploy.DeploymentGroup("foo", new()
 *     {
 *         AppName = fooApp.Name,
 *         DeploymentGroupName = "bar",
 *         ServiceRoleArn = fooRole.Arn,
 *         DeploymentConfigName = foo.Id,
 *         AutoRollbackConfiguration = new Aws.CodeDeploy.Inputs.DeploymentGroupAutoRollbackConfigurationArgs
 *         {
 *             Enabled = true,
 *             Events = new[]
 *             {
 *                 "DEPLOYMENT_STOP_ON_ALARM",
 *             },
 *         },
 *         AlarmConfiguration = new Aws.CodeDeploy.Inputs.DeploymentGroupAlarmConfigurationArgs
 *         {
 *             Alarms = new[]
 *             {
 *                 "my-alarm-name",
 *             },
 *             Enabled = true,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codedeploy"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		foo, err := codedeploy.NewDeploymentConfig(ctx, "foo", &codedeploy.DeploymentConfigArgs{
 * 			DeploymentConfigName: pulumi.String("test-deployment-config"),
 * 			ComputePlatform:      pulumi.String("Lambda"),
 * 			TrafficRoutingConfig: &codedeploy.DeploymentConfigTrafficRoutingConfigArgs{
 * 				Type: pulumi.String("TimeBasedLinear"),
 * 				TimeBasedLinear: &codedeploy.DeploymentConfigTrafficRoutingConfigTimeBasedLinearArgs{
 * 					Interval:   pulumi.Int(10),
 * 					Percentage: pulumi.Int(10),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = codedeploy.NewDeploymentGroup(ctx, "foo", &codedeploy.DeploymentGroupArgs{
 * 			AppName:              pulumi.Any(fooApp.Name),
 * 			DeploymentGroupName:  pulumi.String("bar"),
 * 			ServiceRoleArn:       pulumi.Any(fooRole.Arn),
 * 			DeploymentConfigName: foo.ID(),
 * 			AutoRollbackConfiguration: &codedeploy.DeploymentGroupAutoRollbackConfigurationArgs{
 * 				Enabled: pulumi.Bool(true),
 * 				Events: pulumi.StringArray{
 * 					pulumi.String("DEPLOYMENT_STOP_ON_ALARM"),
 * 				},
 * 			},
 * 			AlarmConfiguration: &codedeploy.DeploymentGroupAlarmConfigurationArgs{
 * 				Alarms: pulumi.StringArray{
 * 					pulumi.String("my-alarm-name"),
 * 				},
 * 				Enabled: pulumi.Bool(true),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codedeploy.DeploymentConfig;
 * import com.pulumi.aws.codedeploy.DeploymentConfigArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentConfigTrafficRoutingConfigArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentConfigTrafficRoutingConfigTimeBasedLinearArgs;
 * import com.pulumi.aws.codedeploy.DeploymentGroup;
 * import com.pulumi.aws.codedeploy.DeploymentGroupArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupAutoRollbackConfigurationArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupAlarmConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new DeploymentConfig("foo", DeploymentConfigArgs.builder()
 *             .deploymentConfigName("test-deployment-config")
 *             .computePlatform("Lambda")
 *             .trafficRoutingConfig(DeploymentConfigTrafficRoutingConfigArgs.builder()
 *                 .type("TimeBasedLinear")
 *                 .timeBasedLinear(DeploymentConfigTrafficRoutingConfigTimeBasedLinearArgs.builder()
 *                     .interval(10)
 *                     .percentage(10)
 *                     .build())
 *                 .build())
 *             .build());
 *         var fooDeploymentGroup = new DeploymentGroup("fooDeploymentGroup", DeploymentGroupArgs.builder()
 *             .appName(fooApp.name())
 *             .deploymentGroupName("bar")
 *             .serviceRoleArn(fooRole.arn())
 *             .deploymentConfigName(foo.id())
 *             .autoRollbackConfiguration(DeploymentGroupAutoRollbackConfigurationArgs.builder()
 *                 .enabled(true)
 *                 .events("DEPLOYMENT_STOP_ON_ALARM")
 *                 .build())
 *             .alarmConfiguration(DeploymentGroupAlarmConfigurationArgs.builder()
 *                 .alarms("my-alarm-name")
 *                 .enabled(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: aws:codedeploy:DeploymentConfig
 *     properties:
 *       deploymentConfigName: test-deployment-config
 *       computePlatform: Lambda
 *       trafficRoutingConfig:
 *         type: TimeBasedLinear
 *         timeBasedLinear:
 *           interval: 10
 *           percentage: 10
 *   fooDeploymentGroup:
 *     type: aws:codedeploy:DeploymentGroup
 *     name: foo
 *     properties:
 *       appName: ${fooApp.name}
 *       deploymentGroupName: bar
 *       serviceRoleArn: ${fooRole.arn}
 *       deploymentConfigName: ${foo.id}
 *       autoRollbackConfiguration:
 *         enabled: true
 *         events:
 *           - DEPLOYMENT_STOP_ON_ALARM
 *       alarmConfiguration:
 *         alarms:
 *           - my-alarm-name
 *         enabled: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CodeDeploy Deployment Configurations using the `deployment_config_name`. For example:
 * ```sh
 * $ pulumi import aws:codedeploy/deploymentConfig:DeploymentConfig example my-deployment-config
 * ```
 */
public class DeploymentConfig internal constructor(
    override val javaResource: com.pulumi.aws.codedeploy.DeploymentConfig,
) : KotlinCustomResource(javaResource, DeploymentConfigMapper) {
    /**
     * The ARN of the deployment config.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The compute platform can be `Server`, `Lambda`, or `ECS`. Default is `Server`.
     */
    public val computePlatform: Output<String>?
        get() = javaResource.computePlatform().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The AWS Assigned deployment config id
     */
    public val deploymentConfigId: Output<String>
        get() = javaResource.deploymentConfigId().applyValue({ args0 -> args0 })

    /**
     * The name of the deployment config.
     */
    public val deploymentConfigName: Output<String>
        get() = javaResource.deploymentConfigName().applyValue({ args0 -> args0 })

    /**
     * A minimum_healthy_hosts block. Required for `Server` compute platform. Minimum Healthy Hosts are documented below.
     */
    public val minimumHealthyHosts: Output<DeploymentConfigMinimumHealthyHosts>?
        get() = javaResource.minimumHealthyHosts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> deploymentConfigMinimumHealthyHostsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A traffic_routing_config block. Traffic Routing Config is documented below.
     */
    public val trafficRoutingConfig: Output<DeploymentConfigTrafficRoutingConfig>?
        get() = javaResource.trafficRoutingConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> deploymentConfigTrafficRoutingConfigToKotlin(args0) })
            }).orElse(null)
        })
}

public object DeploymentConfigMapper : ResourceMapper<DeploymentConfig> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.codedeploy.DeploymentConfig::class == javaResource::class

    override fun map(javaResource: Resource): DeploymentConfig = DeploymentConfig(
        javaResource as
            com.pulumi.aws.codedeploy.DeploymentConfig,
    )
}

/**
 * @see [DeploymentConfig].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DeploymentConfig].
 */
public suspend fun deploymentConfig(
    name: String,
    block: suspend DeploymentConfigResourceBuilder.() -> Unit,
): DeploymentConfig {
    val builder = DeploymentConfigResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DeploymentConfig].
 * @param name The _unique_ name of the resulting resource.
 */
public fun deploymentConfig(name: String): DeploymentConfig {
    val builder = DeploymentConfigResourceBuilder()
    builder.name(name)
    return builder.build()
}
