@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codedeploy.kotlin

import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupAlarmConfiguration
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupAutoRollbackConfiguration
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupBlueGreenDeploymentConfig
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupDeploymentStyle
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupEc2TagFilter
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupEc2TagSet
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupEcsService
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupLoadBalancerInfo
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupOnPremisesInstanceTagFilter
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupTriggerConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupAlarmConfiguration.Companion.toKotlin as deploymentGroupAlarmConfigurationToKotlin
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupAutoRollbackConfiguration.Companion.toKotlin as deploymentGroupAutoRollbackConfigurationToKotlin
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupBlueGreenDeploymentConfig.Companion.toKotlin as deploymentGroupBlueGreenDeploymentConfigToKotlin
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupDeploymentStyle.Companion.toKotlin as deploymentGroupDeploymentStyleToKotlin
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupEc2TagFilter.Companion.toKotlin as deploymentGroupEc2TagFilterToKotlin
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupEc2TagSet.Companion.toKotlin as deploymentGroupEc2TagSetToKotlin
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupEcsService.Companion.toKotlin as deploymentGroupEcsServiceToKotlin
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupLoadBalancerInfo.Companion.toKotlin as deploymentGroupLoadBalancerInfoToKotlin
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupOnPremisesInstanceTagFilter.Companion.toKotlin as deploymentGroupOnPremisesInstanceTagFilterToKotlin
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupTriggerConfiguration.Companion.toKotlin as deploymentGroupTriggerConfigurationToKotlin

/**
 * Builder for [DeploymentGroup].
 */
@PulumiTagMarker
public class DeploymentGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DeploymentGroupArgs = DeploymentGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DeploymentGroupArgsBuilder.() -> Unit) {
        val builder = DeploymentGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DeploymentGroup {
        val builtJavaResource = com.pulumi.aws.codedeploy.DeploymentGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DeploymentGroup(builtJavaResource)
    }
}

/**
 * Provides a CodeDeploy Deployment Group for a CodeDeploy Application
 * > **NOTE on blue/green deployments:** When using `green_fleet_provisioning_option` with the `COPY_AUTO_SCALING_GROUP` action, CodeDeploy will create a new ASG with a different name. This ASG is _not_ managed by this provider and will conflict with existing configuration and state. You may want to use a different approach to managing deployments that involve multiple ASG, such as `DISCOVER_EXISTING` with separate blue and green ASG.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const assumeRole = aws.iam.getPolicyDocument({
 *     statements: [{
 *         effect: "Allow",
 *         principals: [{
 *             type: "Service",
 *             identifiers: ["codedeploy&#46;amazonaws&#46;com"],
 *         }],
 *         actions: ["sts:AssumeRole"],
 *     }],
 * });
 * const example = new aws.iam.Role("example", {
 *     name: "example-role",
 *     assumeRolePolicy: assumeRole.then(assumeRole => assumeRole.json),
 * });
 * const aWSCodeDeployRole = new aws.iam.RolePolicyAttachment("AWSCodeDeployRole", {
 *     policyArn: "arn:aws:iam::aws:policy/service-role/AWSCodeDeployRole",
 *     role: example.name,
 * });
 * const exampleApplication = new aws.codedeploy.Application("example", {name: "example-app"});
 * const exampleTopic = new aws.sns.Topic("example", {name: "example-topic"});
 * const exampleDeploymentGroup = new aws.codedeploy.DeploymentGroup("example", {
 *     appName: exampleApplication.name,
 *     deploymentGroupName: "example-group",
 *     serviceRoleArn: example.arn,
 *     ec2TagSets: [{
 *         ec2TagFilters: [
 *             {
 *                 key: "filterkey1",
 *                 type: "KEY_AND_VALUE",
 *                 value: "filtervalue",
 *             },
 *             {
 *                 key: "filterkey2",
 *                 type: "KEY_AND_VALUE",
 *                 value: "filtervalue",
 *             },
 *         ],
 *     }],
 *     triggerConfigurations: [{
 *         triggerEvents: ["DeploymentFailure"],
 *         triggerName: "example-trigger",
 *         triggerTargetArn: exampleTopic.arn,
 *     }],
 *     autoRollbackConfiguration: {
 *         enabled: true,
 *         events: ["DEPLOYMENT_FAILURE"],
 *     },
 *     alarmConfiguration: {
 *         alarms: ["my-alarm-name"],
 *         enabled: true,
 *     },
 *     outdatedInstancesStrategy: "UPDATE",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * assume_role = aws.iam.get_policy_document(statements=[{
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": ["codedeploy&#46;amazonaws&#46;com"],
 *     }],
 *     "actions": ["sts:AssumeRole"],
 * }])
 * example = aws.iam.Role("example",
 *     name="example-role",
 *     assume_role_policy=assume_role.json)
 * a_ws_code_deploy_role = aws.iam.RolePolicyAttachment("AWSCodeDeployRole",
 *     policy_arn="arn:aws:iam::aws:policy/service-role/AWSCodeDeployRole",
 *     role=example.name)
 * example_application = aws.codedeploy.Application("example", name="example-app")
 * example_topic = aws.sns.Topic("example", name="example-topic")
 * example_deployment_group = aws.codedeploy.DeploymentGroup("example",
 *     app_name=example_application.name,
 *     deployment_group_name="example-group",
 *     service_role_arn=example.arn,
 *     ec2_tag_sets=[{
 *         "ec2_tag_filters": [
 *             {
 *                 "key": "filterkey1",
 *                 "type": "KEY_AND_VALUE",
 *                 "value": "filtervalue",
 *             },
 *             {
 *                 "key": "filterkey2",
 *                 "type": "KEY_AND_VALUE",
 *                 "value": "filtervalue",
 *             },
 *         ],
 *     }],
 *     trigger_configurations=[{
 *         "trigger_events": ["DeploymentFailure"],
 *         "trigger_name": "example-trigger",
 *         "trigger_target_arn": example_topic.arn,
 *     }],
 *     auto_rollback_configuration={
 *         "enabled": True,
 *         "events": ["DEPLOYMENT_FAILURE"],
 *     },
 *     alarm_configuration={
 *         "alarms": ["my-alarm-name"],
 *         "enabled": True,
 *     },
 *     outdated_instances_strategy="UPDATE")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var assumeRole = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "codedeploy.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRole",
 *                 },
 *             },
 *         },
 *     });
 *     var example = new Aws.Iam.Role("example", new()
 *     {
 *         Name = "example-role",
 *         AssumeRolePolicy = assumeRole.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var aWSCodeDeployRole = new Aws.Iam.RolePolicyAttachment("AWSCodeDeployRole", new()
 *     {
 *         PolicyArn = "arn:aws:iam::aws:policy/service-role/AWSCodeDeployRole",
 *         Role = example.Name,
 *     });
 *     var exampleApplication = new Aws.CodeDeploy.Application("example", new()
 *     {
 *         Name = "example-app",
 *     });
 *     var exampleTopic = new Aws.Sns.Topic("example", new()
 *     {
 *         Name = "example-topic",
 *     });
 *     var exampleDeploymentGroup = new Aws.CodeDeploy.DeploymentGroup("example", new()
 *     {
 *         AppName = exampleApplication.Name,
 *         DeploymentGroupName = "example-group",
 *         ServiceRoleArn = example.Arn,
 *         Ec2TagSets = new[]
 *         {
 *             new Aws.CodeDeploy.Inputs.DeploymentGroupEc2TagSetArgs
 *             {
 *                 Ec2TagFilters = new[]
 *                 {
 *                     new Aws.CodeDeploy.Inputs.DeploymentGroupEc2TagSetEc2TagFilterArgs
 *                     {
 *                         Key = "filterkey1",
 *                         Type = "KEY_AND_VALUE",
 *                         Value = "filtervalue",
 *                     },
 *                     new Aws.CodeDeploy.Inputs.DeploymentGroupEc2TagSetEc2TagFilterArgs
 *                     {
 *                         Key = "filterkey2",
 *                         Type = "KEY_AND_VALUE",
 *                         Value = "filtervalue",
 *                     },
 *                 },
 *             },
 *         },
 *         TriggerConfigurations = new[]
 *         {
 *             new Aws.CodeDeploy.Inputs.DeploymentGroupTriggerConfigurationArgs
 *             {
 *                 TriggerEvents = new[]
 *                 {
 *                     "DeploymentFailure",
 *                 },
 *                 TriggerName = "example-trigger",
 *                 TriggerTargetArn = exampleTopic.Arn,
 *             },
 *         },
 *         AutoRollbackConfiguration = new Aws.CodeDeploy.Inputs.DeploymentGroupAutoRollbackConfigurationArgs
 *         {
 *             Enabled = true,
 *             Events = new[]
 *             {
 *                 "DEPLOYMENT_FAILURE",
 *             },
 *         },
 *         AlarmConfiguration = new Aws.CodeDeploy.Inputs.DeploymentGroupAlarmConfigurationArgs
 *         {
 *             Alarms = new[]
 *             {
 *                 "my-alarm-name",
 *             },
 *             Enabled = true,
 *         },
 *         OutdatedInstancesStrategy = "UPDATE",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codedeploy"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		assumeRole, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "Service",
 * 							Identifiers: []string{
 * 								"codedeploy.amazonaws.com",
 * 							},
 * 						},
 * 					},
 * 					Actions: []string{
 * 						"sts:AssumeRole",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := iam.NewRole(ctx, "example", &iam.RoleArgs{
 * 			Name:             pulumi.String("example-role"),
 * 			AssumeRolePolicy: pulumi.String(assumeRole.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iam.NewRolePolicyAttachment(ctx, "AWSCodeDeployRole", &iam.RolePolicyAttachmentArgs{
 * 			PolicyArn: pulumi.String("arn:aws:iam::aws:policy/service-role/AWSCodeDeployRole"),
 * 			Role:      example.Name,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleApplication, err := codedeploy.NewApplication(ctx, "example", &codedeploy.ApplicationArgs{
 * 			Name: pulumi.String("example-app"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleTopic, err := sns.NewTopic(ctx, "example", &sns.TopicArgs{
 * 			Name: pulumi.String("example-topic"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = codedeploy.NewDeploymentGroup(ctx, "example", &codedeploy.DeploymentGroupArgs{
 * 			AppName:             exampleApplication.Name,
 * 			DeploymentGroupName: pulumi.String("example-group"),
 * 			ServiceRoleArn:      example.Arn,
 * 			Ec2TagSets: codedeploy.DeploymentGroupEc2TagSetArray{
 * 				&codedeploy.DeploymentGroupEc2TagSetArgs{
 * 					Ec2TagFilters: codedeploy.DeploymentGroupEc2TagSetEc2TagFilterArray{
 * 						&codedeploy.DeploymentGroupEc2TagSetEc2TagFilterArgs{
 * 							Key:   pulumi.String("filterkey1"),
 * 							Type:  pulumi.String("KEY_AND_VALUE"),
 * 							Value: pulumi.String("filtervalue"),
 * 						},
 * 						&codedeploy.DeploymentGroupEc2TagSetEc2TagFilterArgs{
 * 							Key:   pulumi.String("filterkey2"),
 * 							Type:  pulumi.String("KEY_AND_VALUE"),
 * 							Value: pulumi.String("filtervalue"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			TriggerConfigurations: codedeploy.DeploymentGroupTriggerConfigurationArray{
 * 				&codedeploy.DeploymentGroupTriggerConfigurationArgs{
 * 					TriggerEvents: pulumi.StringArray{
 * 						pulumi.String("DeploymentFailure"),
 * 					},
 * 					TriggerName:      pulumi.String("example-trigger"),
 * 					TriggerTargetArn: exampleTopic.Arn,
 * 				},
 * 			},
 * 			AutoRollbackConfiguration: &codedeploy.DeploymentGroupAutoRollbackConfigurationArgs{
 * 				Enabled: pulumi.Bool(true),
 * 				Events: pulumi.StringArray{
 * 					pulumi.String("DEPLOYMENT_FAILURE"),
 * 				},
 * 			},
 * 			AlarmConfiguration: &codedeploy.DeploymentGroupAlarmConfigurationArgs{
 * 				Alarms: pulumi.StringArray{
 * 					pulumi.String("my-alarm-name"),
 * 				},
 * 				Enabled: pulumi.Bool(true),
 * 			},
 * 			OutdatedInstancesStrategy: pulumi.String("UPDATE"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.codedeploy.Application;
 * import com.pulumi.aws.codedeploy.ApplicationArgs;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.sns.TopicArgs;
 * import com.pulumi.aws.codedeploy.DeploymentGroup;
 * import com.pulumi.aws.codedeploy.DeploymentGroupArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupEc2TagSetArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupTriggerConfigurationArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupAutoRollbackConfigurationArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupAlarmConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("codedeploy.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var example = new Role("example", RoleArgs.builder()
 *             .name("example-role")
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var aWSCodeDeployRole = new RolePolicyAttachment("aWSCodeDeployRole", RolePolicyAttachmentArgs.builder()
 *             .policyArn("arn:aws:iam::aws:policy/service-role/AWSCodeDeployRole")
 *             .role(example.name())
 *             .build());
 *         var exampleApplication = new Application("exampleApplication", ApplicationArgs.builder()
 *             .name("example-app")
 *             .build());
 *         var exampleTopic = new Topic("exampleTopic", TopicArgs.builder()
 *             .name("example-topic")
 *             .build());
 *         var exampleDeploymentGroup = new DeploymentGroup("exampleDeploymentGroup", DeploymentGroupArgs.builder()
 *             .appName(exampleApplication.name())
 *             .deploymentGroupName("example-group")
 *             .serviceRoleArn(example.arn())
 *             .ec2TagSets(DeploymentGroupEc2TagSetArgs.builder()
 *                 .ec2TagFilters(
 *                     DeploymentGroupEc2TagSetEc2TagFilterArgs.builder()
 *                         .key("filterkey1")
 *                         .type("KEY_AND_VALUE")
 *                         .value("filtervalue")
 *                         .build(),
 *                     DeploymentGroupEc2TagSetEc2TagFilterArgs.builder()
 *                         .key("filterkey2")
 *                         .type("KEY_AND_VALUE")
 *                         .value("filtervalue")
 *                         .build())
 *                 .build())
 *             .triggerConfigurations(DeploymentGroupTriggerConfigurationArgs.builder()
 *                 .triggerEvents("DeploymentFailure")
 *                 .triggerName("example-trigger")
 *                 .triggerTargetArn(exampleTopic.arn())
 *                 .build())
 *             .autoRollbackConfiguration(DeploymentGroupAutoRollbackConfigurationArgs.builder()
 *                 .enabled(true)
 *                 .events("DEPLOYMENT_FAILURE")
 *                 .build())
 *             .alarmConfiguration(DeploymentGroupAlarmConfigurationArgs.builder()
 *                 .alarms("my-alarm-name")
 *                 .enabled(true)
 *                 .build())
 *             .outdatedInstancesStrategy("UPDATE")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:iam:Role
 *     properties:
 *       name: example-role
 *       assumeRolePolicy: ${assumeRole.json}
 *   aWSCodeDeployRole:
 *     type: aws:iam:RolePolicyAttachment
 *     name: AWSCodeDeployRole
 *     properties:
 *       policyArn: arn:aws:iam::aws:policy/service-role/AWSCodeDeployRole
 *       role: ${example.name}
 *   exampleApplication:
 *     type: aws:codedeploy:Application
 *     name: example
 *     properties:
 *       name: example-app
 *   exampleTopic:
 *     type: aws:sns:Topic
 *     name: example
 *     properties:
 *       name: example-topic
 *   exampleDeploymentGroup:
 *     type: aws:codedeploy:DeploymentGroup
 *     name: example
 *     properties:
 *       appName: ${exampleApplication.name}
 *       deploymentGroupName: example-group
 *       serviceRoleArn: ${example.arn}
 *       ec2TagSets:
 *         - ec2TagFilters:
 *             - key: filterkey1
 *               type: KEY_AND_VALUE
 *               value: filtervalue
 *             - key: filterkey2
 *               type: KEY_AND_VALUE
 *               value: filtervalue
 *       triggerConfigurations:
 *         - triggerEvents:
 *             - DeploymentFailure
 *           triggerName: example-trigger
 *           triggerTargetArn: ${exampleTopic.arn}
 *       autoRollbackConfiguration:
 *         enabled: true
 *         events:
 *           - DEPLOYMENT_FAILURE
 *       alarmConfiguration:
 *         alarms:
 *           - my-alarm-name
 *         enabled: true
 *       outdatedInstancesStrategy: UPDATE
 * variables:
 *   assumeRole:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - codedeploy.amazonaws.com
 *             actions:
 *               - sts:AssumeRole
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Blue Green Deployments with ECS
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.codedeploy.Application("example", {
 *     computePlatform: "ECS",
 *     name: "example",
 * });
 * const exampleDeploymentGroup = new aws.codedeploy.DeploymentGroup("example", {
 *     appName: example.name,
 *     deploymentConfigName: "CodeDeployDefault.ECSAllAtOnce",
 *     deploymentGroupName: "example",
 *     serviceRoleArn: exampleAwsIamRole.arn,
 *     autoRollbackConfiguration: {
 *         enabled: true,
 *         events: ["DEPLOYMENT_FAILURE"],
 *     },
 *     blueGreenDeploymentConfig: {
 *         deploymentReadyOption: {
 *             actionOnTimeout: "CONTINUE_DEPLOYMENT",
 *         },
 *         terminateBlueInstancesOnDeploymentSuccess: {
 *             action: "TERMINATE",
 *             terminationWaitTimeInMinutes: 5,
 *         },
 *     },
 *     deploymentStyle: {
 *         deploymentOption: "WITH_TRAFFIC_CONTROL",
 *         deploymentType: "BLUE_GREEN",
 *     },
 *     ecsService: {
 *         clusterName: exampleAwsEcsCluster.name,
 *         serviceName: exampleAwsEcsService.name,
 *     },
 *     loadBalancerInfo: {
 *         targetGroupPairInfo: {
 *             prodTrafficRoute: {
 *                 listenerArns: [exampleAwsLbListener&#46;arn],
 *             },
 *             targetGroups: [
 *                 {
 *                     name: blue.name,
 *                 },
 *                 {
 *                     name: green.name,
 *                 },
 *             ],
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.codedeploy.Application("example",
 *     compute_platform="ECS",
 *     name="example")
 * example_deployment_group = aws.codedeploy.DeploymentGroup("example",
 *     app_name=example.name,
 *     deployment_config_name="CodeDeployDefault.ECSAllAtOnce",
 *     deployment_group_name="example",
 *     service_role_arn=example_aws_iam_role["arn"],
 *     auto_rollback_configuration={
 *         "enabled": True,
 *         "events": ["DEPLOYMENT_FAILURE"],
 *     },
 *     blue_green_deployment_config={
 *         "deployment_ready_option": {
 *             "action_on_timeout": "CONTINUE_DEPLOYMENT",
 *         },
 *         "terminate_blue_instances_on_deployment_success": {
 *             "action": "TERMINATE",
 *             "termination_wait_time_in_minutes": 5,
 *         },
 *     },
 *     deployment_style={
 *         "deployment_option": "WITH_TRAFFIC_CONTROL",
 *         "deployment_type": "BLUE_GREEN",
 *     },
 *     ecs_service={
 *         "cluster_name": example_aws_ecs_cluster["name"],
 *         "service_name": example_aws_ecs_service["name"],
 *     },
 *     load_balancer_info={
 *         "target_group_pair_info": {
 *             "prod_traffic_route": {
 *                 "listener_arns": [example_aws_lb_listener["arn"]],
 *             },
 *             "target_groups": [
 *                 {
 *                     "name": blue["name"],
 *                 },
 *                 {
 *                     "name": green["name"],
 *                 },
 *             ],
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CodeDeploy.Application("example", new()
 *     {
 *         ComputePlatform = "ECS",
 *         Name = "example",
 *     });
 *     var exampleDeploymentGroup = new Aws.CodeDeploy.DeploymentGroup("example", new()
 *     {
 *         AppName = example.Name,
 *         DeploymentConfigName = "CodeDeployDefault.ECSAllAtOnce",
 *         DeploymentGroupName = "example",
 *         ServiceRoleArn = exampleAwsIamRole.Arn,
 *         AutoRollbackConfiguration = new Aws.CodeDeploy.Inputs.DeploymentGroupAutoRollbackConfigurationArgs
 *         {
 *             Enabled = true,
 *             Events = new[]
 *             {
 *                 "DEPLOYMENT_FAILURE",
 *             },
 *         },
 *         BlueGreenDeploymentConfig = new Aws.CodeDeploy.Inputs.DeploymentGroupBlueGreenDeploymentConfigArgs
 *         {
 *             DeploymentReadyOption = new Aws.CodeDeploy.Inputs.DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgs
 *             {
 *                 ActionOnTimeout = "CONTINUE_DEPLOYMENT",
 *             },
 *             TerminateBlueInstancesOnDeploymentSuccess = new Aws.CodeDeploy.Inputs.DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgs
 *             {
 *                 Action = "TERMINATE",
 *                 TerminationWaitTimeInMinutes = 5,
 *             },
 *         },
 *         DeploymentStyle = new Aws.CodeDeploy.Inputs.DeploymentGroupDeploymentStyleArgs
 *         {
 *             DeploymentOption = "WITH_TRAFFIC_CONTROL",
 *             DeploymentType = "BLUE_GREEN",
 *         },
 *         EcsService = new Aws.CodeDeploy.Inputs.DeploymentGroupEcsServiceArgs
 *         {
 *             ClusterName = exampleAwsEcsCluster.Name,
 *             ServiceName = exampleAwsEcsService.Name,
 *         },
 *         LoadBalancerInfo = new Aws.CodeDeploy.Inputs.DeploymentGroupLoadBalancerInfoArgs
 *         {
 *             TargetGroupPairInfo = new Aws.CodeDeploy.Inputs.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoArgs
 *             {
 *                 ProdTrafficRoute = new Aws.CodeDeploy.Inputs.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoProdTrafficRouteArgs
 *                 {
 *                     ListenerArns = new[]
 *                     {
 *                         exampleAwsLbListener.Arn,
 *                     },
 *                 },
 *                 TargetGroups = new[]
 *                 {
 *                     new Aws.CodeDeploy.Inputs.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArgs
 *                     {
 *                         Name = blue.Name,
 *                     },
 *                     new Aws.CodeDeploy.Inputs.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArgs
 *                     {
 *                         Name = green.Name,
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codedeploy"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := codedeploy.NewApplication(ctx, "example", &codedeploy.ApplicationArgs{
 * 			ComputePlatform: pulumi.String("ECS"),
 * 			Name:            pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = codedeploy.NewDeploymentGroup(ctx, "example", &codedeploy.DeploymentGroupArgs{
 * 			AppName:              example.Name,
 * 			DeploymentConfigName: pulumi.String("CodeDeployDefault.ECSAllAtOnce"),
 * 			DeploymentGroupName:  pulumi.String("example"),
 * 			ServiceRoleArn:       pulumi.Any(exampleAwsIamRole.Arn),
 * 			AutoRollbackConfiguration: &codedeploy.DeploymentGroupAutoRollbackConfigurationArgs{
 * 				Enabled: pulumi.Bool(true),
 * 				Events: pulumi.StringArray{
 * 					pulumi.String("DEPLOYMENT_FAILURE"),
 * 				},
 * 			},
 * 			BlueGreenDeploymentConfig: &codedeploy.DeploymentGroupBlueGreenDeploymentConfigArgs{
 * 				DeploymentReadyOption: &codedeploy.DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgs{
 * 					ActionOnTimeout: pulumi.String("CONTINUE_DEPLOYMENT"),
 * 				},
 * 				TerminateBlueInstancesOnDeploymentSuccess: &codedeploy.DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgs{
 * 					Action:                       pulumi.String("TERMINATE"),
 * 					TerminationWaitTimeInMinutes: pulumi.Int(5),
 * 				},
 * 			},
 * 			DeploymentStyle: &codedeploy.DeploymentGroupDeploymentStyleArgs{
 * 				DeploymentOption: pulumi.String("WITH_TRAFFIC_CONTROL"),
 * 				DeploymentType:   pulumi.String("BLUE_GREEN"),
 * 			},
 * 			EcsService: &codedeploy.DeploymentGroupEcsServiceArgs{
 * 				ClusterName: pulumi.Any(exampleAwsEcsCluster.Name),
 * 				ServiceName: pulumi.Any(exampleAwsEcsService.Name),
 * 			},
 * 			LoadBalancerInfo: &codedeploy.DeploymentGroupLoadBalancerInfoArgs{
 * 				TargetGroupPairInfo: &codedeploy.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoArgs{
 * 					ProdTrafficRoute: &codedeploy.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoProdTrafficRouteArgs{
 * 						ListenerArns: pulumi.StringArray{
 * 							exampleAwsLbListener.Arn,
 * 						},
 * 					},
 * 					TargetGroups: codedeploy.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArray{
 * 						&codedeploy.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArgs{
 * 							Name: pulumi.Any(blue.Name),
 * 						},
 * 						&codedeploy.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArgs{
 * 							Name: pulumi.Any(green.Name),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codedeploy.Application;
 * import com.pulumi.aws.codedeploy.ApplicationArgs;
 * import com.pulumi.aws.codedeploy.DeploymentGroup;
 * import com.pulumi.aws.codedeploy.DeploymentGroupArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupAutoRollbackConfigurationArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupBlueGreenDeploymentConfigArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupDeploymentStyleArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupEcsServiceArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupLoadBalancerInfoArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoProdTrafficRouteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Application("example", ApplicationArgs.builder()
 *             .computePlatform("ECS")
 *             .name("example")
 *             .build());
 *         var exampleDeploymentGroup = new DeploymentGroup("exampleDeploymentGroup", DeploymentGroupArgs.builder()
 *             .appName(example.name())
 *             .deploymentConfigName("CodeDeployDefault.ECSAllAtOnce")
 *             .deploymentGroupName("example")
 *             .serviceRoleArn(exampleAwsIamRole.arn())
 *             .autoRollbackConfiguration(DeploymentGroupAutoRollbackConfigurationArgs.builder()
 *                 .enabled(true)
 *                 .events("DEPLOYMENT_FAILURE")
 *                 .build())
 *             .blueGreenDeploymentConfig(DeploymentGroupBlueGreenDeploymentConfigArgs.builder()
 *                 .deploymentReadyOption(DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgs.builder()
 *                     .actionOnTimeout("CONTINUE_DEPLOYMENT")
 *                     .build())
 *                 .terminateBlueInstancesOnDeploymentSuccess(DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgs.builder()
 *                     .action("TERMINATE")
 *                     .terminationWaitTimeInMinutes(5)
 *                     .build())
 *                 .build())
 *             .deploymentStyle(DeploymentGroupDeploymentStyleArgs.builder()
 *                 .deploymentOption("WITH_TRAFFIC_CONTROL")
 *                 .deploymentType("BLUE_GREEN")
 *                 .build())
 *             .ecsService(DeploymentGroupEcsServiceArgs.builder()
 *                 .clusterName(exampleAwsEcsCluster.name())
 *                 .serviceName(exampleAwsEcsService.name())
 *                 .build())
 *             .loadBalancerInfo(DeploymentGroupLoadBalancerInfoArgs.builder()
 *                 .targetGroupPairInfo(DeploymentGroupLoadBalancerInfoTargetGroupPairInfoArgs.builder()
 *                     .prodTrafficRoute(DeploymentGroupLoadBalancerInfoTargetGroupPairInfoProdTrafficRouteArgs.builder()
 *                         .listenerArns(exampleAwsLbListener.arn())
 *                         .build())
 *                     .targetGroups(
 *                         DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArgs.builder()
 *                             .name(blue.name())
 *                             .build(),
 *                         DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArgs.builder()
 *                             .name(green.name())
 *                             .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:codedeploy:Application
 *     properties:
 *       computePlatform: ECS
 *       name: example
 *   exampleDeploymentGroup:
 *     type: aws:codedeploy:DeploymentGroup
 *     name: example
 *     properties:
 *       appName: ${example.name}
 *       deploymentConfigName: CodeDeployDefault.ECSAllAtOnce
 *       deploymentGroupName: example
 *       serviceRoleArn: ${exampleAwsIamRole.arn}
 *       autoRollbackConfiguration:
 *         enabled: true
 *         events:
 *           - DEPLOYMENT_FAILURE
 *       blueGreenDeploymentConfig:
 *         deploymentReadyOption:
 *           actionOnTimeout: CONTINUE_DEPLOYMENT
 *         terminateBlueInstancesOnDeploymentSuccess:
 *           action: TERMINATE
 *           terminationWaitTimeInMinutes: 5
 *       deploymentStyle:
 *         deploymentOption: WITH_TRAFFIC_CONTROL
 *         deploymentType: BLUE_GREEN
 *       ecsService:
 *         clusterName: ${exampleAwsEcsCluster.name}
 *         serviceName: ${exampleAwsEcsService.name}
 *       loadBalancerInfo:
 *         targetGroupPairInfo:
 *           prodTrafficRoute:
 *             listenerArns:
 *               - ${exampleAwsLbListener.arn}
 *           targetGroups:
 *             - name: ${blue.name}
 *             - name: ${green.name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Blue Green Deployments with Servers and Classic ELB
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.codedeploy.Application("example", {name: "example-app"});
 * const exampleDeploymentGroup = new aws.codedeploy.DeploymentGroup("example", {
 *     appName: example.name,
 *     deploymentGroupName: "example-group",
 *     serviceRoleArn: exampleAwsIamRole.arn,
 *     deploymentStyle: {
 *         deploymentOption: "WITH_TRAFFIC_CONTROL",
 *         deploymentType: "BLUE_GREEN",
 *     },
 *     loadBalancerInfo: {
 *         elbInfos: [{
 *             name: exampleAwsElb.name,
 *         }],
 *     },
 *     blueGreenDeploymentConfig: {
 *         deploymentReadyOption: {
 *             actionOnTimeout: "STOP_DEPLOYMENT",
 *             waitTimeInMinutes: 60,
 *         },
 *         greenFleetProvisioningOption: {
 *             action: "DISCOVER_EXISTING",
 *         },
 *         terminateBlueInstancesOnDeploymentSuccess: {
 *             action: "KEEP_ALIVE",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.codedeploy.Application("example", name="example-app")
 * example_deployment_group = aws.codedeploy.DeploymentGroup("example",
 *     app_name=example.name,
 *     deployment_group_name="example-group",
 *     service_role_arn=example_aws_iam_role["arn"],
 *     deployment_style={
 *         "deployment_option": "WITH_TRAFFIC_CONTROL",
 *         "deployment_type": "BLUE_GREEN",
 *     },
 *     load_balancer_info={
 *         "elb_infos": [{
 *             "name": example_aws_elb["name"],
 *         }],
 *     },
 *     blue_green_deployment_config={
 *         "deployment_ready_option": {
 *             "action_on_timeout": "STOP_DEPLOYMENT",
 *             "wait_time_in_minutes": 60,
 *         },
 *         "green_fleet_provisioning_option": {
 *             "action": "DISCOVER_EXISTING",
 *         },
 *         "terminate_blue_instances_on_deployment_success": {
 *             "action": "KEEP_ALIVE",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CodeDeploy.Application("example", new()
 *     {
 *         Name = "example-app",
 *     });
 *     var exampleDeploymentGroup = new Aws.CodeDeploy.DeploymentGroup("example", new()
 *     {
 *         AppName = example.Name,
 *         DeploymentGroupName = "example-group",
 *         ServiceRoleArn = exampleAwsIamRole.Arn,
 *         DeploymentStyle = new Aws.CodeDeploy.Inputs.DeploymentGroupDeploymentStyleArgs
 *         {
 *             DeploymentOption = "WITH_TRAFFIC_CONTROL",
 *             DeploymentType = "BLUE_GREEN",
 *         },
 *         LoadBalancerInfo = new Aws.CodeDeploy.Inputs.DeploymentGroupLoadBalancerInfoArgs
 *         {
 *             ElbInfos = new[]
 *             {
 *                 new Aws.CodeDeploy.Inputs.DeploymentGroupLoadBalancerInfoElbInfoArgs
 *                 {
 *                     Name = exampleAwsElb.Name,
 *                 },
 *             },
 *         },
 *         BlueGreenDeploymentConfig = new Aws.CodeDeploy.Inputs.DeploymentGroupBlueGreenDeploymentConfigArgs
 *         {
 *             DeploymentReadyOption = new Aws.CodeDeploy.Inputs.DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgs
 *             {
 *                 ActionOnTimeout = "STOP_DEPLOYMENT",
 *                 WaitTimeInMinutes = 60,
 *             },
 *             GreenFleetProvisioningOption = new Aws.CodeDeploy.Inputs.DeploymentGroupBlueGreenDeploymentConfigGreenFleetProvisioningOptionArgs
 *             {
 *                 Action = "DISCOVER_EXISTING",
 *             },
 *             TerminateBlueInstancesOnDeploymentSuccess = new Aws.CodeDeploy.Inputs.DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgs
 *             {
 *                 Action = "KEEP_ALIVE",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codedeploy"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := codedeploy.NewApplication(ctx, "example", &codedeploy.ApplicationArgs{
 * 			Name: pulumi.String("example-app"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = codedeploy.NewDeploymentGroup(ctx, "example", &codedeploy.DeploymentGroupArgs{
 * 			AppName:             example.Name,
 * 			DeploymentGroupName: pulumi.String("example-group"),
 * 			ServiceRoleArn:      pulumi.Any(exampleAwsIamRole.Arn),
 * 			DeploymentStyle: &codedeploy.DeploymentGroupDeploymentStyleArgs{
 * 				DeploymentOption: pulumi.String("WITH_TRAFFIC_CONTROL"),
 * 				DeploymentType:   pulumi.String("BLUE_GREEN"),
 * 			},
 * 			LoadBalancerInfo: &codedeploy.DeploymentGroupLoadBalancerInfoArgs{
 * 				ElbInfos: codedeploy.DeploymentGroupLoadBalancerInfoElbInfoArray{
 * 					&codedeploy.DeploymentGroupLoadBalancerInfoElbInfoArgs{
 * 						Name: pulumi.Any(exampleAwsElb.Name),
 * 					},
 * 				},
 * 			},
 * 			BlueGreenDeploymentConfig: &codedeploy.DeploymentGroupBlueGreenDeploymentConfigArgs{
 * 				DeploymentReadyOption: &codedeploy.DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgs{
 * 					ActionOnTimeout:   pulumi.String("STOP_DEPLOYMENT"),
 * 					WaitTimeInMinutes: pulumi.Int(60),
 * 				},
 * 				GreenFleetProvisioningOption: &codedeploy.DeploymentGroupBlueGreenDeploymentConfigGreenFleetProvisioningOptionArgs{
 * 					Action: pulumi.String("DISCOVER_EXISTING"),
 * 				},
 * 				TerminateBlueInstancesOnDeploymentSuccess: &codedeploy.DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgs{
 * 					Action: pulumi.String("KEEP_ALIVE"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codedeploy.Application;
 * import com.pulumi.aws.codedeploy.ApplicationArgs;
 * import com.pulumi.aws.codedeploy.DeploymentGroup;
 * import com.pulumi.aws.codedeploy.DeploymentGroupArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupDeploymentStyleArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupLoadBalancerInfoArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupBlueGreenDeploymentConfigArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupBlueGreenDeploymentConfigGreenFleetProvisioningOptionArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Application("example", ApplicationArgs.builder()
 *             .name("example-app")
 *             .build());
 *         var exampleDeploymentGroup = new DeploymentGroup("exampleDeploymentGroup", DeploymentGroupArgs.builder()
 *             .appName(example.name())
 *             .deploymentGroupName("example-group")
 *             .serviceRoleArn(exampleAwsIamRole.arn())
 *             .deploymentStyle(DeploymentGroupDeploymentStyleArgs.builder()
 *                 .deploymentOption("WITH_TRAFFIC_CONTROL")
 *                 .deploymentType("BLUE_GREEN")
 *                 .build())
 *             .loadBalancerInfo(DeploymentGroupLoadBalancerInfoArgs.builder()
 *                 .elbInfos(DeploymentGroupLoadBalancerInfoElbInfoArgs.builder()
 *                     .name(exampleAwsElb.name())
 *                     .build())
 *                 .build())
 *             .blueGreenDeploymentConfig(DeploymentGroupBlueGreenDeploymentConfigArgs.builder()
 *                 .deploymentReadyOption(DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgs.builder()
 *                     .actionOnTimeout("STOP_DEPLOYMENT")
 *                     .waitTimeInMinutes(60)
 *                     .build())
 *                 .greenFleetProvisioningOption(DeploymentGroupBlueGreenDeploymentConfigGreenFleetProvisioningOptionArgs.builder()
 *                     .action("DISCOVER_EXISTING")
 *                     .build())
 *                 .terminateBlueInstancesOnDeploymentSuccess(DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgs.builder()
 *                     .action("KEEP_ALIVE")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:codedeploy:Application
 *     properties:
 *       name: example-app
 *   exampleDeploymentGroup:
 *     type: aws:codedeploy:DeploymentGroup
 *     name: example
 *     properties:
 *       appName: ${example.name}
 *       deploymentGroupName: example-group
 *       serviceRoleArn: ${exampleAwsIamRole.arn}
 *       deploymentStyle:
 *         deploymentOption: WITH_TRAFFIC_CONTROL
 *         deploymentType: BLUE_GREEN
 *       loadBalancerInfo:
 *         elbInfos:
 *           - name: ${exampleAwsElb.name}
 *       blueGreenDeploymentConfig:
 *         deploymentReadyOption:
 *           actionOnTimeout: STOP_DEPLOYMENT
 *           waitTimeInMinutes: 60
 *         greenFleetProvisioningOption:
 *           action: DISCOVER_EXISTING
 *         terminateBlueInstancesOnDeploymentSuccess:
 *           action: KEEP_ALIVE
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CodeDeploy Deployment Groups using `app_name`, a colon, and `deployment_group_name`. For example:
 * ```sh
 * $ pulumi import aws:codedeploy/deploymentGroup:DeploymentGroup example my-application:my-deployment-group
 * ```
 */
public class DeploymentGroup internal constructor(
    override val javaResource: com.pulumi.aws.codedeploy.DeploymentGroup,
) : KotlinCustomResource(javaResource, DeploymentGroupMapper) {
    /**
     * Configuration block of alarms associated with the deployment group (documented below).
     */
    public val alarmConfiguration: Output<DeploymentGroupAlarmConfiguration>?
        get() = javaResource.alarmConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> deploymentGroupAlarmConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The name of the application.
     */
    public val appName: Output<String>
        get() = javaResource.appName().applyValue({ args0 -> args0 })

    /**
     * The ARN of the CodeDeploy deployment group.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Configuration block of the automatic rollback configuration associated with the deployment group (documented below).
     */
    public val autoRollbackConfiguration: Output<DeploymentGroupAutoRollbackConfiguration>?
        get() = javaResource.autoRollbackConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    deploymentGroupAutoRollbackConfigurationToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Autoscaling groups associated with the deployment group.
     */
    public val autoscalingGroups: Output<List<String>>?
        get() = javaResource.autoscalingGroups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Configuration block of the blue/green deployment options for a deployment group (documented below).
     */
    public val blueGreenDeploymentConfig: Output<DeploymentGroupBlueGreenDeploymentConfig>
        get() = javaResource.blueGreenDeploymentConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                deploymentGroupBlueGreenDeploymentConfigToKotlin(args0)
            })
        })

    /**
     * The destination platform type for the deployment.
     */
    public val computePlatform: Output<String>
        get() = javaResource.computePlatform().applyValue({ args0 -> args0 })

    /**
     * The name of the group's deployment config. The default is "CodeDeployDefault.OneAtATime".
     */
    public val deploymentConfigName: Output<String>?
        get() = javaResource.deploymentConfigName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the CodeDeploy deployment group.
     */
    public val deploymentGroupId: Output<String>
        get() = javaResource.deploymentGroupId().applyValue({ args0 -> args0 })

    /**
     * The name of the deployment group.
     */
    public val deploymentGroupName: Output<String>
        get() = javaResource.deploymentGroupName().applyValue({ args0 -> args0 })

    /**
     * Configuration block of the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer (documented below).
     */
    public val deploymentStyle: Output<DeploymentGroupDeploymentStyle>?
        get() = javaResource.deploymentStyle().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> deploymentGroupDeploymentStyleToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Tag filters associated with the deployment group. See the AWS docs for details.
     */
    public val ec2TagFilters: Output<List<DeploymentGroupEc2TagFilter>>?
        get() = javaResource.ec2TagFilters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        deploymentGroupEc2TagFilterToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Configuration block(s) of Tag filters associated with the deployment group, which are also referred to as tag groups (documented below). See the AWS docs for details.
     */
    public val ec2TagSets: Output<List<DeploymentGroupEc2TagSet>>?
        get() = javaResource.ec2TagSets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> deploymentGroupEc2TagSetToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Configuration block(s) of the ECS services for a deployment group (documented below).
     */
    public val ecsService: Output<DeploymentGroupEcsService>?
        get() = javaResource.ecsService().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    deploymentGroupEcsServiceToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Single configuration block of the load balancer to use in a blue/green deployment (documented below).
     */
    public val loadBalancerInfo: Output<DeploymentGroupLoadBalancerInfo>?
        get() = javaResource.loadBalancerInfo().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> deploymentGroupLoadBalancerInfoToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * On premise tag filters associated with the group. See the AWS docs for details.
     */
    public val onPremisesInstanceTagFilters: Output<List<DeploymentGroupOnPremisesInstanceTagFilter>>?
        get() = javaResource.onPremisesInstanceTagFilters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        deploymentGroupOnPremisesInstanceTagFilterToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Configuration block of Indicates what happens when new Amazon EC2 instances are launched mid-deployment and do not receive the deployed application revision. Valid values are `UPDATE` and `IGNORE`. Defaults to `UPDATE`.
     */
    public val outdatedInstancesStrategy: Output<String>?
        get() = javaResource.outdatedInstancesStrategy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The service role ARN that allows deployments.
     */
    public val serviceRoleArn: Output<String>
        get() = javaResource.serviceRoleArn().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Configuration block(s) of the triggers for the deployment group (documented below).
     */
    public val triggerConfigurations: Output<List<DeploymentGroupTriggerConfiguration>>?
        get() = javaResource.triggerConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        deploymentGroupTriggerConfigurationToKotlin(args0)
                    })
                })
            }).orElse(null)
        })
}

public object DeploymentGroupMapper : ResourceMapper<DeploymentGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.codedeploy.DeploymentGroup::class == javaResource::class

    override fun map(javaResource: Resource): DeploymentGroup = DeploymentGroup(
        javaResource as
            com.pulumi.aws.codedeploy.DeploymentGroup,
    )
}

/**
 * @see [DeploymentGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DeploymentGroup].
 */
public suspend fun deploymentGroup(
    name: String,
    block: suspend DeploymentGroupResourceBuilder.() -> Unit,
): DeploymentGroup {
    val builder = DeploymentGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DeploymentGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun deploymentGroup(name: String): DeploymentGroup {
    val builder = DeploymentGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
