@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codedeploy.kotlin

import com.pulumi.aws.codedeploy.DeploymentGroupArgs.builder
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentGroupAlarmConfigurationArgs
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentGroupAlarmConfigurationArgsBuilder
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentGroupAutoRollbackConfigurationArgs
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentGroupAutoRollbackConfigurationArgsBuilder
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentGroupBlueGreenDeploymentConfigArgs
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentGroupBlueGreenDeploymentConfigArgsBuilder
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentGroupDeploymentStyleArgs
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentGroupDeploymentStyleArgsBuilder
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentGroupEc2TagFilterArgs
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentGroupEc2TagFilterArgsBuilder
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentGroupEc2TagSetArgs
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentGroupEc2TagSetArgsBuilder
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentGroupEcsServiceArgs
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentGroupEcsServiceArgsBuilder
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentGroupLoadBalancerInfoArgs
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentGroupLoadBalancerInfoArgsBuilder
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentGroupOnPremisesInstanceTagFilterArgs
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentGroupOnPremisesInstanceTagFilterArgsBuilder
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentGroupTriggerConfigurationArgs
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentGroupTriggerConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a CodeDeploy Deployment Group for a CodeDeploy Application
 * > **NOTE on blue/green deployments:** When using `green_fleet_provisioning_option` with the `COPY_AUTO_SCALING_GROUP` action, CodeDeploy will create a new ASG with a different name. This ASG is _not_ managed by this provider and will conflict with existing configuration and state. You may want to use a different approach to managing deployments that involve multiple ASG, such as `DISCOVER_EXISTING` with separate blue and green ASG.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const assumeRole = aws.iam.getPolicyDocument({
 *     statements: [{
 *         effect: "Allow",
 *         principals: [{
 *             type: "Service",
 *             identifiers: ["codedeploy&#46;amazonaws&#46;com"],
 *         }],
 *         actions: ["sts:AssumeRole"],
 *     }],
 * });
 * const example = new aws.iam.Role("example", {
 *     name: "example-role",
 *     assumeRolePolicy: assumeRole.then(assumeRole => assumeRole.json),
 * });
 * const aWSCodeDeployRole = new aws.iam.RolePolicyAttachment("AWSCodeDeployRole", {
 *     policyArn: "arn:aws:iam::aws:policy/service-role/AWSCodeDeployRole",
 *     role: example.name,
 * });
 * const exampleApplication = new aws.codedeploy.Application("example", {name: "example-app"});
 * const exampleTopic = new aws.sns.Topic("example", {name: "example-topic"});
 * const exampleDeploymentGroup = new aws.codedeploy.DeploymentGroup("example", {
 *     appName: exampleApplication.name,
 *     deploymentGroupName: "example-group",
 *     serviceRoleArn: example.arn,
 *     ec2TagSets: [{
 *         ec2TagFilters: [
 *             {
 *                 key: "filterkey1",
 *                 type: "KEY_AND_VALUE",
 *                 value: "filtervalue",
 *             },
 *             {
 *                 key: "filterkey2",
 *                 type: "KEY_AND_VALUE",
 *                 value: "filtervalue",
 *             },
 *         ],
 *     }],
 *     triggerConfigurations: [{
 *         triggerEvents: ["DeploymentFailure"],
 *         triggerName: "example-trigger",
 *         triggerTargetArn: exampleTopic.arn,
 *     }],
 *     autoRollbackConfiguration: {
 *         enabled: true,
 *         events: ["DEPLOYMENT_FAILURE"],
 *     },
 *     alarmConfiguration: {
 *         alarms: ["my-alarm-name"],
 *         enabled: true,
 *     },
 *     outdatedInstancesStrategy: "UPDATE",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * assume_role = aws.iam.get_policy_document(statements=[{
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": ["codedeploy&#46;amazonaws&#46;com"],
 *     }],
 *     "actions": ["sts:AssumeRole"],
 * }])
 * example = aws.iam.Role("example",
 *     name="example-role",
 *     assume_role_policy=assume_role.json)
 * a_ws_code_deploy_role = aws.iam.RolePolicyAttachment("AWSCodeDeployRole",
 *     policy_arn="arn:aws:iam::aws:policy/service-role/AWSCodeDeployRole",
 *     role=example.name)
 * example_application = aws.codedeploy.Application("example", name="example-app")
 * example_topic = aws.sns.Topic("example", name="example-topic")
 * example_deployment_group = aws.codedeploy.DeploymentGroup("example",
 *     app_name=example_application.name,
 *     deployment_group_name="example-group",
 *     service_role_arn=example.arn,
 *     ec2_tag_sets=[{
 *         "ec2_tag_filters": [
 *             {
 *                 "key": "filterkey1",
 *                 "type": "KEY_AND_VALUE",
 *                 "value": "filtervalue",
 *             },
 *             {
 *                 "key": "filterkey2",
 *                 "type": "KEY_AND_VALUE",
 *                 "value": "filtervalue",
 *             },
 *         ],
 *     }],
 *     trigger_configurations=[{
 *         "trigger_events": ["DeploymentFailure"],
 *         "trigger_name": "example-trigger",
 *         "trigger_target_arn": example_topic.arn,
 *     }],
 *     auto_rollback_configuration={
 *         "enabled": True,
 *         "events": ["DEPLOYMENT_FAILURE"],
 *     },
 *     alarm_configuration={
 *         "alarms": ["my-alarm-name"],
 *         "enabled": True,
 *     },
 *     outdated_instances_strategy="UPDATE")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var assumeRole = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "codedeploy.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRole",
 *                 },
 *             },
 *         },
 *     });
 *     var example = new Aws.Iam.Role("example", new()
 *     {
 *         Name = "example-role",
 *         AssumeRolePolicy = assumeRole.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var aWSCodeDeployRole = new Aws.Iam.RolePolicyAttachment("AWSCodeDeployRole", new()
 *     {
 *         PolicyArn = "arn:aws:iam::aws:policy/service-role/AWSCodeDeployRole",
 *         Role = example.Name,
 *     });
 *     var exampleApplication = new Aws.CodeDeploy.Application("example", new()
 *     {
 *         Name = "example-app",
 *     });
 *     var exampleTopic = new Aws.Sns.Topic("example", new()
 *     {
 *         Name = "example-topic",
 *     });
 *     var exampleDeploymentGroup = new Aws.CodeDeploy.DeploymentGroup("example", new()
 *     {
 *         AppName = exampleApplication.Name,
 *         DeploymentGroupName = "example-group",
 *         ServiceRoleArn = example.Arn,
 *         Ec2TagSets = new[]
 *         {
 *             new Aws.CodeDeploy.Inputs.DeploymentGroupEc2TagSetArgs
 *             {
 *                 Ec2TagFilters = new[]
 *                 {
 *                     new Aws.CodeDeploy.Inputs.DeploymentGroupEc2TagSetEc2TagFilterArgs
 *                     {
 *                         Key = "filterkey1",
 *                         Type = "KEY_AND_VALUE",
 *                         Value = "filtervalue",
 *                     },
 *                     new Aws.CodeDeploy.Inputs.DeploymentGroupEc2TagSetEc2TagFilterArgs
 *                     {
 *                         Key = "filterkey2",
 *                         Type = "KEY_AND_VALUE",
 *                         Value = "filtervalue",
 *                     },
 *                 },
 *             },
 *         },
 *         TriggerConfigurations = new[]
 *         {
 *             new Aws.CodeDeploy.Inputs.DeploymentGroupTriggerConfigurationArgs
 *             {
 *                 TriggerEvents = new[]
 *                 {
 *                     "DeploymentFailure",
 *                 },
 *                 TriggerName = "example-trigger",
 *                 TriggerTargetArn = exampleTopic.Arn,
 *             },
 *         },
 *         AutoRollbackConfiguration = new Aws.CodeDeploy.Inputs.DeploymentGroupAutoRollbackConfigurationArgs
 *         {
 *             Enabled = true,
 *             Events = new[]
 *             {
 *                 "DEPLOYMENT_FAILURE",
 *             },
 *         },
 *         AlarmConfiguration = new Aws.CodeDeploy.Inputs.DeploymentGroupAlarmConfigurationArgs
 *         {
 *             Alarms = new[]
 *             {
 *                 "my-alarm-name",
 *             },
 *             Enabled = true,
 *         },
 *         OutdatedInstancesStrategy = "UPDATE",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codedeploy"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		assumeRole, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "Service",
 * 							Identifiers: []string{
 * 								"codedeploy.amazonaws.com",
 * 							},
 * 						},
 * 					},
 * 					Actions: []string{
 * 						"sts:AssumeRole",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := iam.NewRole(ctx, "example", &iam.RoleArgs{
 * 			Name:             pulumi.String("example-role"),
 * 			AssumeRolePolicy: pulumi.String(assumeRole.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iam.NewRolePolicyAttachment(ctx, "AWSCodeDeployRole", &iam.RolePolicyAttachmentArgs{
 * 			PolicyArn: pulumi.String("arn:aws:iam::aws:policy/service-role/AWSCodeDeployRole"),
 * 			Role:      example.Name,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleApplication, err := codedeploy.NewApplication(ctx, "example", &codedeploy.ApplicationArgs{
 * 			Name: pulumi.String("example-app"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleTopic, err := sns.NewTopic(ctx, "example", &sns.TopicArgs{
 * 			Name: pulumi.String("example-topic"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = codedeploy.NewDeploymentGroup(ctx, "example", &codedeploy.DeploymentGroupArgs{
 * 			AppName:             exampleApplication.Name,
 * 			DeploymentGroupName: pulumi.String("example-group"),
 * 			ServiceRoleArn:      example.Arn,
 * 			Ec2TagSets: codedeploy.DeploymentGroupEc2TagSetArray{
 * 				&codedeploy.DeploymentGroupEc2TagSetArgs{
 * 					Ec2TagFilters: codedeploy.DeploymentGroupEc2TagSetEc2TagFilterArray{
 * 						&codedeploy.DeploymentGroupEc2TagSetEc2TagFilterArgs{
 * 							Key:   pulumi.String("filterkey1"),
 * 							Type:  pulumi.String("KEY_AND_VALUE"),
 * 							Value: pulumi.String("filtervalue"),
 * 						},
 * 						&codedeploy.DeploymentGroupEc2TagSetEc2TagFilterArgs{
 * 							Key:   pulumi.String("filterkey2"),
 * 							Type:  pulumi.String("KEY_AND_VALUE"),
 * 							Value: pulumi.String("filtervalue"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			TriggerConfigurations: codedeploy.DeploymentGroupTriggerConfigurationArray{
 * 				&codedeploy.DeploymentGroupTriggerConfigurationArgs{
 * 					TriggerEvents: pulumi.StringArray{
 * 						pulumi.String("DeploymentFailure"),
 * 					},
 * 					TriggerName:      pulumi.String("example-trigger"),
 * 					TriggerTargetArn: exampleTopic.Arn,
 * 				},
 * 			},
 * 			AutoRollbackConfiguration: &codedeploy.DeploymentGroupAutoRollbackConfigurationArgs{
 * 				Enabled: pulumi.Bool(true),
 * 				Events: pulumi.StringArray{
 * 					pulumi.String("DEPLOYMENT_FAILURE"),
 * 				},
 * 			},
 * 			AlarmConfiguration: &codedeploy.DeploymentGroupAlarmConfigurationArgs{
 * 				Alarms: pulumi.StringArray{
 * 					pulumi.String("my-alarm-name"),
 * 				},
 * 				Enabled: pulumi.Bool(true),
 * 			},
 * 			OutdatedInstancesStrategy: pulumi.String("UPDATE"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.codedeploy.Application;
 * import com.pulumi.aws.codedeploy.ApplicationArgs;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.sns.TopicArgs;
 * import com.pulumi.aws.codedeploy.DeploymentGroup;
 * import com.pulumi.aws.codedeploy.DeploymentGroupArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupEc2TagSetArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupTriggerConfigurationArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupAutoRollbackConfigurationArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupAlarmConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("codedeploy.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var example = new Role("example", RoleArgs.builder()
 *             .name("example-role")
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var aWSCodeDeployRole = new RolePolicyAttachment("aWSCodeDeployRole", RolePolicyAttachmentArgs.builder()
 *             .policyArn("arn:aws:iam::aws:policy/service-role/AWSCodeDeployRole")
 *             .role(example.name())
 *             .build());
 *         var exampleApplication = new Application("exampleApplication", ApplicationArgs.builder()
 *             .name("example-app")
 *             .build());
 *         var exampleTopic = new Topic("exampleTopic", TopicArgs.builder()
 *             .name("example-topic")
 *             .build());
 *         var exampleDeploymentGroup = new DeploymentGroup("exampleDeploymentGroup", DeploymentGroupArgs.builder()
 *             .appName(exampleApplication.name())
 *             .deploymentGroupName("example-group")
 *             .serviceRoleArn(example.arn())
 *             .ec2TagSets(DeploymentGroupEc2TagSetArgs.builder()
 *                 .ec2TagFilters(
 *                     DeploymentGroupEc2TagSetEc2TagFilterArgs.builder()
 *                         .key("filterkey1")
 *                         .type("KEY_AND_VALUE")
 *                         .value("filtervalue")
 *                         .build(),
 *                     DeploymentGroupEc2TagSetEc2TagFilterArgs.builder()
 *                         .key("filterkey2")
 *                         .type("KEY_AND_VALUE")
 *                         .value("filtervalue")
 *                         .build())
 *                 .build())
 *             .triggerConfigurations(DeploymentGroupTriggerConfigurationArgs.builder()
 *                 .triggerEvents("DeploymentFailure")
 *                 .triggerName("example-trigger")
 *                 .triggerTargetArn(exampleTopic.arn())
 *                 .build())
 *             .autoRollbackConfiguration(DeploymentGroupAutoRollbackConfigurationArgs.builder()
 *                 .enabled(true)
 *                 .events("DEPLOYMENT_FAILURE")
 *                 .build())
 *             .alarmConfiguration(DeploymentGroupAlarmConfigurationArgs.builder()
 *                 .alarms("my-alarm-name")
 *                 .enabled(true)
 *                 .build())
 *             .outdatedInstancesStrategy("UPDATE")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:iam:Role
 *     properties:
 *       name: example-role
 *       assumeRolePolicy: ${assumeRole.json}
 *   aWSCodeDeployRole:
 *     type: aws:iam:RolePolicyAttachment
 *     name: AWSCodeDeployRole
 *     properties:
 *       policyArn: arn:aws:iam::aws:policy/service-role/AWSCodeDeployRole
 *       role: ${example.name}
 *   exampleApplication:
 *     type: aws:codedeploy:Application
 *     name: example
 *     properties:
 *       name: example-app
 *   exampleTopic:
 *     type: aws:sns:Topic
 *     name: example
 *     properties:
 *       name: example-topic
 *   exampleDeploymentGroup:
 *     type: aws:codedeploy:DeploymentGroup
 *     name: example
 *     properties:
 *       appName: ${exampleApplication.name}
 *       deploymentGroupName: example-group
 *       serviceRoleArn: ${example.arn}
 *       ec2TagSets:
 *         - ec2TagFilters:
 *             - key: filterkey1
 *               type: KEY_AND_VALUE
 *               value: filtervalue
 *             - key: filterkey2
 *               type: KEY_AND_VALUE
 *               value: filtervalue
 *       triggerConfigurations:
 *         - triggerEvents:
 *             - DeploymentFailure
 *           triggerName: example-trigger
 *           triggerTargetArn: ${exampleTopic.arn}
 *       autoRollbackConfiguration:
 *         enabled: true
 *         events:
 *           - DEPLOYMENT_FAILURE
 *       alarmConfiguration:
 *         alarms:
 *           - my-alarm-name
 *         enabled: true
 *       outdatedInstancesStrategy: UPDATE
 * variables:
 *   assumeRole:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - codedeploy.amazonaws.com
 *             actions:
 *               - sts:AssumeRole
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Blue Green Deployments with ECS
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.codedeploy.Application("example", {
 *     computePlatform: "ECS",
 *     name: "example",
 * });
 * const exampleDeploymentGroup = new aws.codedeploy.DeploymentGroup("example", {
 *     appName: example.name,
 *     deploymentConfigName: "CodeDeployDefault.ECSAllAtOnce",
 *     deploymentGroupName: "example",
 *     serviceRoleArn: exampleAwsIamRole.arn,
 *     autoRollbackConfiguration: {
 *         enabled: true,
 *         events: ["DEPLOYMENT_FAILURE"],
 *     },
 *     blueGreenDeploymentConfig: {
 *         deploymentReadyOption: {
 *             actionOnTimeout: "CONTINUE_DEPLOYMENT",
 *         },
 *         terminateBlueInstancesOnDeploymentSuccess: {
 *             action: "TERMINATE",
 *             terminationWaitTimeInMinutes: 5,
 *         },
 *     },
 *     deploymentStyle: {
 *         deploymentOption: "WITH_TRAFFIC_CONTROL",
 *         deploymentType: "BLUE_GREEN",
 *     },
 *     ecsService: {
 *         clusterName: exampleAwsEcsCluster.name,
 *         serviceName: exampleAwsEcsService.name,
 *     },
 *     loadBalancerInfo: {
 *         targetGroupPairInfo: {
 *             prodTrafficRoute: {
 *                 listenerArns: [exampleAwsLbListener&#46;arn],
 *             },
 *             targetGroups: [
 *                 {
 *                     name: blue.name,
 *                 },
 *                 {
 *                     name: green.name,
 *                 },
 *             ],
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.codedeploy.Application("example",
 *     compute_platform="ECS",
 *     name="example")
 * example_deployment_group = aws.codedeploy.DeploymentGroup("example",
 *     app_name=example.name,
 *     deployment_config_name="CodeDeployDefault.ECSAllAtOnce",
 *     deployment_group_name="example",
 *     service_role_arn=example_aws_iam_role["arn"],
 *     auto_rollback_configuration={
 *         "enabled": True,
 *         "events": ["DEPLOYMENT_FAILURE"],
 *     },
 *     blue_green_deployment_config={
 *         "deployment_ready_option": {
 *             "action_on_timeout": "CONTINUE_DEPLOYMENT",
 *         },
 *         "terminate_blue_instances_on_deployment_success": {
 *             "action": "TERMINATE",
 *             "termination_wait_time_in_minutes": 5,
 *         },
 *     },
 *     deployment_style={
 *         "deployment_option": "WITH_TRAFFIC_CONTROL",
 *         "deployment_type": "BLUE_GREEN",
 *     },
 *     ecs_service={
 *         "cluster_name": example_aws_ecs_cluster["name"],
 *         "service_name": example_aws_ecs_service["name"],
 *     },
 *     load_balancer_info={
 *         "target_group_pair_info": {
 *             "prod_traffic_route": {
 *                 "listener_arns": [example_aws_lb_listener["arn"]],
 *             },
 *             "target_groups": [
 *                 {
 *                     "name": blue["name"],
 *                 },
 *                 {
 *                     "name": green["name"],
 *                 },
 *             ],
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CodeDeploy.Application("example", new()
 *     {
 *         ComputePlatform = "ECS",
 *         Name = "example",
 *     });
 *     var exampleDeploymentGroup = new Aws.CodeDeploy.DeploymentGroup("example", new()
 *     {
 *         AppName = example.Name,
 *         DeploymentConfigName = "CodeDeployDefault.ECSAllAtOnce",
 *         DeploymentGroupName = "example",
 *         ServiceRoleArn = exampleAwsIamRole.Arn,
 *         AutoRollbackConfiguration = new Aws.CodeDeploy.Inputs.DeploymentGroupAutoRollbackConfigurationArgs
 *         {
 *             Enabled = true,
 *             Events = new[]
 *             {
 *                 "DEPLOYMENT_FAILURE",
 *             },
 *         },
 *         BlueGreenDeploymentConfig = new Aws.CodeDeploy.Inputs.DeploymentGroupBlueGreenDeploymentConfigArgs
 *         {
 *             DeploymentReadyOption = new Aws.CodeDeploy.Inputs.DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgs
 *             {
 *                 ActionOnTimeout = "CONTINUE_DEPLOYMENT",
 *             },
 *             TerminateBlueInstancesOnDeploymentSuccess = new Aws.CodeDeploy.Inputs.DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgs
 *             {
 *                 Action = "TERMINATE",
 *                 TerminationWaitTimeInMinutes = 5,
 *             },
 *         },
 *         DeploymentStyle = new Aws.CodeDeploy.Inputs.DeploymentGroupDeploymentStyleArgs
 *         {
 *             DeploymentOption = "WITH_TRAFFIC_CONTROL",
 *             DeploymentType = "BLUE_GREEN",
 *         },
 *         EcsService = new Aws.CodeDeploy.Inputs.DeploymentGroupEcsServiceArgs
 *         {
 *             ClusterName = exampleAwsEcsCluster.Name,
 *             ServiceName = exampleAwsEcsService.Name,
 *         },
 *         LoadBalancerInfo = new Aws.CodeDeploy.Inputs.DeploymentGroupLoadBalancerInfoArgs
 *         {
 *             TargetGroupPairInfo = new Aws.CodeDeploy.Inputs.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoArgs
 *             {
 *                 ProdTrafficRoute = new Aws.CodeDeploy.Inputs.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoProdTrafficRouteArgs
 *                 {
 *                     ListenerArns = new[]
 *                     {
 *                         exampleAwsLbListener.Arn,
 *                     },
 *                 },
 *                 TargetGroups = new[]
 *                 {
 *                     new Aws.CodeDeploy.Inputs.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArgs
 *                     {
 *                         Name = blue.Name,
 *                     },
 *                     new Aws.CodeDeploy.Inputs.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArgs
 *                     {
 *                         Name = green.Name,
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codedeploy"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := codedeploy.NewApplication(ctx, "example", &codedeploy.ApplicationArgs{
 * 			ComputePlatform: pulumi.String("ECS"),
 * 			Name:            pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = codedeploy.NewDeploymentGroup(ctx, "example", &codedeploy.DeploymentGroupArgs{
 * 			AppName:              example.Name,
 * 			DeploymentConfigName: pulumi.String("CodeDeployDefault.ECSAllAtOnce"),
 * 			DeploymentGroupName:  pulumi.String("example"),
 * 			ServiceRoleArn:       pulumi.Any(exampleAwsIamRole.Arn),
 * 			AutoRollbackConfiguration: &codedeploy.DeploymentGroupAutoRollbackConfigurationArgs{
 * 				Enabled: pulumi.Bool(true),
 * 				Events: pulumi.StringArray{
 * 					pulumi.String("DEPLOYMENT_FAILURE"),
 * 				},
 * 			},
 * 			BlueGreenDeploymentConfig: &codedeploy.DeploymentGroupBlueGreenDeploymentConfigArgs{
 * 				DeploymentReadyOption: &codedeploy.DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgs{
 * 					ActionOnTimeout: pulumi.String("CONTINUE_DEPLOYMENT"),
 * 				},
 * 				TerminateBlueInstancesOnDeploymentSuccess: &codedeploy.DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgs{
 * 					Action:                       pulumi.String("TERMINATE"),
 * 					TerminationWaitTimeInMinutes: pulumi.Int(5),
 * 				},
 * 			},
 * 			DeploymentStyle: &codedeploy.DeploymentGroupDeploymentStyleArgs{
 * 				DeploymentOption: pulumi.String("WITH_TRAFFIC_CONTROL"),
 * 				DeploymentType:   pulumi.String("BLUE_GREEN"),
 * 			},
 * 			EcsService: &codedeploy.DeploymentGroupEcsServiceArgs{
 * 				ClusterName: pulumi.Any(exampleAwsEcsCluster.Name),
 * 				ServiceName: pulumi.Any(exampleAwsEcsService.Name),
 * 			},
 * 			LoadBalancerInfo: &codedeploy.DeploymentGroupLoadBalancerInfoArgs{
 * 				TargetGroupPairInfo: &codedeploy.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoArgs{
 * 					ProdTrafficRoute: &codedeploy.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoProdTrafficRouteArgs{
 * 						ListenerArns: pulumi.StringArray{
 * 							exampleAwsLbListener.Arn,
 * 						},
 * 					},
 * 					TargetGroups: codedeploy.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArray{
 * 						&codedeploy.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArgs{
 * 							Name: pulumi.Any(blue.Name),
 * 						},
 * 						&codedeploy.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArgs{
 * 							Name: pulumi.Any(green.Name),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codedeploy.Application;
 * import com.pulumi.aws.codedeploy.ApplicationArgs;
 * import com.pulumi.aws.codedeploy.DeploymentGroup;
 * import com.pulumi.aws.codedeploy.DeploymentGroupArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupAutoRollbackConfigurationArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupBlueGreenDeploymentConfigArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupDeploymentStyleArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupEcsServiceArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupLoadBalancerInfoArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoProdTrafficRouteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Application("example", ApplicationArgs.builder()
 *             .computePlatform("ECS")
 *             .name("example")
 *             .build());
 *         var exampleDeploymentGroup = new DeploymentGroup("exampleDeploymentGroup", DeploymentGroupArgs.builder()
 *             .appName(example.name())
 *             .deploymentConfigName("CodeDeployDefault.ECSAllAtOnce")
 *             .deploymentGroupName("example")
 *             .serviceRoleArn(exampleAwsIamRole.arn())
 *             .autoRollbackConfiguration(DeploymentGroupAutoRollbackConfigurationArgs.builder()
 *                 .enabled(true)
 *                 .events("DEPLOYMENT_FAILURE")
 *                 .build())
 *             .blueGreenDeploymentConfig(DeploymentGroupBlueGreenDeploymentConfigArgs.builder()
 *                 .deploymentReadyOption(DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgs.builder()
 *                     .actionOnTimeout("CONTINUE_DEPLOYMENT")
 *                     .build())
 *                 .terminateBlueInstancesOnDeploymentSuccess(DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgs.builder()
 *                     .action("TERMINATE")
 *                     .terminationWaitTimeInMinutes(5)
 *                     .build())
 *                 .build())
 *             .deploymentStyle(DeploymentGroupDeploymentStyleArgs.builder()
 *                 .deploymentOption("WITH_TRAFFIC_CONTROL")
 *                 .deploymentType("BLUE_GREEN")
 *                 .build())
 *             .ecsService(DeploymentGroupEcsServiceArgs.builder()
 *                 .clusterName(exampleAwsEcsCluster.name())
 *                 .serviceName(exampleAwsEcsService.name())
 *                 .build())
 *             .loadBalancerInfo(DeploymentGroupLoadBalancerInfoArgs.builder()
 *                 .targetGroupPairInfo(DeploymentGroupLoadBalancerInfoTargetGroupPairInfoArgs.builder()
 *                     .prodTrafficRoute(DeploymentGroupLoadBalancerInfoTargetGroupPairInfoProdTrafficRouteArgs.builder()
 *                         .listenerArns(exampleAwsLbListener.arn())
 *                         .build())
 *                     .targetGroups(
 *                         DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArgs.builder()
 *                             .name(blue.name())
 *                             .build(),
 *                         DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArgs.builder()
 *                             .name(green.name())
 *                             .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:codedeploy:Application
 *     properties:
 *       computePlatform: ECS
 *       name: example
 *   exampleDeploymentGroup:
 *     type: aws:codedeploy:DeploymentGroup
 *     name: example
 *     properties:
 *       appName: ${example.name}
 *       deploymentConfigName: CodeDeployDefault.ECSAllAtOnce
 *       deploymentGroupName: example
 *       serviceRoleArn: ${exampleAwsIamRole.arn}
 *       autoRollbackConfiguration:
 *         enabled: true
 *         events:
 *           - DEPLOYMENT_FAILURE
 *       blueGreenDeploymentConfig:
 *         deploymentReadyOption:
 *           actionOnTimeout: CONTINUE_DEPLOYMENT
 *         terminateBlueInstancesOnDeploymentSuccess:
 *           action: TERMINATE
 *           terminationWaitTimeInMinutes: 5
 *       deploymentStyle:
 *         deploymentOption: WITH_TRAFFIC_CONTROL
 *         deploymentType: BLUE_GREEN
 *       ecsService:
 *         clusterName: ${exampleAwsEcsCluster.name}
 *         serviceName: ${exampleAwsEcsService.name}
 *       loadBalancerInfo:
 *         targetGroupPairInfo:
 *           prodTrafficRoute:
 *             listenerArns:
 *               - ${exampleAwsLbListener.arn}
 *           targetGroups:
 *             - name: ${blue.name}
 *             - name: ${green.name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Blue Green Deployments with Servers and Classic ELB
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.codedeploy.Application("example", {name: "example-app"});
 * const exampleDeploymentGroup = new aws.codedeploy.DeploymentGroup("example", {
 *     appName: example.name,
 *     deploymentGroupName: "example-group",
 *     serviceRoleArn: exampleAwsIamRole.arn,
 *     deploymentStyle: {
 *         deploymentOption: "WITH_TRAFFIC_CONTROL",
 *         deploymentType: "BLUE_GREEN",
 *     },
 *     loadBalancerInfo: {
 *         elbInfos: [{
 *             name: exampleAwsElb.name,
 *         }],
 *     },
 *     blueGreenDeploymentConfig: {
 *         deploymentReadyOption: {
 *             actionOnTimeout: "STOP_DEPLOYMENT",
 *             waitTimeInMinutes: 60,
 *         },
 *         greenFleetProvisioningOption: {
 *             action: "DISCOVER_EXISTING",
 *         },
 *         terminateBlueInstancesOnDeploymentSuccess: {
 *             action: "KEEP_ALIVE",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.codedeploy.Application("example", name="example-app")
 * example_deployment_group = aws.codedeploy.DeploymentGroup("example",
 *     app_name=example.name,
 *     deployment_group_name="example-group",
 *     service_role_arn=example_aws_iam_role["arn"],
 *     deployment_style={
 *         "deployment_option": "WITH_TRAFFIC_CONTROL",
 *         "deployment_type": "BLUE_GREEN",
 *     },
 *     load_balancer_info={
 *         "elb_infos": [{
 *             "name": example_aws_elb["name"],
 *         }],
 *     },
 *     blue_green_deployment_config={
 *         "deployment_ready_option": {
 *             "action_on_timeout": "STOP_DEPLOYMENT",
 *             "wait_time_in_minutes": 60,
 *         },
 *         "green_fleet_provisioning_option": {
 *             "action": "DISCOVER_EXISTING",
 *         },
 *         "terminate_blue_instances_on_deployment_success": {
 *             "action": "KEEP_ALIVE",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CodeDeploy.Application("example", new()
 *     {
 *         Name = "example-app",
 *     });
 *     var exampleDeploymentGroup = new Aws.CodeDeploy.DeploymentGroup("example", new()
 *     {
 *         AppName = example.Name,
 *         DeploymentGroupName = "example-group",
 *         ServiceRoleArn = exampleAwsIamRole.Arn,
 *         DeploymentStyle = new Aws.CodeDeploy.Inputs.DeploymentGroupDeploymentStyleArgs
 *         {
 *             DeploymentOption = "WITH_TRAFFIC_CONTROL",
 *             DeploymentType = "BLUE_GREEN",
 *         },
 *         LoadBalancerInfo = new Aws.CodeDeploy.Inputs.DeploymentGroupLoadBalancerInfoArgs
 *         {
 *             ElbInfos = new[]
 *             {
 *                 new Aws.CodeDeploy.Inputs.DeploymentGroupLoadBalancerInfoElbInfoArgs
 *                 {
 *                     Name = exampleAwsElb.Name,
 *                 },
 *             },
 *         },
 *         BlueGreenDeploymentConfig = new Aws.CodeDeploy.Inputs.DeploymentGroupBlueGreenDeploymentConfigArgs
 *         {
 *             DeploymentReadyOption = new Aws.CodeDeploy.Inputs.DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgs
 *             {
 *                 ActionOnTimeout = "STOP_DEPLOYMENT",
 *                 WaitTimeInMinutes = 60,
 *             },
 *             GreenFleetProvisioningOption = new Aws.CodeDeploy.Inputs.DeploymentGroupBlueGreenDeploymentConfigGreenFleetProvisioningOptionArgs
 *             {
 *                 Action = "DISCOVER_EXISTING",
 *             },
 *             TerminateBlueInstancesOnDeploymentSuccess = new Aws.CodeDeploy.Inputs.DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgs
 *             {
 *                 Action = "KEEP_ALIVE",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codedeploy"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := codedeploy.NewApplication(ctx, "example", &codedeploy.ApplicationArgs{
 * 			Name: pulumi.String("example-app"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = codedeploy.NewDeploymentGroup(ctx, "example", &codedeploy.DeploymentGroupArgs{
 * 			AppName:             example.Name,
 * 			DeploymentGroupName: pulumi.String("example-group"),
 * 			ServiceRoleArn:      pulumi.Any(exampleAwsIamRole.Arn),
 * 			DeploymentStyle: &codedeploy.DeploymentGroupDeploymentStyleArgs{
 * 				DeploymentOption: pulumi.String("WITH_TRAFFIC_CONTROL"),
 * 				DeploymentType:   pulumi.String("BLUE_GREEN"),
 * 			},
 * 			LoadBalancerInfo: &codedeploy.DeploymentGroupLoadBalancerInfoArgs{
 * 				ElbInfos: codedeploy.DeploymentGroupLoadBalancerInfoElbInfoArray{
 * 					&codedeploy.DeploymentGroupLoadBalancerInfoElbInfoArgs{
 * 						Name: pulumi.Any(exampleAwsElb.Name),
 * 					},
 * 				},
 * 			},
 * 			BlueGreenDeploymentConfig: &codedeploy.DeploymentGroupBlueGreenDeploymentConfigArgs{
 * 				DeploymentReadyOption: &codedeploy.DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgs{
 * 					ActionOnTimeout:   pulumi.String("STOP_DEPLOYMENT"),
 * 					WaitTimeInMinutes: pulumi.Int(60),
 * 				},
 * 				GreenFleetProvisioningOption: &codedeploy.DeploymentGroupBlueGreenDeploymentConfigGreenFleetProvisioningOptionArgs{
 * 					Action: pulumi.String("DISCOVER_EXISTING"),
 * 				},
 * 				TerminateBlueInstancesOnDeploymentSuccess: &codedeploy.DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgs{
 * 					Action: pulumi.String("KEEP_ALIVE"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codedeploy.Application;
 * import com.pulumi.aws.codedeploy.ApplicationArgs;
 * import com.pulumi.aws.codedeploy.DeploymentGroup;
 * import com.pulumi.aws.codedeploy.DeploymentGroupArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupDeploymentStyleArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupLoadBalancerInfoArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupBlueGreenDeploymentConfigArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupBlueGreenDeploymentConfigGreenFleetProvisioningOptionArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Application("example", ApplicationArgs.builder()
 *             .name("example-app")
 *             .build());
 *         var exampleDeploymentGroup = new DeploymentGroup("exampleDeploymentGroup", DeploymentGroupArgs.builder()
 *             .appName(example.name())
 *             .deploymentGroupName("example-group")
 *             .serviceRoleArn(exampleAwsIamRole.arn())
 *             .deploymentStyle(DeploymentGroupDeploymentStyleArgs.builder()
 *                 .deploymentOption("WITH_TRAFFIC_CONTROL")
 *                 .deploymentType("BLUE_GREEN")
 *                 .build())
 *             .loadBalancerInfo(DeploymentGroupLoadBalancerInfoArgs.builder()
 *                 .elbInfos(DeploymentGroupLoadBalancerInfoElbInfoArgs.builder()
 *                     .name(exampleAwsElb.name())
 *                     .build())
 *                 .build())
 *             .blueGreenDeploymentConfig(DeploymentGroupBlueGreenDeploymentConfigArgs.builder()
 *                 .deploymentReadyOption(DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgs.builder()
 *                     .actionOnTimeout("STOP_DEPLOYMENT")
 *                     .waitTimeInMinutes(60)
 *                     .build())
 *                 .greenFleetProvisioningOption(DeploymentGroupBlueGreenDeploymentConfigGreenFleetProvisioningOptionArgs.builder()
 *                     .action("DISCOVER_EXISTING")
 *                     .build())
 *                 .terminateBlueInstancesOnDeploymentSuccess(DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgs.builder()
 *                     .action("KEEP_ALIVE")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:codedeploy:Application
 *     properties:
 *       name: example-app
 *   exampleDeploymentGroup:
 *     type: aws:codedeploy:DeploymentGroup
 *     name: example
 *     properties:
 *       appName: ${example.name}
 *       deploymentGroupName: example-group
 *       serviceRoleArn: ${exampleAwsIamRole.arn}
 *       deploymentStyle:
 *         deploymentOption: WITH_TRAFFIC_CONTROL
 *         deploymentType: BLUE_GREEN
 *       loadBalancerInfo:
 *         elbInfos:
 *           - name: ${exampleAwsElb.name}
 *       blueGreenDeploymentConfig:
 *         deploymentReadyOption:
 *           actionOnTimeout: STOP_DEPLOYMENT
 *           waitTimeInMinutes: 60
 *         greenFleetProvisioningOption:
 *           action: DISCOVER_EXISTING
 *         terminateBlueInstancesOnDeploymentSuccess:
 *           action: KEEP_ALIVE
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CodeDeploy Deployment Groups using `app_name`, a colon, and `deployment_group_name`. For example:
 * ```sh
 * $ pulumi import aws:codedeploy/deploymentGroup:DeploymentGroup example my-application:my-deployment-group
 * ```
 * @property alarmConfiguration Configuration block of alarms associated with the deployment group (documented below).
 * @property appName The name of the application.
 * @property autoRollbackConfiguration Configuration block of the automatic rollback configuration associated with the deployment group (documented below).
 * @property autoscalingGroups Autoscaling groups associated with the deployment group.
 * @property blueGreenDeploymentConfig Configuration block of the blue/green deployment options for a deployment group (documented below).
 * @property deploymentConfigName The name of the group's deployment config. The default is "CodeDeployDefault.OneAtATime".
 * @property deploymentGroupName The name of the deployment group.
 * @property deploymentStyle Configuration block of the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer (documented below).
 * @property ec2TagFilters Tag filters associated with the deployment group. See the AWS docs for details.
 * @property ec2TagSets Configuration block(s) of Tag filters associated with the deployment group, which are also referred to as tag groups (documented below). See the AWS docs for details.
 * @property ecsService Configuration block(s) of the ECS services for a deployment group (documented below).
 * @property loadBalancerInfo Single configuration block of the load balancer to use in a blue/green deployment (documented below).
 * @property onPremisesInstanceTagFilters On premise tag filters associated with the group. See the AWS docs for details.
 * @property outdatedInstancesStrategy Configuration block of Indicates what happens when new Amazon EC2 instances are launched mid-deployment and do not receive the deployed application revision. Valid values are `UPDATE` and `IGNORE`. Defaults to `UPDATE`.
 * @property serviceRoleArn The service role ARN that allows deployments.
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property triggerConfigurations Configuration block(s) of the triggers for the deployment group (documented below).
 */
public data class DeploymentGroupArgs(
    public val alarmConfiguration: Output<DeploymentGroupAlarmConfigurationArgs>? = null,
    public val appName: Output<String>? = null,
    public val autoRollbackConfiguration: Output<DeploymentGroupAutoRollbackConfigurationArgs>? =
        null,
    public val autoscalingGroups: Output<List<String>>? = null,
    public val blueGreenDeploymentConfig: Output<DeploymentGroupBlueGreenDeploymentConfigArgs>? =
        null,
    public val deploymentConfigName: Output<String>? = null,
    public val deploymentGroupName: Output<String>? = null,
    public val deploymentStyle: Output<DeploymentGroupDeploymentStyleArgs>? = null,
    public val ec2TagFilters: Output<List<DeploymentGroupEc2TagFilterArgs>>? = null,
    public val ec2TagSets: Output<List<DeploymentGroupEc2TagSetArgs>>? = null,
    public val ecsService: Output<DeploymentGroupEcsServiceArgs>? = null,
    public val loadBalancerInfo: Output<DeploymentGroupLoadBalancerInfoArgs>? = null,
    public val onPremisesInstanceTagFilters: Output<List<DeploymentGroupOnPremisesInstanceTagFilterArgs>>? = null,
    public val outdatedInstancesStrategy: Output<String>? = null,
    public val serviceRoleArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val triggerConfigurations: Output<List<DeploymentGroupTriggerConfigurationArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.codedeploy.DeploymentGroupArgs> {
    override fun toJava(): com.pulumi.aws.codedeploy.DeploymentGroupArgs =
        com.pulumi.aws.codedeploy.DeploymentGroupArgs.builder()
            .alarmConfiguration(
                alarmConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .appName(appName?.applyValue({ args0 -> args0 }))
            .autoRollbackConfiguration(
                autoRollbackConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .autoscalingGroups(autoscalingGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .blueGreenDeploymentConfig(
                blueGreenDeploymentConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .deploymentConfigName(deploymentConfigName?.applyValue({ args0 -> args0 }))
            .deploymentGroupName(deploymentGroupName?.applyValue({ args0 -> args0 }))
            .deploymentStyle(deploymentStyle?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ec2TagFilters(
                ec2TagFilters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ec2TagSets(
                ec2TagSets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ecsService(ecsService?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .loadBalancerInfo(loadBalancerInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .onPremisesInstanceTagFilters(
                onPremisesInstanceTagFilters?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .outdatedInstancesStrategy(outdatedInstancesStrategy?.applyValue({ args0 -> args0 }))
            .serviceRoleArn(serviceRoleArn?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .triggerConfigurations(
                triggerConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [DeploymentGroupArgs].
 */
@PulumiTagMarker
public class DeploymentGroupArgsBuilder internal constructor() {
    private var alarmConfiguration: Output<DeploymentGroupAlarmConfigurationArgs>? = null

    private var appName: Output<String>? = null

    private var autoRollbackConfiguration: Output<DeploymentGroupAutoRollbackConfigurationArgs>? =
        null

    private var autoscalingGroups: Output<List<String>>? = null

    private var blueGreenDeploymentConfig: Output<DeploymentGroupBlueGreenDeploymentConfigArgs>? =
        null

    private var deploymentConfigName: Output<String>? = null

    private var deploymentGroupName: Output<String>? = null

    private var deploymentStyle: Output<DeploymentGroupDeploymentStyleArgs>? = null

    private var ec2TagFilters: Output<List<DeploymentGroupEc2TagFilterArgs>>? = null

    private var ec2TagSets: Output<List<DeploymentGroupEc2TagSetArgs>>? = null

    private var ecsService: Output<DeploymentGroupEcsServiceArgs>? = null

    private var loadBalancerInfo: Output<DeploymentGroupLoadBalancerInfoArgs>? = null

    private var onPremisesInstanceTagFilters:
        Output<List<DeploymentGroupOnPremisesInstanceTagFilterArgs>>? = null

    private var outdatedInstancesStrategy: Output<String>? = null

    private var serviceRoleArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var triggerConfigurations: Output<List<DeploymentGroupTriggerConfigurationArgs>>? = null

    /**
     * @param value Configuration block of alarms associated with the deployment group (documented below).
     */
    @JvmName("gmxixxsyrxtnfpqy")
    public suspend fun alarmConfiguration(`value`: Output<DeploymentGroupAlarmConfigurationArgs>) {
        this.alarmConfiguration = value
    }

    /**
     * @param value The name of the application.
     */
    @JvmName("gkwlwqfaprsowdrv")
    public suspend fun appName(`value`: Output<String>) {
        this.appName = value
    }

    /**
     * @param value Configuration block of the automatic rollback configuration associated with the deployment group (documented below).
     */
    @JvmName("tktwwxhnjhsekxtc")
    public suspend fun autoRollbackConfiguration(`value`: Output<DeploymentGroupAutoRollbackConfigurationArgs>) {
        this.autoRollbackConfiguration = value
    }

    /**
     * @param value Autoscaling groups associated with the deployment group.
     */
    @JvmName("wiigdfvywyyuysgt")
    public suspend fun autoscalingGroups(`value`: Output<List<String>>) {
        this.autoscalingGroups = value
    }

    @JvmName("pnpfbhbxlqdweqdw")
    public suspend fun autoscalingGroups(vararg values: Output<String>) {
        this.autoscalingGroups = Output.all(values.asList())
    }

    /**
     * @param values Autoscaling groups associated with the deployment group.
     */
    @JvmName("bnhyyxaqmdriolkx")
    public suspend fun autoscalingGroups(values: List<Output<String>>) {
        this.autoscalingGroups = Output.all(values)
    }

    /**
     * @param value Configuration block of the blue/green deployment options for a deployment group (documented below).
     */
    @JvmName("racgqsldkbwhhutn")
    public suspend fun blueGreenDeploymentConfig(`value`: Output<DeploymentGroupBlueGreenDeploymentConfigArgs>) {
        this.blueGreenDeploymentConfig = value
    }

    /**
     * @param value The name of the group's deployment config. The default is "CodeDeployDefault.OneAtATime".
     */
    @JvmName("yswauntedelgtnxj")
    public suspend fun deploymentConfigName(`value`: Output<String>) {
        this.deploymentConfigName = value
    }

    /**
     * @param value The name of the deployment group.
     */
    @JvmName("fbksatyelnylorya")
    public suspend fun deploymentGroupName(`value`: Output<String>) {
        this.deploymentGroupName = value
    }

    /**
     * @param value Configuration block of the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer (documented below).
     */
    @JvmName("gxyjefvucnsniulr")
    public suspend fun deploymentStyle(`value`: Output<DeploymentGroupDeploymentStyleArgs>) {
        this.deploymentStyle = value
    }

    /**
     * @param value Tag filters associated with the deployment group. See the AWS docs for details.
     */
    @JvmName("vliwikwthxonaslx")
    public suspend fun ec2TagFilters(`value`: Output<List<DeploymentGroupEc2TagFilterArgs>>) {
        this.ec2TagFilters = value
    }

    @JvmName("maatvypbtgeeqdct")
    public suspend fun ec2TagFilters(vararg values: Output<DeploymentGroupEc2TagFilterArgs>) {
        this.ec2TagFilters = Output.all(values.asList())
    }

    /**
     * @param values Tag filters associated with the deployment group. See the AWS docs for details.
     */
    @JvmName("hhjkpbjrtmkupweu")
    public suspend fun ec2TagFilters(values: List<Output<DeploymentGroupEc2TagFilterArgs>>) {
        this.ec2TagFilters = Output.all(values)
    }

    /**
     * @param value Configuration block(s) of Tag filters associated with the deployment group, which are also referred to as tag groups (documented below). See the AWS docs for details.
     */
    @JvmName("smwxerukyxwaixse")
    public suspend fun ec2TagSets(`value`: Output<List<DeploymentGroupEc2TagSetArgs>>) {
        this.ec2TagSets = value
    }

    @JvmName("twqsbptrrhtmtkpx")
    public suspend fun ec2TagSets(vararg values: Output<DeploymentGroupEc2TagSetArgs>) {
        this.ec2TagSets = Output.all(values.asList())
    }

    /**
     * @param values Configuration block(s) of Tag filters associated with the deployment group, which are also referred to as tag groups (documented below). See the AWS docs for details.
     */
    @JvmName("bvhobvjxbxtumewp")
    public suspend fun ec2TagSets(values: List<Output<DeploymentGroupEc2TagSetArgs>>) {
        this.ec2TagSets = Output.all(values)
    }

    /**
     * @param value Configuration block(s) of the ECS services for a deployment group (documented below).
     */
    @JvmName("gcpqefxmidmxloej")
    public suspend fun ecsService(`value`: Output<DeploymentGroupEcsServiceArgs>) {
        this.ecsService = value
    }

    /**
     * @param value Single configuration block of the load balancer to use in a blue/green deployment (documented below).
     */
    @JvmName("wfeeyrgkieythwgm")
    public suspend fun loadBalancerInfo(`value`: Output<DeploymentGroupLoadBalancerInfoArgs>) {
        this.loadBalancerInfo = value
    }

    /**
     * @param value On premise tag filters associated with the group. See the AWS docs for details.
     */
    @JvmName("dwgilonhoooaneke")
    public suspend fun onPremisesInstanceTagFilters(`value`: Output<List<DeploymentGroupOnPremisesInstanceTagFilterArgs>>) {
        this.onPremisesInstanceTagFilters = value
    }

    @JvmName("guarknyhbjcavqbb")
    public suspend fun onPremisesInstanceTagFilters(vararg values: Output<DeploymentGroupOnPremisesInstanceTagFilterArgs>) {
        this.onPremisesInstanceTagFilters = Output.all(values.asList())
    }

    /**
     * @param values On premise tag filters associated with the group. See the AWS docs for details.
     */
    @JvmName("nosrknubyimfkakm")
    public suspend fun onPremisesInstanceTagFilters(values: List<Output<DeploymentGroupOnPremisesInstanceTagFilterArgs>>) {
        this.onPremisesInstanceTagFilters = Output.all(values)
    }

    /**
     * @param value Configuration block of Indicates what happens when new Amazon EC2 instances are launched mid-deployment and do not receive the deployed application revision. Valid values are `UPDATE` and `IGNORE`. Defaults to `UPDATE`.
     */
    @JvmName("hjriunjsfbnsjwmw")
    public suspend fun outdatedInstancesStrategy(`value`: Output<String>) {
        this.outdatedInstancesStrategy = value
    }

    /**
     * @param value The service role ARN that allows deployments.
     */
    @JvmName("hpyeaxbsqiasjouj")
    public suspend fun serviceRoleArn(`value`: Output<String>) {
        this.serviceRoleArn = value
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("luugoaqntmeeeisr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Configuration block(s) of the triggers for the deployment group (documented below).
     */
    @JvmName("idmxqabhrepcjphn")
    public suspend fun triggerConfigurations(`value`: Output<List<DeploymentGroupTriggerConfigurationArgs>>) {
        this.triggerConfigurations = value
    }

    @JvmName("uqwktftuywutwxje")
    public suspend fun triggerConfigurations(vararg values: Output<DeploymentGroupTriggerConfigurationArgs>) {
        this.triggerConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Configuration block(s) of the triggers for the deployment group (documented below).
     */
    @JvmName("rvotlrgsoxdrexll")
    public suspend fun triggerConfigurations(values: List<Output<DeploymentGroupTriggerConfigurationArgs>>) {
        this.triggerConfigurations = Output.all(values)
    }

    /**
     * @param value Configuration block of alarms associated with the deployment group (documented below).
     */
    @JvmName("sqypxixhrmujpixj")
    public suspend fun alarmConfiguration(`value`: DeploymentGroupAlarmConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alarmConfiguration = mapped
    }

    /**
     * @param argument Configuration block of alarms associated with the deployment group (documented below).
     */
    @JvmName("aegwqvcjqurovikb")
    public suspend fun alarmConfiguration(argument: suspend DeploymentGroupAlarmConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = DeploymentGroupAlarmConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.alarmConfiguration = mapped
    }

    /**
     * @param value The name of the application.
     */
    @JvmName("brkisbirkuhirlnd")
    public suspend fun appName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appName = mapped
    }

    /**
     * @param value Configuration block of the automatic rollback configuration associated with the deployment group (documented below).
     */
    @JvmName("cuqghdhkqrcfumas")
    public suspend fun autoRollbackConfiguration(`value`: DeploymentGroupAutoRollbackConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRollbackConfiguration = mapped
    }

    /**
     * @param argument Configuration block of the automatic rollback configuration associated with the deployment group (documented below).
     */
    @JvmName("kxaoguduftxarant")
    public suspend fun autoRollbackConfiguration(argument: suspend DeploymentGroupAutoRollbackConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = DeploymentGroupAutoRollbackConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.autoRollbackConfiguration = mapped
    }

    /**
     * @param value Autoscaling groups associated with the deployment group.
     */
    @JvmName("ylwmwdfhlqjmuoho")
    public suspend fun autoscalingGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoscalingGroups = mapped
    }

    /**
     * @param values Autoscaling groups associated with the deployment group.
     */
    @JvmName("ursbbpahrxweujld")
    public suspend fun autoscalingGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.autoscalingGroups = mapped
    }

    /**
     * @param value Configuration block of the blue/green deployment options for a deployment group (documented below).
     */
    @JvmName("qplnjkcbtxygjcpo")
    public suspend fun blueGreenDeploymentConfig(`value`: DeploymentGroupBlueGreenDeploymentConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blueGreenDeploymentConfig = mapped
    }

    /**
     * @param argument Configuration block of the blue/green deployment options for a deployment group (documented below).
     */
    @JvmName("jeqlvtosqwbykbja")
    public suspend fun blueGreenDeploymentConfig(argument: suspend DeploymentGroupBlueGreenDeploymentConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DeploymentGroupBlueGreenDeploymentConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.blueGreenDeploymentConfig = mapped
    }

    /**
     * @param value The name of the group's deployment config. The default is "CodeDeployDefault.OneAtATime".
     */
    @JvmName("xoivtsmrhxoucsjs")
    public suspend fun deploymentConfigName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentConfigName = mapped
    }

    /**
     * @param value The name of the deployment group.
     */
    @JvmName("pcwwwbpfpdtmqysy")
    public suspend fun deploymentGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentGroupName = mapped
    }

    /**
     * @param value Configuration block of the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer (documented below).
     */
    @JvmName("qkqdwaytfuvrgobu")
    public suspend fun deploymentStyle(`value`: DeploymentGroupDeploymentStyleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentStyle = mapped
    }

    /**
     * @param argument Configuration block of the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer (documented below).
     */
    @JvmName("smrkuxntukksnopt")
    public suspend fun deploymentStyle(argument: suspend DeploymentGroupDeploymentStyleArgsBuilder.() -> Unit) {
        val toBeMapped = DeploymentGroupDeploymentStyleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deploymentStyle = mapped
    }

    /**
     * @param value Tag filters associated with the deployment group. See the AWS docs for details.
     */
    @JvmName("qgwltuneitulvxam")
    public suspend fun ec2TagFilters(`value`: List<DeploymentGroupEc2TagFilterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ec2TagFilters = mapped
    }

    /**
     * @param argument Tag filters associated with the deployment group. See the AWS docs for details.
     */
    @JvmName("uhuqmcgckxwqguhd")
    public suspend fun ec2TagFilters(argument: List<suspend DeploymentGroupEc2TagFilterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DeploymentGroupEc2TagFilterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ec2TagFilters = mapped
    }

    /**
     * @param argument Tag filters associated with the deployment group. See the AWS docs for details.
     */
    @JvmName("mmkhwiykyvvlmhru")
    public suspend fun ec2TagFilters(vararg argument: suspend DeploymentGroupEc2TagFilterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DeploymentGroupEc2TagFilterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ec2TagFilters = mapped
    }

    /**
     * @param argument Tag filters associated with the deployment group. See the AWS docs for details.
     */
    @JvmName("fottssadnjjvktgp")
    public suspend fun ec2TagFilters(argument: suspend DeploymentGroupEc2TagFilterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DeploymentGroupEc2TagFilterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ec2TagFilters = mapped
    }

    /**
     * @param values Tag filters associated with the deployment group. See the AWS docs for details.
     */
    @JvmName("mkkdtbighysunvoy")
    public suspend fun ec2TagFilters(vararg values: DeploymentGroupEc2TagFilterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ec2TagFilters = mapped
    }

    /**
     * @param value Configuration block(s) of Tag filters associated with the deployment group, which are also referred to as tag groups (documented below). See the AWS docs for details.
     */
    @JvmName("rifbwbavkkhkbelc")
    public suspend fun ec2TagSets(`value`: List<DeploymentGroupEc2TagSetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ec2TagSets = mapped
    }

    /**
     * @param argument Configuration block(s) of Tag filters associated with the deployment group, which are also referred to as tag groups (documented below). See the AWS docs for details.
     */
    @JvmName("hmobomqgjtkypglp")
    public suspend fun ec2TagSets(argument: List<suspend DeploymentGroupEc2TagSetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DeploymentGroupEc2TagSetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ec2TagSets = mapped
    }

    /**
     * @param argument Configuration block(s) of Tag filters associated with the deployment group, which are also referred to as tag groups (documented below). See the AWS docs for details.
     */
    @JvmName("vrfrivmhqvmvdxja")
    public suspend fun ec2TagSets(vararg argument: suspend DeploymentGroupEc2TagSetArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DeploymentGroupEc2TagSetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ec2TagSets = mapped
    }

    /**
     * @param argument Configuration block(s) of Tag filters associated with the deployment group, which are also referred to as tag groups (documented below). See the AWS docs for details.
     */
    @JvmName("wjneilkviegejlot")
    public suspend fun ec2TagSets(argument: suspend DeploymentGroupEc2TagSetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DeploymentGroupEc2TagSetArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ec2TagSets = mapped
    }

    /**
     * @param values Configuration block(s) of Tag filters associated with the deployment group, which are also referred to as tag groups (documented below). See the AWS docs for details.
     */
    @JvmName("xhnhffapwflqnywu")
    public suspend fun ec2TagSets(vararg values: DeploymentGroupEc2TagSetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ec2TagSets = mapped
    }

    /**
     * @param value Configuration block(s) of the ECS services for a deployment group (documented below).
     */
    @JvmName("aqrrtoaixwnrkshe")
    public suspend fun ecsService(`value`: DeploymentGroupEcsServiceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ecsService = mapped
    }

    /**
     * @param argument Configuration block(s) of the ECS services for a deployment group (documented below).
     */
    @JvmName("gphyhwohxrnkmmmu")
    public suspend fun ecsService(argument: suspend DeploymentGroupEcsServiceArgsBuilder.() -> Unit) {
        val toBeMapped = DeploymentGroupEcsServiceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ecsService = mapped
    }

    /**
     * @param value Single configuration block of the load balancer to use in a blue/green deployment (documented below).
     */
    @JvmName("mgodcygguhgenljc")
    public suspend fun loadBalancerInfo(`value`: DeploymentGroupLoadBalancerInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerInfo = mapped
    }

    /**
     * @param argument Single configuration block of the load balancer to use in a blue/green deployment (documented below).
     */
    @JvmName("negotjjbgpjguanp")
    public suspend fun loadBalancerInfo(argument: suspend DeploymentGroupLoadBalancerInfoArgsBuilder.() -> Unit) {
        val toBeMapped = DeploymentGroupLoadBalancerInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.loadBalancerInfo = mapped
    }

    /**
     * @param value On premise tag filters associated with the group. See the AWS docs for details.
     */
    @JvmName("ayyjaefpmlyqycyo")
    public suspend fun onPremisesInstanceTagFilters(`value`: List<DeploymentGroupOnPremisesInstanceTagFilterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onPremisesInstanceTagFilters = mapped
    }

    /**
     * @param argument On premise tag filters associated with the group. See the AWS docs for details.
     */
    @JvmName("ejmlabtlhtltoumb")
    public suspend fun onPremisesInstanceTagFilters(argument: List<suspend DeploymentGroupOnPremisesInstanceTagFilterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DeploymentGroupOnPremisesInstanceTagFilterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.onPremisesInstanceTagFilters = mapped
    }

    /**
     * @param argument On premise tag filters associated with the group. See the AWS docs for details.
     */
    @JvmName("xmobpcuvectayqnm")
    public suspend fun onPremisesInstanceTagFilters(vararg argument: suspend DeploymentGroupOnPremisesInstanceTagFilterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DeploymentGroupOnPremisesInstanceTagFilterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.onPremisesInstanceTagFilters = mapped
    }

    /**
     * @param argument On premise tag filters associated with the group. See the AWS docs for details.
     */
    @JvmName("rduxpleddpmqfgul")
    public suspend fun onPremisesInstanceTagFilters(argument: suspend DeploymentGroupOnPremisesInstanceTagFilterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DeploymentGroupOnPremisesInstanceTagFilterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.onPremisesInstanceTagFilters = mapped
    }

    /**
     * @param values On premise tag filters associated with the group. See the AWS docs for details.
     */
    @JvmName("ighaqamvjgdptuxe")
    public suspend fun onPremisesInstanceTagFilters(vararg values: DeploymentGroupOnPremisesInstanceTagFilterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onPremisesInstanceTagFilters = mapped
    }

    /**
     * @param value Configuration block of Indicates what happens when new Amazon EC2 instances are launched mid-deployment and do not receive the deployed application revision. Valid values are `UPDATE` and `IGNORE`. Defaults to `UPDATE`.
     */
    @JvmName("bqlssxasbjhccwho")
    public suspend fun outdatedInstancesStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outdatedInstancesStrategy = mapped
    }

    /**
     * @param value The service role ARN that allows deployments.
     */
    @JvmName("aigwheppkvaruqtr")
    public suspend fun serviceRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceRoleArn = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jpaivwryhtqapovm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lddgfngxaidjouye")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Configuration block(s) of the triggers for the deployment group (documented below).
     */
    @JvmName("lytnejvnniyknsim")
    public suspend fun triggerConfigurations(`value`: List<DeploymentGroupTriggerConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.triggerConfigurations = mapped
    }

    /**
     * @param argument Configuration block(s) of the triggers for the deployment group (documented below).
     */
    @JvmName("hxbskqdrxccdhcbj")
    public suspend fun triggerConfigurations(argument: List<suspend DeploymentGroupTriggerConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DeploymentGroupTriggerConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.triggerConfigurations = mapped
    }

    /**
     * @param argument Configuration block(s) of the triggers for the deployment group (documented below).
     */
    @JvmName("vxfdamatwbguheav")
    public suspend fun triggerConfigurations(vararg argument: suspend DeploymentGroupTriggerConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DeploymentGroupTriggerConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.triggerConfigurations = mapped
    }

    /**
     * @param argument Configuration block(s) of the triggers for the deployment group (documented below).
     */
    @JvmName("xgwftpwemrujuxdv")
    public suspend fun triggerConfigurations(argument: suspend DeploymentGroupTriggerConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DeploymentGroupTriggerConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.triggerConfigurations = mapped
    }

    /**
     * @param values Configuration block(s) of the triggers for the deployment group (documented below).
     */
    @JvmName("msrtntmugmqojdsi")
    public suspend fun triggerConfigurations(vararg values: DeploymentGroupTriggerConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.triggerConfigurations = mapped
    }

    internal fun build(): DeploymentGroupArgs = DeploymentGroupArgs(
        alarmConfiguration = alarmConfiguration,
        appName = appName,
        autoRollbackConfiguration = autoRollbackConfiguration,
        autoscalingGroups = autoscalingGroups,
        blueGreenDeploymentConfig = blueGreenDeploymentConfig,
        deploymentConfigName = deploymentConfigName,
        deploymentGroupName = deploymentGroupName,
        deploymentStyle = deploymentStyle,
        ec2TagFilters = ec2TagFilters,
        ec2TagSets = ec2TagSets,
        ecsService = ecsService,
        loadBalancerInfo = loadBalancerInfo,
        onPremisesInstanceTagFilters = onPremisesInstanceTagFilters,
        outdatedInstancesStrategy = outdatedInstancesStrategy,
        serviceRoleArn = serviceRoleArn,
        tags = tags,
        triggerConfigurations = triggerConfigurations,
    )
}
