@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codedeploy.kotlin.inputs

import com.pulumi.aws.codedeploy.inputs.DeploymentConfigTrafficRoutingConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property timeBasedCanary The time based canary configuration information. If `type` is `TimeBasedLinear`, use `time_based_linear` instead.
 * @property timeBasedLinear The time based linear configuration information. If `type` is `TimeBasedCanary`, use `time_based_canary` instead.
 * @property type Type of traffic routing config. One of `TimeBasedCanary`, `TimeBasedLinear`, `AllAtOnce`.
 */
public data class DeploymentConfigTrafficRoutingConfigArgs(
    public val timeBasedCanary: Output<DeploymentConfigTrafficRoutingConfigTimeBasedCanaryArgs>? =
        null,
    public val timeBasedLinear: Output<DeploymentConfigTrafficRoutingConfigTimeBasedLinearArgs>? =
        null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.codedeploy.inputs.DeploymentConfigTrafficRoutingConfigArgs> {
    override fun toJava(): com.pulumi.aws.codedeploy.inputs.DeploymentConfigTrafficRoutingConfigArgs =
        com.pulumi.aws.codedeploy.inputs.DeploymentConfigTrafficRoutingConfigArgs.builder()
            .timeBasedCanary(timeBasedCanary?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .timeBasedLinear(timeBasedLinear?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeploymentConfigTrafficRoutingConfigArgs].
 */
@PulumiTagMarker
public class DeploymentConfigTrafficRoutingConfigArgsBuilder internal constructor() {
    private var timeBasedCanary: Output<DeploymentConfigTrafficRoutingConfigTimeBasedCanaryArgs>? =
        null

    private var timeBasedLinear: Output<DeploymentConfigTrafficRoutingConfigTimeBasedLinearArgs>? =
        null

    private var type: Output<String>? = null

    /**
     * @param value The time based canary configuration information. If `type` is `TimeBasedLinear`, use `time_based_linear` instead.
     */
    @JvmName("lbuwpqibsdtclgqn")
    public suspend fun timeBasedCanary(`value`: Output<DeploymentConfigTrafficRoutingConfigTimeBasedCanaryArgs>) {
        this.timeBasedCanary = value
    }

    /**
     * @param value The time based linear configuration information. If `type` is `TimeBasedCanary`, use `time_based_canary` instead.
     */
    @JvmName("ncoeisnqwmcdrfmr")
    public suspend fun timeBasedLinear(`value`: Output<DeploymentConfigTrafficRoutingConfigTimeBasedLinearArgs>) {
        this.timeBasedLinear = value
    }

    /**
     * @param value Type of traffic routing config. One of `TimeBasedCanary`, `TimeBasedLinear`, `AllAtOnce`.
     */
    @JvmName("roembowwdiqchaan")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The time based canary configuration information. If `type` is `TimeBasedLinear`, use `time_based_linear` instead.
     */
    @JvmName("etpvknvmnskvjxjb")
    public suspend fun timeBasedCanary(`value`: DeploymentConfigTrafficRoutingConfigTimeBasedCanaryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeBasedCanary = mapped
    }

    /**
     * @param argument The time based canary configuration information. If `type` is `TimeBasedLinear`, use `time_based_linear` instead.
     */
    @JvmName("lapdyrkcmkguvktj")
    public suspend fun timeBasedCanary(argument: suspend DeploymentConfigTrafficRoutingConfigTimeBasedCanaryArgsBuilder.() -> Unit) {
        val toBeMapped = DeploymentConfigTrafficRoutingConfigTimeBasedCanaryArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.timeBasedCanary = mapped
    }

    /**
     * @param value The time based linear configuration information. If `type` is `TimeBasedCanary`, use `time_based_canary` instead.
     */
    @JvmName("aowrotupolvvaxqm")
    public suspend fun timeBasedLinear(`value`: DeploymentConfigTrafficRoutingConfigTimeBasedLinearArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeBasedLinear = mapped
    }

    /**
     * @param argument The time based linear configuration information. If `type` is `TimeBasedCanary`, use `time_based_canary` instead.
     */
    @JvmName("fmkjcasstltpjnfq")
    public suspend fun timeBasedLinear(argument: suspend DeploymentConfigTrafficRoutingConfigTimeBasedLinearArgsBuilder.() -> Unit) {
        val toBeMapped = DeploymentConfigTrafficRoutingConfigTimeBasedLinearArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.timeBasedLinear = mapped
    }

    /**
     * @param value Type of traffic routing config. One of `TimeBasedCanary`, `TimeBasedLinear`, `AllAtOnce`.
     */
    @JvmName("ovhqvjwskgnccdwm")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): DeploymentConfigTrafficRoutingConfigArgs =
        DeploymentConfigTrafficRoutingConfigArgs(
            timeBasedCanary = timeBasedCanary,
            timeBasedLinear = timeBasedLinear,
            type = type,
        )
}
