@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codedeploy.kotlin.inputs

import com.pulumi.aws.codedeploy.inputs.DeploymentConfigTrafficRoutingConfigTimeBasedLinearArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property interval The number of minutes between each incremental traffic shift of a `TimeBasedLinear` deployment.
 * @property percentage The percentage of traffic that is shifted at the start of each increment of a `TimeBasedLinear` deployment.
 */
public data class DeploymentConfigTrafficRoutingConfigTimeBasedLinearArgs(
    public val interval: Output<Int>? = null,
    public val percentage: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.codedeploy.inputs.DeploymentConfigTrafficRoutingConfigTimeBasedLinearArgs> {
    override fun toJava(): com.pulumi.aws.codedeploy.inputs.DeploymentConfigTrafficRoutingConfigTimeBasedLinearArgs =
        com.pulumi.aws.codedeploy.inputs.DeploymentConfigTrafficRoutingConfigTimeBasedLinearArgs.builder()
            .interval(interval?.applyValue({ args0 -> args0 }))
            .percentage(percentage?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeploymentConfigTrafficRoutingConfigTimeBasedLinearArgs].
 */
@PulumiTagMarker
public class DeploymentConfigTrafficRoutingConfigTimeBasedLinearArgsBuilder internal constructor() {
    private var interval: Output<Int>? = null

    private var percentage: Output<Int>? = null

    /**
     * @param value The number of minutes between each incremental traffic shift of a `TimeBasedLinear` deployment.
     */
    @JvmName("nwqggsepdwtanwsu")
    public suspend fun interval(`value`: Output<Int>) {
        this.interval = value
    }

    /**
     * @param value The percentage of traffic that is shifted at the start of each increment of a `TimeBasedLinear` deployment.
     */
    @JvmName("bkgpbyfqjjflhuxr")
    public suspend fun percentage(`value`: Output<Int>) {
        this.percentage = value
    }

    /**
     * @param value The number of minutes between each incremental traffic shift of a `TimeBasedLinear` deployment.
     */
    @JvmName("bfjdyrngbcqxgdot")
    public suspend fun interval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    /**
     * @param value The percentage of traffic that is shifted at the start of each increment of a `TimeBasedLinear` deployment.
     */
    @JvmName("itqkcmhndnnajfyh")
    public suspend fun percentage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.percentage = mapped
    }

    internal fun build(): DeploymentConfigTrafficRoutingConfigTimeBasedLinearArgs =
        DeploymentConfigTrafficRoutingConfigTimeBasedLinearArgs(
            interval = interval,
            percentage = percentage,
        )
}
