@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codedeploy.kotlin.inputs

import com.pulumi.aws.codedeploy.inputs.DeploymentGroupAlarmConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property alarms A list of alarms configured for the deployment group. _A maximum of 10 alarms can be added to a deployment group_.
 * @property enabled Indicates whether the alarm configuration is enabled. This option is useful when you want to temporarily deactivate alarm monitoring for a deployment group without having to add the same alarms again later.
 * @property ignorePollAlarmFailure Indicates whether a deployment should continue if information about the current state of alarms cannot be retrieved from CloudWatch. The default value is `false`.
 */
public data class DeploymentGroupAlarmConfigurationArgs(
    public val alarms: Output<List<String>>? = null,
    public val enabled: Output<Boolean>? = null,
    public val ignorePollAlarmFailure: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.codedeploy.inputs.DeploymentGroupAlarmConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.codedeploy.inputs.DeploymentGroupAlarmConfigurationArgs =
        com.pulumi.aws.codedeploy.inputs.DeploymentGroupAlarmConfigurationArgs.builder()
            .alarms(alarms?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .ignorePollAlarmFailure(ignorePollAlarmFailure?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeploymentGroupAlarmConfigurationArgs].
 */
@PulumiTagMarker
public class DeploymentGroupAlarmConfigurationArgsBuilder internal constructor() {
    private var alarms: Output<List<String>>? = null

    private var enabled: Output<Boolean>? = null

    private var ignorePollAlarmFailure: Output<Boolean>? = null

    /**
     * @param value A list of alarms configured for the deployment group. _A maximum of 10 alarms can be added to a deployment group_.
     */
    @JvmName("laqxfslfteyhksst")
    public suspend fun alarms(`value`: Output<List<String>>) {
        this.alarms = value
    }

    @JvmName("mcmbgqbkjdtdafdx")
    public suspend fun alarms(vararg values: Output<String>) {
        this.alarms = Output.all(values.asList())
    }

    /**
     * @param values A list of alarms configured for the deployment group. _A maximum of 10 alarms can be added to a deployment group_.
     */
    @JvmName("nwwnbvcyacrdwhst")
    public suspend fun alarms(values: List<Output<String>>) {
        this.alarms = Output.all(values)
    }

    /**
     * @param value Indicates whether the alarm configuration is enabled. This option is useful when you want to temporarily deactivate alarm monitoring for a deployment group without having to add the same alarms again later.
     */
    @JvmName("ehaqaxmrufqwkgbd")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Indicates whether a deployment should continue if information about the current state of alarms cannot be retrieved from CloudWatch. The default value is `false`.
     */
    @JvmName("yejrrnaffsbwxodd")
    public suspend fun ignorePollAlarmFailure(`value`: Output<Boolean>) {
        this.ignorePollAlarmFailure = value
    }

    /**
     * @param value A list of alarms configured for the deployment group. _A maximum of 10 alarms can be added to a deployment group_.
     */
    @JvmName("vexsymaqaywfxumo")
    public suspend fun alarms(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alarms = mapped
    }

    /**
     * @param values A list of alarms configured for the deployment group. _A maximum of 10 alarms can be added to a deployment group_.
     */
    @JvmName("bphvknudepavdfjo")
    public suspend fun alarms(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alarms = mapped
    }

    /**
     * @param value Indicates whether the alarm configuration is enabled. This option is useful when you want to temporarily deactivate alarm monitoring for a deployment group without having to add the same alarms again later.
     */
    @JvmName("ixcnmndhoatqsooy")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Indicates whether a deployment should continue if information about the current state of alarms cannot be retrieved from CloudWatch. The default value is `false`.
     */
    @JvmName("mwowwlntwsuqsmwj")
    public suspend fun ignorePollAlarmFailure(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignorePollAlarmFailure = mapped
    }

    internal fun build(): DeploymentGroupAlarmConfigurationArgs =
        DeploymentGroupAlarmConfigurationArgs(
            alarms = alarms,
            enabled = enabled,
            ignorePollAlarmFailure = ignorePollAlarmFailure,
        )
}
