@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codedeploy.kotlin.inputs

import com.pulumi.aws.codedeploy.inputs.DeploymentGroupBlueGreenDeploymentConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property deploymentReadyOption Information about the action to take when newly provisioned instances are ready to receive traffic in a blue/green deployment (documented below).
 * @property greenFleetProvisioningOption Information about how instances are provisioned for a replacement environment in a blue/green deployment (documented below).
 * @property terminateBlueInstancesOnDeploymentSuccess Information about whether to terminate instances in the original fleet during a blue/green deployment (documented below).
 * _Only one `blue_green_deployment_config` is allowed_.
 */
public data class DeploymentGroupBlueGreenDeploymentConfigArgs(
    public val deploymentReadyOption: Output<DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgs>? = null,
    public val greenFleetProvisioningOption: Output<DeploymentGroupBlueGreenDeploymentConfigGreenFleetProvisioningOptionArgs>? = null,
    public val terminateBlueInstancesOnDeploymentSuccess: Output<DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.codedeploy.inputs.DeploymentGroupBlueGreenDeploymentConfigArgs> {
    override fun toJava(): com.pulumi.aws.codedeploy.inputs.DeploymentGroupBlueGreenDeploymentConfigArgs =
        com.pulumi.aws.codedeploy.inputs.DeploymentGroupBlueGreenDeploymentConfigArgs.builder()
            .deploymentReadyOption(
                deploymentReadyOption?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .greenFleetProvisioningOption(
                greenFleetProvisioningOption?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .terminateBlueInstancesOnDeploymentSuccess(
                terminateBlueInstancesOnDeploymentSuccess?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [DeploymentGroupBlueGreenDeploymentConfigArgs].
 */
@PulumiTagMarker
public class DeploymentGroupBlueGreenDeploymentConfigArgsBuilder internal constructor() {
    private var deploymentReadyOption:
        Output<DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgs>? = null

    private var greenFleetProvisioningOption:
        Output<DeploymentGroupBlueGreenDeploymentConfigGreenFleetProvisioningOptionArgs>? = null

    private var terminateBlueInstancesOnDeploymentSuccess:
        Output<DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgs>? =
        null

    /**
     * @param value Information about the action to take when newly provisioned instances are ready to receive traffic in a blue/green deployment (documented below).
     */
    @JvmName("lllmryduluwufqbn")
    public suspend fun deploymentReadyOption(`value`: Output<DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgs>) {
        this.deploymentReadyOption = value
    }

    /**
     * @param value Information about how instances are provisioned for a replacement environment in a blue/green deployment (documented below).
     */
    @JvmName("gfvffmeenxiumyvo")
    public suspend fun greenFleetProvisioningOption(`value`: Output<DeploymentGroupBlueGreenDeploymentConfigGreenFleetProvisioningOptionArgs>) {
        this.greenFleetProvisioningOption = value
    }

    /**
     * @param value Information about whether to terminate instances in the original fleet during a blue/green deployment (documented below).
     * _Only one `blue_green_deployment_config` is allowed_.
     */
    @JvmName("luyulijttphrmahc")
    public suspend fun terminateBlueInstancesOnDeploymentSuccess(`value`: Output<DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgs>) {
        this.terminateBlueInstancesOnDeploymentSuccess = value
    }

    /**
     * @param value Information about the action to take when newly provisioned instances are ready to receive traffic in a blue/green deployment (documented below).
     */
    @JvmName("uigxaljqwjfivcym")
    public suspend fun deploymentReadyOption(`value`: DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentReadyOption = mapped
    }

    /**
     * @param argument Information about the action to take when newly provisioned instances are ready to receive traffic in a blue/green deployment (documented below).
     */
    @JvmName("meujwlbrmtnweplh")
    public suspend fun deploymentReadyOption(argument: suspend DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgsBuilder.() -> Unit) {
        val toBeMapped =
            DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.deploymentReadyOption = mapped
    }

    /**
     * @param value Information about how instances are provisioned for a replacement environment in a blue/green deployment (documented below).
     */
    @JvmName("ykoaplaefkepvgga")
    public suspend fun greenFleetProvisioningOption(`value`: DeploymentGroupBlueGreenDeploymentConfigGreenFleetProvisioningOptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.greenFleetProvisioningOption = mapped
    }

    /**
     * @param argument Information about how instances are provisioned for a replacement environment in a blue/green deployment (documented below).
     */
    @JvmName("ebtwhoeiffmildet")
    public suspend fun greenFleetProvisioningOption(argument: suspend DeploymentGroupBlueGreenDeploymentConfigGreenFleetProvisioningOptionArgsBuilder.() -> Unit) {
        val toBeMapped =
            DeploymentGroupBlueGreenDeploymentConfigGreenFleetProvisioningOptionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.greenFleetProvisioningOption = mapped
    }

    /**
     * @param value Information about whether to terminate instances in the original fleet during a blue/green deployment (documented below).
     * _Only one `blue_green_deployment_config` is allowed_.
     */
    @JvmName("vsvlkcqwiwoxaqjf")
    public suspend fun terminateBlueInstancesOnDeploymentSuccess(`value`: DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.terminateBlueInstancesOnDeploymentSuccess = mapped
    }

    /**
     * @param argument Information about whether to terminate instances in the original fleet during a blue/green deployment (documented below).
     * _Only one `blue_green_deployment_config` is allowed_.
     */
    @JvmName("dxisturysdwymsgj")
    public suspend fun terminateBlueInstancesOnDeploymentSuccess(argument: suspend DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgsBuilder.() -> Unit) {
        val toBeMapped =
            DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.terminateBlueInstancesOnDeploymentSuccess = mapped
    }

    internal fun build(): DeploymentGroupBlueGreenDeploymentConfigArgs =
        DeploymentGroupBlueGreenDeploymentConfigArgs(
            deploymentReadyOption = deploymentReadyOption,
            greenFleetProvisioningOption = greenFleetProvisioningOption,
            terminateBlueInstancesOnDeploymentSuccess = terminateBlueInstancesOnDeploymentSuccess,
        )
}
