@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codedeploy.kotlin.inputs

import com.pulumi.aws.codedeploy.inputs.DeploymentGroupEc2TagSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property ec2TagFilters Tag filters associated with the deployment group. See the AWS docs for details.
 */
public data class DeploymentGroupEc2TagSetArgs(
    public val ec2TagFilters: Output<List<DeploymentGroupEc2TagSetEc2TagFilterArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.codedeploy.inputs.DeploymentGroupEc2TagSetArgs> {
    override fun toJava(): com.pulumi.aws.codedeploy.inputs.DeploymentGroupEc2TagSetArgs =
        com.pulumi.aws.codedeploy.inputs.DeploymentGroupEc2TagSetArgs.builder()
            .ec2TagFilters(
                ec2TagFilters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [DeploymentGroupEc2TagSetArgs].
 */
@PulumiTagMarker
public class DeploymentGroupEc2TagSetArgsBuilder internal constructor() {
    private var ec2TagFilters: Output<List<DeploymentGroupEc2TagSetEc2TagFilterArgs>>? = null

    /**
     * @param value Tag filters associated with the deployment group. See the AWS docs for details.
     */
    @JvmName("febmngedehpecpny")
    public suspend fun ec2TagFilters(`value`: Output<List<DeploymentGroupEc2TagSetEc2TagFilterArgs>>) {
        this.ec2TagFilters = value
    }

    @JvmName("lhrwamvdycxrokgf")
    public suspend fun ec2TagFilters(vararg values: Output<DeploymentGroupEc2TagSetEc2TagFilterArgs>) {
        this.ec2TagFilters = Output.all(values.asList())
    }

    /**
     * @param values Tag filters associated with the deployment group. See the AWS docs for details.
     */
    @JvmName("hpdwbmfotqaevahi")
    public suspend fun ec2TagFilters(values: List<Output<DeploymentGroupEc2TagSetEc2TagFilterArgs>>) {
        this.ec2TagFilters = Output.all(values)
    }

    /**
     * @param value Tag filters associated with the deployment group. See the AWS docs for details.
     */
    @JvmName("hpbffccdtighxutl")
    public suspend fun ec2TagFilters(`value`: List<DeploymentGroupEc2TagSetEc2TagFilterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ec2TagFilters = mapped
    }

    /**
     * @param argument Tag filters associated with the deployment group. See the AWS docs for details.
     */
    @JvmName("fxgevntrquamxipk")
    public suspend fun ec2TagFilters(argument: List<suspend DeploymentGroupEc2TagSetEc2TagFilterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DeploymentGroupEc2TagSetEc2TagFilterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ec2TagFilters = mapped
    }

    /**
     * @param argument Tag filters associated with the deployment group. See the AWS docs for details.
     */
    @JvmName("aykmxmdossgbtpgk")
    public suspend fun ec2TagFilters(vararg argument: suspend DeploymentGroupEc2TagSetEc2TagFilterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DeploymentGroupEc2TagSetEc2TagFilterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ec2TagFilters = mapped
    }

    /**
     * @param argument Tag filters associated with the deployment group. See the AWS docs for details.
     */
    @JvmName("grpjeuamtdiopiuv")
    public suspend fun ec2TagFilters(argument: suspend DeploymentGroupEc2TagSetEc2TagFilterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DeploymentGroupEc2TagSetEc2TagFilterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ec2TagFilters = mapped
    }

    /**
     * @param values Tag filters associated with the deployment group. See the AWS docs for details.
     */
    @JvmName("vodqbamfnmnsmgpb")
    public suspend fun ec2TagFilters(vararg values: DeploymentGroupEc2TagSetEc2TagFilterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ec2TagFilters = mapped
    }

    internal fun build(): DeploymentGroupEc2TagSetArgs = DeploymentGroupEc2TagSetArgs(
        ec2TagFilters = ec2TagFilters,
    )
}
