@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codedeploy.kotlin.inputs

import com.pulumi.aws.codedeploy.inputs.DeploymentGroupEcsServiceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clusterName The name of the ECS cluster.
 * @property serviceName The name of the ECS service.
 */
public data class DeploymentGroupEcsServiceArgs(
    public val clusterName: Output<String>,
    public val serviceName: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.codedeploy.inputs.DeploymentGroupEcsServiceArgs> {
    override fun toJava(): com.pulumi.aws.codedeploy.inputs.DeploymentGroupEcsServiceArgs =
        com.pulumi.aws.codedeploy.inputs.DeploymentGroupEcsServiceArgs.builder()
            .clusterName(clusterName.applyValue({ args0 -> args0 }))
            .serviceName(serviceName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeploymentGroupEcsServiceArgs].
 */
@PulumiTagMarker
public class DeploymentGroupEcsServiceArgsBuilder internal constructor() {
    private var clusterName: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value The name of the ECS cluster.
     */
    @JvmName("ophinmgwhpviushh")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value The name of the ECS service.
     */
    @JvmName("duneedcwtejpdngt")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value The name of the ECS cluster.
     */
    @JvmName("ucycttqttnhbvsyx")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value The name of the ECS service.
     */
    @JvmName("yfhcdncewxdvfqcl")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): DeploymentGroupEcsServiceArgs = DeploymentGroupEcsServiceArgs(
        clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
