@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codedeploy.kotlin.inputs

import com.pulumi.aws.codedeploy.inputs.DeploymentGroupLoadBalancerInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property elbInfos The Classic Elastic Load Balancer to use in a deployment. Conflicts with `target_group_info` and `target_group_pair_info`.
 * @property targetGroupInfos The (Application/Network Load Balancer) target group to use in a deployment. Conflicts with `elb_info` and `target_group_pair_info`.
 * @property targetGroupPairInfo The (Application/Network Load Balancer) target group pair to use in a deployment. Conflicts with `elb_info` and `target_group_info`.
 */
public data class DeploymentGroupLoadBalancerInfoArgs(
    public val elbInfos: Output<List<DeploymentGroupLoadBalancerInfoElbInfoArgs>>? = null,
    public val targetGroupInfos: Output<List<DeploymentGroupLoadBalancerInfoTargetGroupInfoArgs>>? =
        null,
    public val targetGroupPairInfo: Output<DeploymentGroupLoadBalancerInfoTargetGroupPairInfoArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.codedeploy.inputs.DeploymentGroupLoadBalancerInfoArgs> {
    override fun toJava(): com.pulumi.aws.codedeploy.inputs.DeploymentGroupLoadBalancerInfoArgs =
        com.pulumi.aws.codedeploy.inputs.DeploymentGroupLoadBalancerInfoArgs.builder()
            .elbInfos(
                elbInfos?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .targetGroupInfos(
                targetGroupInfos?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .targetGroupPairInfo(
                targetGroupPairInfo?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DeploymentGroupLoadBalancerInfoArgs].
 */
@PulumiTagMarker
public class DeploymentGroupLoadBalancerInfoArgsBuilder internal constructor() {
    private var elbInfos: Output<List<DeploymentGroupLoadBalancerInfoElbInfoArgs>>? = null

    private var targetGroupInfos: Output<List<DeploymentGroupLoadBalancerInfoTargetGroupInfoArgs>>? =
        null

    private var targetGroupPairInfo: Output<DeploymentGroupLoadBalancerInfoTargetGroupPairInfoArgs>? =
        null

    /**
     * @param value The Classic Elastic Load Balancer to use in a deployment. Conflicts with `target_group_info` and `target_group_pair_info`.
     */
    @JvmName("yajtwtsrwdlujyvp")
    public suspend fun elbInfos(`value`: Output<List<DeploymentGroupLoadBalancerInfoElbInfoArgs>>) {
        this.elbInfos = value
    }

    @JvmName("scnipriqtswvipkl")
    public suspend fun elbInfos(vararg values: Output<DeploymentGroupLoadBalancerInfoElbInfoArgs>) {
        this.elbInfos = Output.all(values.asList())
    }

    /**
     * @param values The Classic Elastic Load Balancer to use in a deployment. Conflicts with `target_group_info` and `target_group_pair_info`.
     */
    @JvmName("whlavjurxjrsynxl")
    public suspend fun elbInfos(values: List<Output<DeploymentGroupLoadBalancerInfoElbInfoArgs>>) {
        this.elbInfos = Output.all(values)
    }

    /**
     * @param value The (Application/Network Load Balancer) target group to use in a deployment. Conflicts with `elb_info` and `target_group_pair_info`.
     */
    @JvmName("hwpolfcekbhhudkj")
    public suspend fun targetGroupInfos(`value`: Output<List<DeploymentGroupLoadBalancerInfoTargetGroupInfoArgs>>) {
        this.targetGroupInfos = value
    }

    @JvmName("tfjicpqjvxsriphx")
    public suspend fun targetGroupInfos(vararg values: Output<DeploymentGroupLoadBalancerInfoTargetGroupInfoArgs>) {
        this.targetGroupInfos = Output.all(values.asList())
    }

    /**
     * @param values The (Application/Network Load Balancer) target group to use in a deployment. Conflicts with `elb_info` and `target_group_pair_info`.
     */
    @JvmName("jcwnkisgriusxhpt")
    public suspend fun targetGroupInfos(values: List<Output<DeploymentGroupLoadBalancerInfoTargetGroupInfoArgs>>) {
        this.targetGroupInfos = Output.all(values)
    }

    /**
     * @param value The (Application/Network Load Balancer) target group pair to use in a deployment. Conflicts with `elb_info` and `target_group_info`.
     */
    @JvmName("cfpqmtkgkuftqdct")
    public suspend fun targetGroupPairInfo(`value`: Output<DeploymentGroupLoadBalancerInfoTargetGroupPairInfoArgs>) {
        this.targetGroupPairInfo = value
    }

    /**
     * @param value The Classic Elastic Load Balancer to use in a deployment. Conflicts with `target_group_info` and `target_group_pair_info`.
     */
    @JvmName("lhrpcrlvaytehqml")
    public suspend fun elbInfos(`value`: List<DeploymentGroupLoadBalancerInfoElbInfoArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elbInfos = mapped
    }

    /**
     * @param argument The Classic Elastic Load Balancer to use in a deployment. Conflicts with `target_group_info` and `target_group_pair_info`.
     */
    @JvmName("ggtgbuudylwsjrfh")
    public suspend fun elbInfos(argument: List<suspend DeploymentGroupLoadBalancerInfoElbInfoArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DeploymentGroupLoadBalancerInfoElbInfoArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.elbInfos = mapped
    }

    /**
     * @param argument The Classic Elastic Load Balancer to use in a deployment. Conflicts with `target_group_info` and `target_group_pair_info`.
     */
    @JvmName("pxdartcrjurtagwi")
    public suspend fun elbInfos(vararg argument: suspend DeploymentGroupLoadBalancerInfoElbInfoArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DeploymentGroupLoadBalancerInfoElbInfoArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.elbInfos = mapped
    }

    /**
     * @param argument The Classic Elastic Load Balancer to use in a deployment. Conflicts with `target_group_info` and `target_group_pair_info`.
     */
    @JvmName("kjqobucafniisudt")
    public suspend fun elbInfos(argument: suspend DeploymentGroupLoadBalancerInfoElbInfoArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DeploymentGroupLoadBalancerInfoElbInfoArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.elbInfos = mapped
    }

    /**
     * @param values The Classic Elastic Load Balancer to use in a deployment. Conflicts with `target_group_info` and `target_group_pair_info`.
     */
    @JvmName("nxokuomdxgvmsaqv")
    public suspend fun elbInfos(vararg values: DeploymentGroupLoadBalancerInfoElbInfoArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.elbInfos = mapped
    }

    /**
     * @param value The (Application/Network Load Balancer) target group to use in a deployment. Conflicts with `elb_info` and `target_group_pair_info`.
     */
    @JvmName("tsroxtpfpjrlvdfd")
    public suspend fun targetGroupInfos(`value`: List<DeploymentGroupLoadBalancerInfoTargetGroupInfoArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetGroupInfos = mapped
    }

    /**
     * @param argument The (Application/Network Load Balancer) target group to use in a deployment. Conflicts with `elb_info` and `target_group_pair_info`.
     */
    @JvmName("houvapnspjekxcib")
    public suspend fun targetGroupInfos(argument: List<suspend DeploymentGroupLoadBalancerInfoTargetGroupInfoArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DeploymentGroupLoadBalancerInfoTargetGroupInfoArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.targetGroupInfos = mapped
    }

    /**
     * @param argument The (Application/Network Load Balancer) target group to use in a deployment. Conflicts with `elb_info` and `target_group_pair_info`.
     */
    @JvmName("kysrtfeqijytgcfe")
    public suspend fun targetGroupInfos(vararg argument: suspend DeploymentGroupLoadBalancerInfoTargetGroupInfoArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DeploymentGroupLoadBalancerInfoTargetGroupInfoArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.targetGroupInfos = mapped
    }

    /**
     * @param argument The (Application/Network Load Balancer) target group to use in a deployment. Conflicts with `elb_info` and `target_group_pair_info`.
     */
    @JvmName("wbaeqhbesqoufkcp")
    public suspend fun targetGroupInfos(argument: suspend DeploymentGroupLoadBalancerInfoTargetGroupInfoArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DeploymentGroupLoadBalancerInfoTargetGroupInfoArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.targetGroupInfos = mapped
    }

    /**
     * @param values The (Application/Network Load Balancer) target group to use in a deployment. Conflicts with `elb_info` and `target_group_pair_info`.
     */
    @JvmName("tkdlxytwtfqwwfmc")
    public suspend fun targetGroupInfos(vararg values: DeploymentGroupLoadBalancerInfoTargetGroupInfoArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetGroupInfos = mapped
    }

    /**
     * @param value The (Application/Network Load Balancer) target group pair to use in a deployment. Conflicts with `elb_info` and `target_group_info`.
     */
    @JvmName("tptoeyihxsbcoxan")
    public suspend fun targetGroupPairInfo(`value`: DeploymentGroupLoadBalancerInfoTargetGroupPairInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetGroupPairInfo = mapped
    }

    /**
     * @param argument The (Application/Network Load Balancer) target group pair to use in a deployment. Conflicts with `elb_info` and `target_group_info`.
     */
    @JvmName("jqwgmrljcdwgibhh")
    public suspend fun targetGroupPairInfo(argument: suspend DeploymentGroupLoadBalancerInfoTargetGroupPairInfoArgsBuilder.() -> Unit) {
        val toBeMapped = DeploymentGroupLoadBalancerInfoTargetGroupPairInfoArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.targetGroupPairInfo = mapped
    }

    internal fun build(): DeploymentGroupLoadBalancerInfoArgs = DeploymentGroupLoadBalancerInfoArgs(
        elbInfos = elbInfos,
        targetGroupInfos = targetGroupInfos,
        targetGroupPairInfo = targetGroupPairInfo,
    )
}
