@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codedeploy.kotlin.inputs

import com.pulumi.aws.codedeploy.inputs.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property prodTrafficRoute Configuration block for the production traffic route (documented below).
 * @property targetGroups Configuration blocks for a target group within a target group pair (documented below).
 * @property testTrafficRoute Configuration block for the test traffic route (documented below).
 */
public data class DeploymentGroupLoadBalancerInfoTargetGroupPairInfoArgs(
    public val prodTrafficRoute: Output<DeploymentGroupLoadBalancerInfoTargetGroupPairInfoProdTrafficRouteArgs>,
    public val targetGroups: Output<List<DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArgs>>,
    public val testTrafficRoute: Output<DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTestTrafficRouteArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.codedeploy.inputs.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoArgs> {
    override fun toJava(): com.pulumi.aws.codedeploy.inputs.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoArgs =
        com.pulumi.aws.codedeploy.inputs.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoArgs.builder()
            .prodTrafficRoute(prodTrafficRoute.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .targetGroups(
                targetGroups.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .testTrafficRoute(
                testTrafficRoute?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DeploymentGroupLoadBalancerInfoTargetGroupPairInfoArgs].
 */
@PulumiTagMarker
public class DeploymentGroupLoadBalancerInfoTargetGroupPairInfoArgsBuilder internal constructor() {
    private var prodTrafficRoute:
        Output<DeploymentGroupLoadBalancerInfoTargetGroupPairInfoProdTrafficRouteArgs>? = null

    private var targetGroups:
        Output<List<DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArgs>>? = null

    private var testTrafficRoute:
        Output<DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTestTrafficRouteArgs>? = null

    /**
     * @param value Configuration block for the production traffic route (documented below).
     */
    @JvmName("fevdltvfcgpshqib")
    public suspend fun prodTrafficRoute(`value`: Output<DeploymentGroupLoadBalancerInfoTargetGroupPairInfoProdTrafficRouteArgs>) {
        this.prodTrafficRoute = value
    }

    /**
     * @param value Configuration blocks for a target group within a target group pair (documented below).
     */
    @JvmName("tesddbfstluwdjfn")
    public suspend fun targetGroups(`value`: Output<List<DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArgs>>) {
        this.targetGroups = value
    }

    @JvmName("odqdbiwkuuxbnimg")
    public suspend fun targetGroups(vararg values: Output<DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArgs>) {
        this.targetGroups = Output.all(values.asList())
    }

    /**
     * @param values Configuration blocks for a target group within a target group pair (documented below).
     */
    @JvmName("krpblporoitngdoe")
    public suspend fun targetGroups(values: List<Output<DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArgs>>) {
        this.targetGroups = Output.all(values)
    }

    /**
     * @param value Configuration block for the test traffic route (documented below).
     */
    @JvmName("rlroadknwniywwnr")
    public suspend fun testTrafficRoute(`value`: Output<DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTestTrafficRouteArgs>) {
        this.testTrafficRoute = value
    }

    /**
     * @param value Configuration block for the production traffic route (documented below).
     */
    @JvmName("orcaiwmmfcivvlif")
    public suspend fun prodTrafficRoute(`value`: DeploymentGroupLoadBalancerInfoTargetGroupPairInfoProdTrafficRouteArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.prodTrafficRoute = mapped
    }

    /**
     * @param argument Configuration block for the production traffic route (documented below).
     */
    @JvmName("mtmjylybyetubiag")
    public suspend fun prodTrafficRoute(argument: suspend DeploymentGroupLoadBalancerInfoTargetGroupPairInfoProdTrafficRouteArgsBuilder.() -> Unit) {
        val toBeMapped =
            DeploymentGroupLoadBalancerInfoTargetGroupPairInfoProdTrafficRouteArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.prodTrafficRoute = mapped
    }

    /**
     * @param value Configuration blocks for a target group within a target group pair (documented below).
     */
    @JvmName("qifwlotbetttyvrg")
    public suspend fun targetGroups(`value`: List<DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetGroups = mapped
    }

    /**
     * @param argument Configuration blocks for a target group within a target group pair (documented below).
     */
    @JvmName("swxjhsugspwqadho")
    public suspend fun targetGroups(argument: List<suspend DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targetGroups = mapped
    }

    /**
     * @param argument Configuration blocks for a target group within a target group pair (documented below).
     */
    @JvmName("fxrptwnpfbsjqckc")
    public suspend fun targetGroups(vararg argument: suspend DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targetGroups = mapped
    }

    /**
     * @param argument Configuration blocks for a target group within a target group pair (documented below).
     */
    @JvmName("trijaaiedcitcgrk")
    public suspend fun targetGroups(argument: suspend DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.targetGroups = mapped
    }

    /**
     * @param values Configuration blocks for a target group within a target group pair (documented below).
     */
    @JvmName("fwpjnorscvlngnsm")
    public suspend fun targetGroups(vararg values: DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetGroups = mapped
    }

    /**
     * @param value Configuration block for the test traffic route (documented below).
     */
    @JvmName("dspejruumlfagubt")
    public suspend fun testTrafficRoute(`value`: DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTestTrafficRouteArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.testTrafficRoute = mapped
    }

    /**
     * @param argument Configuration block for the test traffic route (documented below).
     */
    @JvmName("kkbndgbvtbdlcrst")
    public suspend fun testTrafficRoute(argument: suspend DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTestTrafficRouteArgsBuilder.() -> Unit) {
        val toBeMapped =
            DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTestTrafficRouteArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.testTrafficRoute = mapped
    }

    internal fun build(): DeploymentGroupLoadBalancerInfoTargetGroupPairInfoArgs =
        DeploymentGroupLoadBalancerInfoTargetGroupPairInfoArgs(
            prodTrafficRoute = prodTrafficRoute ?: throw PulumiNullFieldException("prodTrafficRoute"),
            targetGroups = targetGroups ?: throw PulumiNullFieldException("targetGroups"),
            testTrafficRoute = testTrafficRoute,
        )
}
