@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codedeploy.kotlin.inputs

import com.pulumi.aws.codedeploy.inputs.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoProdTrafficRouteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property listenerArns List of Amazon Resource Names (ARNs) of the load balancer listeners. Must contain exactly one listener ARN.
 */
public data class DeploymentGroupLoadBalancerInfoTargetGroupPairInfoProdTrafficRouteArgs(
    public val listenerArns: Output<List<String>>,
) :
    ConvertibleToJava<com.pulumi.aws.codedeploy.inputs.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoProdTrafficRouteArgs> {
    override fun toJava(): com.pulumi.aws.codedeploy.inputs.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoProdTrafficRouteArgs =
        com.pulumi.aws.codedeploy.inputs.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoProdTrafficRouteArgs.builder()
            .listenerArns(listenerArns.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DeploymentGroupLoadBalancerInfoTargetGroupPairInfoProdTrafficRouteArgs].
 */
@PulumiTagMarker
public class DeploymentGroupLoadBalancerInfoTargetGroupPairInfoProdTrafficRouteArgsBuilder internal constructor() {
    private var listenerArns: Output<List<String>>? = null

    /**
     * @param value List of Amazon Resource Names (ARNs) of the load balancer listeners. Must contain exactly one listener ARN.
     */
    @JvmName("liyxycuynkcivrow")
    public suspend fun listenerArns(`value`: Output<List<String>>) {
        this.listenerArns = value
    }

    @JvmName("esktkmarojxyqccw")
    public suspend fun listenerArns(vararg values: Output<String>) {
        this.listenerArns = Output.all(values.asList())
    }

    /**
     * @param values List of Amazon Resource Names (ARNs) of the load balancer listeners. Must contain exactly one listener ARN.
     */
    @JvmName("ryopxfmdyynptuwa")
    public suspend fun listenerArns(values: List<Output<String>>) {
        this.listenerArns = Output.all(values)
    }

    /**
     * @param value List of Amazon Resource Names (ARNs) of the load balancer listeners. Must contain exactly one listener ARN.
     */
    @JvmName("cvqgvohelnkpyspd")
    public suspend fun listenerArns(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.listenerArns = mapped
    }

    /**
     * @param values List of Amazon Resource Names (ARNs) of the load balancer listeners. Must contain exactly one listener ARN.
     */
    @JvmName("oqqjgxbdbpxfyyfk")
    public suspend fun listenerArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.listenerArns = mapped
    }

    internal fun build(): DeploymentGroupLoadBalancerInfoTargetGroupPairInfoProdTrafficRouteArgs =
        DeploymentGroupLoadBalancerInfoTargetGroupPairInfoProdTrafficRouteArgs(
            listenerArns = listenerArns ?: throw PulumiNullFieldException("listenerArns"),
        )
}
