@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codedeploy.kotlin.inputs

import com.pulumi.aws.codedeploy.inputs.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the target group.
 */
public data class DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArgs(
    public val name: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.codedeploy.inputs.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArgs> {
    override fun toJava(): com.pulumi.aws.codedeploy.inputs.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArgs =
        com.pulumi.aws.codedeploy.inputs.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArgs.builder()
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArgs].
 */
@PulumiTagMarker
public class DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value Name of the target group.
     */
    @JvmName("traarkblpfijrdsl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the target group.
     */
    @JvmName("nrawhmmrnvyqaenr")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArgs =
        DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArgs(
            name = name ?: throw PulumiNullFieldException("name"),
        )
}
