@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codedeploy.kotlin.inputs

import com.pulumi.aws.codedeploy.inputs.DeploymentGroupOnPremisesInstanceTagFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key The key of the tag filter.
 * @property type The type of the tag filter, either `KEY_ONLY`, `VALUE_ONLY`, or `KEY_AND_VALUE`.
 * @property value The value of the tag filter.
 */
public data class DeploymentGroupOnPremisesInstanceTagFilterArgs(
    public val key: Output<String>? = null,
    public val type: Output<String>? = null,
    public val `value`: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.codedeploy.inputs.DeploymentGroupOnPremisesInstanceTagFilterArgs> {
    override fun toJava(): com.pulumi.aws.codedeploy.inputs.DeploymentGroupOnPremisesInstanceTagFilterArgs =
        com.pulumi.aws.codedeploy.inputs.DeploymentGroupOnPremisesInstanceTagFilterArgs.builder()
            .key(key?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeploymentGroupOnPremisesInstanceTagFilterArgs].
 */
@PulumiTagMarker
public class DeploymentGroupOnPremisesInstanceTagFilterArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var type: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The key of the tag filter.
     */
    @JvmName("entqtiiwyoicrvvi")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The type of the tag filter, either `KEY_ONLY`, `VALUE_ONLY`, or `KEY_AND_VALUE`.
     */
    @JvmName("ctcmyluahowocgir")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The value of the tag filter.
     */
    @JvmName("vrdaqwmjnbbbcydt")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The key of the tag filter.
     */
    @JvmName("ftjnmwtjeohrhhmh")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The type of the tag filter, either `KEY_ONLY`, `VALUE_ONLY`, or `KEY_AND_VALUE`.
     */
    @JvmName("llmiqbbhssjeliet")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The value of the tag filter.
     */
    @JvmName("tbsqaokeebtlfbui")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): DeploymentGroupOnPremisesInstanceTagFilterArgs =
        DeploymentGroupOnPremisesInstanceTagFilterArgs(
            key = key,
            type = type,
            `value` = `value`,
        )
}
