@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codedeploy.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property timeBasedCanary The time based canary configuration information. If `type` is `TimeBasedLinear`, use `time_based_linear` instead.
 * @property timeBasedLinear The time based linear configuration information. If `type` is `TimeBasedCanary`, use `time_based_canary` instead.
 * @property type Type of traffic routing config. One of `TimeBasedCanary`, `TimeBasedLinear`, `AllAtOnce`.
 */
public data class DeploymentConfigTrafficRoutingConfig(
    public val timeBasedCanary: DeploymentConfigTrafficRoutingConfigTimeBasedCanary? = null,
    public val timeBasedLinear: DeploymentConfigTrafficRoutingConfigTimeBasedLinear? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codedeploy.outputs.DeploymentConfigTrafficRoutingConfig): DeploymentConfigTrafficRoutingConfig = DeploymentConfigTrafficRoutingConfig(
            timeBasedCanary = javaType.timeBasedCanary().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentConfigTrafficRoutingConfigTimeBasedCanary.Companion.toKotlin(args0)
                })
            }).orElse(null),
            timeBasedLinear = javaType.timeBasedLinear().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentConfigTrafficRoutingConfigTimeBasedLinear.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
