@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codedeploy.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property interval The number of minutes between the first and second traffic shifts of a `TimeBasedCanary` deployment.
 * @property percentage The percentage of traffic to shift in the first increment of a `TimeBasedCanary` deployment.
 */
public data class DeploymentConfigTrafficRoutingConfigTimeBasedCanary(
    public val interval: Int? = null,
    public val percentage: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codedeploy.outputs.DeploymentConfigTrafficRoutingConfigTimeBasedCanary): DeploymentConfigTrafficRoutingConfigTimeBasedCanary =
            DeploymentConfigTrafficRoutingConfigTimeBasedCanary(
                interval = javaType.interval().map({ args0 -> args0 }).orElse(null),
                percentage = javaType.percentage().map({ args0 -> args0 }).orElse(null),
            )
    }
}
