@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codedeploy.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property alarms A list of alarms configured for the deployment group. _A maximum of 10 alarms can be added to a deployment group_.
 * @property enabled Indicates whether the alarm configuration is enabled. This option is useful when you want to temporarily deactivate alarm monitoring for a deployment group without having to add the same alarms again later.
 * @property ignorePollAlarmFailure Indicates whether a deployment should continue if information about the current state of alarms cannot be retrieved from CloudWatch. The default value is `false`.
 */
public data class DeploymentGroupAlarmConfiguration(
    public val alarms: List<String>? = null,
    public val enabled: Boolean? = null,
    public val ignorePollAlarmFailure: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codedeploy.outputs.DeploymentGroupAlarmConfiguration): DeploymentGroupAlarmConfiguration = DeploymentGroupAlarmConfiguration(
            alarms = javaType.alarms().map({ args0 -> args0 }),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            ignorePollAlarmFailure = javaType.ignorePollAlarmFailure().map({ args0 -> args0 }).orElse(null),
        )
    }
}
