@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codedeploy.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property deploymentReadyOption Information about the action to take when newly provisioned instances are ready to receive traffic in a blue/green deployment (documented below).
 * @property greenFleetProvisioningOption Information about how instances are provisioned for a replacement environment in a blue/green deployment (documented below).
 * @property terminateBlueInstancesOnDeploymentSuccess Information about whether to terminate instances in the original fleet during a blue/green deployment (documented below).
 * _Only one `blue_green_deployment_config` is allowed_.
 */
public data class DeploymentGroupBlueGreenDeploymentConfig(
    public val deploymentReadyOption: DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOption? =
        null,
    public val greenFleetProvisioningOption: DeploymentGroupBlueGreenDeploymentConfigGreenFleetProvisioningOption? = null,
    public val terminateBlueInstancesOnDeploymentSuccess: DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccess? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codedeploy.outputs.DeploymentGroupBlueGreenDeploymentConfig): DeploymentGroupBlueGreenDeploymentConfig = DeploymentGroupBlueGreenDeploymentConfig(
            deploymentReadyOption = javaType.deploymentReadyOption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOption.Companion.toKotlin(args0)
                })
            }).orElse(null),
            greenFleetProvisioningOption = javaType.greenFleetProvisioningOption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupBlueGreenDeploymentConfigGreenFleetProvisioningOption.Companion.toKotlin(args0)
                })
            }).orElse(null),
            terminateBlueInstancesOnDeploymentSuccess = javaType.terminateBlueInstancesOnDeploymentSuccess().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccess.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
