@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codedeploy.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property action The action to take on instances in the original environment after a successful blue/green deployment.
 * * `TERMINATE`: Instances are terminated after a specified wait time.
 * * `KEEP_ALIVE`: Instances are left running after they are deregistered from the load balancer and removed from the deployment group.
 * @property terminationWaitTimeInMinutes The number of minutes to wait after a successful blue/green deployment before terminating instances from the original environment.
 */
public data class DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccess(
    public val action: String? = null,
    public val terminationWaitTimeInMinutes: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codedeploy.outputs.DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccess): DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccess =
            DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccess(
                action = javaType.action().map({ args0 -> args0 }).orElse(null),
                terminationWaitTimeInMinutes = javaType.terminationWaitTimeInMinutes().map({ args0 ->
                    args0
                }).orElse(null),
            )
    }
}
